/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.FPVariable;
import de.unijena.bioinf.graphUtils.tree.PostOrderTraversal;
import de.unijena.bioinf.graphUtils.tree.Tree;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class FingerprintTree
implements Cloneable {
    protected Tree<FPVariable> root;
    protected TIntObjectHashMap<FPVariable> varMap;
    protected ArrayList<Tree<FPVariable>> nodes;
    protected double[] frequencies;

    public FingerprintTree(Tree<FPVariable> root) {
        this.root = root;
        this.varMap = new TIntObjectHashMap();
        this.nodes = new ArrayList();
        for (Tree node : PostOrderTraversal.create(root)) {
            this.varMap.put(((FPVariable)node.getLabel()).to, node.getLabel());
            this.nodes.add((Tree<FPVariable>)node);
        }
    }

    public Tree<FPVariable> getRoot() {
        return this.root;
    }

    public FingerprintTree clone() {
        return new FingerprintTree((Tree<FPVariable>)((Tree)PostOrderTraversal.create(this.root).call((PostOrderTraversal.Call)new PostOrderTraversal.Call<Tree<FPVariable>, Tree<FPVariable>>(){

            public Tree<FPVariable> call(Tree<FPVariable> vertex, List<Tree<FPVariable>> values, boolean isRoot) {
                FPVariable cloned = ((FPVariable)vertex.getLabel()).clone();
                Tree node = new Tree((Object)cloned);
                for (Tree<FPVariable> child : values) {
                    node.addChild(child);
                }
                return node;
            }
        })));
    }
}

