/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.ConditionalProbabilitiesEstimator;
import de.unijena.bioinf.fingerid.pvalues.DotParser;
import de.unijena.bioinf.fingerid.pvalues.FPVariable;
import de.unijena.bioinf.fingerid.pvalues.FingerprintTree;
import de.unijena.bioinf.fingerid.pvalues.TreeDP;
import de.unijena.bioinf.graphUtils.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;

public class Main {
    public static void main(String[] args) {
        try {
            FingerprintTree tree = new DotParser().parseFromFile(new File(args[1]));
            new ConditionalProbabilitiesEstimator(tree).estimate(Main.readFingerprints(new File(args[0])));
            Iterator<boolean[]> fps = Main.readFingerprints(new File(args[2]));
            boolean[] real = (boolean[])fps.next().clone();
            boolean[] predicted = fps.next();
            int distance = 0;
            for (Tree<FPVariable> var : tree.nodes) {
                int k = ((FPVariable)var.getLabel()).to;
                if (real[k] == predicted[k]) continue;
                ++distance;
            }
            System.out.println(distance);
            System.out.println(new TreeDP(tree).computeUnitScores(predicted, distance));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Iterator<boolean[]> readFingerprints(File file) throws IOException {
        final BufferedReader reader = new BufferedReader(new FileReader(file));
        final String firstLine = reader.readLine();
        int column = 0;
        int fplen = 0;
        for (int i = 0; i < firstLine.length(); ++i) {
            char c;
            boolean isfp = false;
            int n = firstLine.length() - i;
            for (fplen = 0; fplen < n && ((c = firstLine.charAt(i + fplen)) == '1' || c == '0'); ++fplen) {
            }
            if (fplen >= 50) break;
            if (firstLine.charAt(i) != '\t') continue;
            ++column;
        }
        final int fpcol = column;
        final int fplength = fplen;
        final boolean[] fp = new boolean[fplength];
        return new Iterator<boolean[]>(){
            private String currentLine;
            {
                this.currentLine = firstLine;
            }

            @Override
            public boolean hasNext() {
                return this.currentLine != null;
            }

            @Override
            public boolean[] next() {
                int i = 0;
                if (fpcol > 0) {
                    int c = fpcol;
                    for (i = 0; i < this.currentLine.length(); ++i) {
                        if (this.currentLine.charAt(i) != '\t' || --c > 0) continue;
                        ++i;
                        break;
                    }
                }
                for (int k = 0; k < fplength; ++k) {
                    fp[k] = this.currentLine.charAt(i + k) == '1';
                }
                try {
                    this.currentLine = reader.readLine();
                    if (this.currentLine == null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return fp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

