/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import java.math.BigDecimal;

final class Probability {
    private int exp;
    private double base;
    static final Probability ONE = new Probability(1.0);
    static final Probability ZERO = new Probability(0.0);

    Probability(double value) {
        if (value == 0.0) {
            this.exp = 0;
            this.base = 0.0;
        } else {
            boolean negative = false;
            if (value < 0.0) {
                value = -value;
                negative = true;
            }
            double log = Math.log10(value);
            this.exp = (int)log;
            this.base = value / Math.pow(10.0, this.exp);
            if (negative) {
                this.base = -this.base;
            }
        }
    }

    public int getExp() {
        return this.exp;
    }

    public double getBase() {
        return this.base;
    }

    private Probability(double value, int exp) {
        if (value == 0.0) {
            this.exp = 0;
            this.base = 0.0;
        } else {
            boolean negative = false;
            if (value < 0.0) {
                value = -value;
                negative = true;
            }
            double log = Math.log10(value);
            this.exp = (int)log;
            this.base = value / Math.pow(10.0, this.exp);
            this.exp += exp;
            if (negative) {
                this.base = -this.base;
            }
        }
    }

    boolean isZeroProbability() {
        return this.exp == 0 && this.base == 0.0;
    }

    Probability add(Probability prob2) {
        if (this.isZeroProbability()) {
            return prob2;
        }
        if (prob2.isZeroProbability()) {
            return this;
        }
        int expDiff = this.exp - prob2.exp;
        if (expDiff > 0) {
            return new Probability(this.base + prob2.base * Math.pow(10.0, -expDiff), this.exp);
        }
        if (expDiff < 0) {
            return new Probability(prob2.base + this.base * Math.pow(10.0, expDiff), prob2.exp);
        }
        return new Probability(this.base + prob2.base, this.exp);
    }

    Probability add(double prob2) {
        Probability tmpProb = new Probability(prob2);
        return this.add(tmpProb);
    }

    Probability subtract(Probability prob2) {
        if (this.isZeroProbability()) {
            return prob2;
        }
        if (prob2.isZeroProbability()) {
            return this;
        }
        int expDiff = this.exp - prob2.exp;
        if (expDiff > 0) {
            return new Probability(this.base - prob2.base * Math.pow(10.0, -expDiff), this.exp);
        }
        if (expDiff < 0) {
            return new Probability(prob2.base - this.base * Math.pow(10.0, expDiff), prob2.exp);
        }
        return new Probability(this.base - prob2.base, this.exp);
    }

    Probability subtract(double prob2) {
        Probability tmpProb = new Probability(prob2);
        return this.subtract(tmpProb);
    }

    Probability multiply(Probability prob2) {
        double prod = this.base * prob2.base;
        if (prod == 0.0) {
            return new Probability(0.0);
        }
        int exp = this.exp + prob2.exp;
        return new Probability(prod, exp);
    }

    Probability multiply(double prob2) {
        Probability tmpProb = new Probability(prob2);
        return this.multiply(tmpProb);
    }

    double toDouble() {
        return this.base * Math.pow(10.0, this.exp);
    }

    BigDecimal toBigDecimal() {
        return new BigDecimal(this.base).scaleByPowerOfTen(this.exp);
    }

    public String toString() {
        return this.toBigDecimal().stripTrailingZeros().toString();
    }
}

