/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.FPVariable;
import de.unijena.bioinf.fingerid.pvalues.FingerprintTree;
import de.unijena.bioinf.fingerid.pvalues.Probability;
import de.unijena.bioinf.graphUtils.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class TreeDP {
    final HashMap<Integer, DPTableUnit> tableMap;
    final ArrayList<DPTableUnit> tables;
    final FingerprintTree tree;

    public TreeDP(FingerprintTree tree) {
        this.tree = tree;
        this.tableMap = new HashMap();
        this.tables = new ArrayList();
        for (Tree<FPVariable> var : tree.nodes) {
            DPTableUnit tab = new DPTableUnit(var);
            this.tableMap.put(((FPVariable)var.getLabel()).to, tab);
            this.tables.add(tab);
        }
    }

    private static boolean checkProbability(Probability[] table) {
        Probability sum = Probability.ZERO;
        for (int k = 0; k < table.length; ++k) {
            sum = sum.add(table[k]);
        }
        return sum.getExp() <= 0;
    }

    public long computePlattScores(boolean[] query, int scale, double[] scoreForZero, double[] scoreForOne, double score) {
        int[] iscoreForZero = new int[scoreForZero.length];
        int[] iscoreForOne = new int[scoreForOne.length];
        for (int k = 0; k < iscoreForOne.length; ++k) {
            iscoreForOne[k] = (int)Math.round(scoreForOne[k] * (double)scale);
            iscoreForZero[k] = (int)Math.round(scoreForZero[k] * (double)scale);
        }
        int iscore = (int)Math.ceil(score * (double)scale);
        for (DPTableUnit table : this.tables) {
            int d = table.node.degree();
            if (d == 0) {
                this.leafPlatt(table, query, iscoreForZero, iscoreForOne);
                continue;
            }
            if (d == 1) {
                this.innerVertexPlatt(table, this.tableMap.get(((FPVariable)((Tree)((DPTableUnit)table).node.children().get((int)0)).getLabel()).to), query, iscoreForZero, iscoreForOne, iscore);
                continue;
            }
            DPTableUnit[] tables = new DPTableUnit[d];
            int k = 0;
            for (Tree childNode : table.node.children()) {
                tables[k++] = this.tableMap.get(((FPVariable)childNode.getLabel()).to);
            }
            this.multipleChildrenVertexPlatt(table, tables, query, iscoreForZero, iscoreForOne, iscore);
        }
        return this.rootPlatt(this.tableMap.get(((FPVariable)this.tree.root.getLabel()).to), iscore).getExp();
    }

    public long computeUnitScores(boolean[] query, int score) {
        for (DPTableUnit table : this.tables) {
            int d = table.node.degree();
            if (d == 0) {
                this.leafUnit(table, query);
                continue;
            }
            if (d == 1) {
                this.innerVertexUnit(table, this.tableMap.get(((FPVariable)((Tree)((DPTableUnit)table).node.children().get((int)0)).getLabel()).to), query, score);
                continue;
            }
            DPTableUnit[] tables = new DPTableUnit[d];
            int k = 0;
            for (Tree childNode : table.node.children()) {
                tables[k++] = this.tableMap.get(((FPVariable)childNode.getLabel()).to);
            }
            this.multipleChildrenVertexUnit(table, tables, query, score);
        }
        return this.rootUnit(this.tableMap.get(((FPVariable)this.tree.root.getLabel()).to), score).getExp();
    }

    private Probability rootUnit(DPTableUnit table, int score) {
        Probability pvalue = Probability.ZERO;
        for (int k = 0; k <= score; ++k) {
            pvalue = pvalue.add(table.forOne[k]).add(table.forZero[k]);
        }
        return pvalue;
    }

    private void multipleChildrenVertexUnit(DPTableUnit table, DPTableUnit[] child, boolean[] query, int score) {
        DPTableUnit[] pseudoChilds = new DPTableUnit[child.length];
        int capas = 0;
        for (int k = 0; k < child.length; ++k) {
            pseudoChilds[k] = new DPTableUnit((Tree<FPVariable>)table.node);
            this.innerVertexUnit(pseudoChilds[k], child[k], query, score);
            child[k].clear();
            capas += pseudoChilds[k].capaOne;
            assert (pseudoChilds[k].capaOne == pseudoChilds[k].capaZero);
        }
        capas = Math.min(capas, score + 1);
        DPTableUnit temp = new DPTableUnit((Tree<FPVariable>)table.node);
        temp.reserve(capas);
        table.reserve(capas);
        pseudoChilds[0].copyTo(temp);
        for (int k = 1; k < child.length; ++k) {
            int N = Math.min(score + 1, capas);
            for (int d = 0; d < N; ++d) {
                int M = Math.min(d, pseudoChilds[k].capaOne - 1);
                for (int e = 0; e <= M; ++e) {
                    ((DPTableUnit)table).forOne[d] = table.forOne[d].add(temp.forOne[d - e].multiply(pseudoChilds[k].forOne[e]));
                    ((DPTableUnit)table).forZero[d] = table.forZero[d].add(temp.forZero[d - e].multiply(pseudoChilds[k].forZero[e]));
                }
            }
            table.copyTo(temp);
            Arrays.fill(table.forZero, Probability.ZERO);
            Arrays.fill(table.forOne, Probability.ZERO);
        }
        temp.copyTo(table);
        for (DPTableUnit pchild : pseudoChilds) {
            pchild.clear();
        }
        assert (TreeDP.checkProbability(table.forOne));
        assert (TreeDP.checkProbability(table.forZero));
    }

    private void innerVertexUnit(DPTableUnit table, DPTableUnit child, boolean[] query, int score) {
        FPVariable V = child.variable;
        boolean u = query[V.from];
        boolean v = query[V.to];
        int N = Math.min(score, child.capaOne);
        assert (child.capaOne == child.capaZero);
        table.reserve(N + 1);
        for (int d = 0; d < N; ++d) {
            ((DPTableUnit)table).forOne[d + (u ? 0 : 1)] = V.PII.multiply(child.forOne[d]).add(V.PoI.multiply(child.forZero[d]));
            ((DPTableUnit)table).forZero[d + (u ? 1 : 0)] = V.PIo.multiply(child.forOne[d]).add(V.Poo.multiply(child.forZero[d]));
        }
        assert (TreeDP.checkProbability(table.forOne));
        assert (TreeDP.checkProbability(table.forZero));
        child.clear();
    }

    private void leafUnit(DPTableUnit table, boolean[] query) {
        FPVariable V = table.variable;
        boolean v = query[((DPTableUnit)table).variable.to];
        table.reserve(2);
        if (v) {
            ((DPTableUnit)table).forOne[0] = V.I;
            ((DPTableUnit)table).forZero[1] = V.o;
        } else {
            ((DPTableUnit)table).forOne[1] = V.I;
            ((DPTableUnit)table).forZero[0] = V.o;
        }
        assert (TreeDP.checkProbability(table.forOne));
        assert (TreeDP.checkProbability(table.forZero));
    }

    private void leafPlatt(DPTableUnit table, boolean[] query, int[] scoreForZero, int[] scoreForOne) {
        FPVariable V = table.variable;
        int i = ((DPTableUnit)table).variable.to;
        table.reserve(scoreForZero[i] + 1, scoreForOne[i] + 1);
        ((DPTableUnit)table).forOne[scoreForOne[i]] = V.I;
        ((DPTableUnit)table).forZero[scoreForZero[i]] = V.o;
        assert (TreeDP.checkProbability(table.forOne));
        assert (TreeDP.checkProbability(table.forZero));
    }

    private void innerVertexPlatt(DPTableUnit table, DPTableUnit child, boolean[] query, int[] scoreForZero, int[] scoreForOne, int score) {
        FPVariable V = child.variable;
        int i = ((DPTableUnit)child).variable.from;
        int Z = Math.min(score, Math.max(child.capaOne - 1, child.capaZero - 1) + scoreForZero[i]) + 1;
        int O = Math.min(score, Math.max(child.capaOne - 1, child.capaZero - 1) + scoreForOne[i]) + 1;
        table.reserve(Z, O);
        int childZero = Math.min(score + 1, child.capaZero);
        for (int d = 0; d < childZero; ++d) {
            if (d + scoreForOne[i] <= score) {
                ((DPTableUnit)table).forOne[d + scoreForOne[i]] = table.forOne[d + scoreForOne[i]].add(V.PoI.multiply(child.forZero[d]));
            }
            if (d + scoreForZero[i] > score) continue;
            ((DPTableUnit)table).forZero[d + scoreForZero[i]] = table.forZero[d + scoreForZero[i]].add(V.Poo.multiply(child.forZero[d]));
        }
        int childOne = Math.min(score + 1, child.capaOne);
        for (int d = 0; d < childOne; ++d) {
            if (d + scoreForOne[i] <= score) {
                ((DPTableUnit)table).forOne[d + scoreForOne[i]] = table.forOne[d + scoreForOne[i]].add(V.PII.multiply(child.forOne[d]));
            }
            if (d + scoreForZero[i] > score) continue;
            ((DPTableUnit)table).forZero[d + scoreForZero[i]] = table.forZero[d + scoreForZero[i]].add(V.PIo.multiply(child.forOne[d]));
        }
        assert (TreeDP.checkProbability(table.forOne));
        assert (TreeDP.checkProbability(table.forZero));
        child.clear();
    }

    private void multipleChildrenVertexPlatt(DPTableUnit table, DPTableUnit[] child, boolean[] query, int[] scoreForZero, int[] scoreForOne, int score) {
        DPTableUnit[] pseudoChilds = new DPTableUnit[child.length];
        int capaOnes = 0;
        int capaZeros = 0;
        for (int k = 0; k < child.length; ++k) {
            pseudoChilds[k] = new DPTableUnit((Tree<FPVariable>)table.node);
            this.innerVertexPlatt(pseudoChilds[k], child[k], query, scoreForZero, scoreForOne, score);
            child[k].clear();
            capaOnes += pseudoChilds[k].capaOne;
            capaZeros += pseudoChilds[k].capaZero;
        }
        DPTableUnit temp = new DPTableUnit((Tree<FPVariable>)table.node);
        temp.reserve(Math.min(score + 1, capaZeros), Math.min(score + 1, capaOnes));
        table.reserve(Math.min(score + 1, capaZeros), Math.min(score + 1, capaOnes));
        pseudoChilds[0].copyTo(temp);
        for (int k = 1; k < child.length; ++k) {
            int e;
            int d;
            for (d = 0; d < temp.capaOne; ++d) {
                if (temp.forOne[d].isZeroProbability()) continue;
                for (e = 0; e < pseudoChilds[k].capaOne && d + e <= score; ++e) {
                    ((DPTableUnit)table).forOne[d + e] = table.forOne[d + e].add(temp.forOne[d].multiply(pseudoChilds[k].forOne[e]));
                }
            }
            for (d = 0; d < temp.capaZero; ++d) {
                if (temp.forZero[d].isZeroProbability()) continue;
                for (e = 0; e < pseudoChilds[k].capaZero && d + e <= score; ++e) {
                    ((DPTableUnit)table).forZero[d + e] = table.forZero[d + e].add(temp.forZero[d].multiply(pseudoChilds[k].forZero[e]));
                }
            }
            table.copyTo(temp);
            Arrays.fill(table.forZero, Probability.ZERO);
            Arrays.fill(table.forOne, Probability.ZERO);
        }
        temp.copyTo(table);
        for (DPTableUnit pchild : pseudoChilds) {
            pchild.clear();
        }
        assert (TreeDP.checkProbability(table.forOne));
        assert (TreeDP.checkProbability(table.forZero));
    }

    private Probability rootPlatt(DPTableUnit table, int score) {
        Probability pvalue = Probability.ZERO;
        for (int k = 0; k <= score; ++k) {
            pvalue = pvalue.add(table.forOne[k]).add(table.forZero[k]);
        }
        return pvalue;
    }

    protected static final class DPTableUnit {
        private final Tree<FPVariable> node;
        private final FPVariable variable;
        private Probability[] forZero;
        private Probability[] forOne;
        private int capaOne;
        private int capaZero;

        public DPTableUnit(Tree<FPVariable> node) {
            this.node = node;
            this.variable = (FPVariable)node.getLabel();
        }

        void reserve(int capa) {
            this.reserve(capa, capa);
        }

        void reserve(int zeros, int ones) {
            this.capaOne = ones;
            this.capaZero = zeros;
            this.forZero = new Probability[this.capaZero];
            Arrays.fill(this.forZero, Probability.ZERO);
            this.forOne = new Probability[this.capaOne];
            Arrays.fill(this.forOne, Probability.ZERO);
        }

        void clear() {
            this.forOne = null;
            this.forZero = null;
        }

        void copyTo(DPTableUnit other) {
            System.arraycopy(this.forOne, 0, other.forOne, 0, this.forOne.length);
            System.arraycopy(this.forZero, 0, other.forZero, 0, this.forZero.length);
        }
    }
}

