/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid.pvalues;

import de.unijena.bioinf.fingerid.pvalues.FPVariable;
import de.unijena.bioinf.fingerid.pvalues.FingerprintTree;
import de.unijena.bioinf.fingerid.pvalues.Probability;
import de.unijena.bioinf.graphUtils.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;

public class TreeDPSparse {
    final HashMap<Integer, DPTableSparse> tableMap;
    final ArrayList<DPTableSparse> tables;
    final FingerprintTree tree;

    public TreeDPSparse(FingerprintTree tree) {
        this.tree = tree;
        this.tableMap = new HashMap();
        this.tables = new ArrayList();
        for (Tree<FPVariable> var : tree.nodes) {
            DPTableSparse tab = new DPTableSparse(var);
            this.tableMap.put(((FPVariable)var.getLabel()).to, tab);
            this.tables.add(tab);
        }
    }

    private static boolean checkProbability(SparseMap table) {
        Probability sum = Probability.ZERO;
        for (int i = 0; i < table.size; ++i) {
            sum = sum.add(table.get(table.keys[i]));
        }
        return sum.getExp() <= 0;
    }

    public long computePlattScores(boolean[] query, int scale, double[] scoreForZero, double[] scoreForOne, double score) {
        int[] iscoreForZero = new int[scoreForZero.length];
        int[] iscoreForOne = new int[scoreForOne.length];
        for (int k = 0; k < iscoreForOne.length; ++k) {
            iscoreForOne[k] = (int)Math.round(scoreForOne[k] * (double)scale);
            iscoreForZero[k] = (int)Math.round(scoreForZero[k] * (double)scale);
        }
        int iscore = (int)Math.ceil(score * (double)scale);
        for (DPTableSparse table : this.tables) {
            int d = table.node.degree();
            if (d == 0) {
                this.leafPlatt(table, query, iscoreForZero, iscoreForOne);
                continue;
            }
            if (d == 1) {
                this.innerVertexPlatt(table, this.tableMap.get(((FPVariable)((Tree)((DPTableSparse)table).node.children().get((int)0)).getLabel()).to), query, iscoreForZero, iscoreForOne, iscore);
                continue;
            }
            DPTableSparse[] tables = new DPTableSparse[d];
            int k = 0;
            for (Tree childNode : table.node.children()) {
                tables[k++] = this.tableMap.get(((FPVariable)childNode.getLabel()).to);
            }
            this.multipleChildrenVertexPlatt(table, tables, query, iscoreForZero, iscoreForOne, iscore);
        }
        return this.rootPlatt(this.tableMap.get(((FPVariable)this.tree.root.getLabel()).to), iscore).getExp();
    }

    private void leafPlatt(DPTableSparse table, boolean[] query, int[] scoreForZero, int[] scoreForOne) {
        FPVariable V = table.variable;
        int i = ((DPTableSparse)table).variable.to;
        table.reserve(scoreForZero[i], scoreForOne[i], 1, 1, Integer.MAX_VALUE);
        table.addToOne(scoreForOne[i], V.I);
        table.addToZero(scoreForZero[i], V.o);
        assert (TreeDPSparse.checkProbability(table.forOne));
        assert (TreeDPSparse.checkProbability(table.forZero));
    }

    private void innerVertexPlatt(DPTableSparse table, DPTableSparse child, boolean[] query, int[] scoreForZero, int[] scoreForOne, int score) {
        Probability b;
        int d;
        int l;
        FPVariable V = child.variable;
        int i = ((DPTableSparse)child).variable.from;
        int MINO = Math.min(child.offsetZero, child.offsetOne);
        int MAXI = Math.max(((DPTableSparse)child).forZero.maxIndex, ((DPTableSparse)child).forOne.maxIndex);
        table.reserve(MINO + scoreForZero[i], MINO + scoreForOne[i], MAXI - MINO + 1, MAXI - MINO + 1, score);
        for (l = 0; l < ((DPTableSparse)child).forZero.size; ++l) {
            d = ((DPTableSparse)child).forZero.keys[l];
            b = child.forZero(d);
            table.addToOneIndexCheck(d + scoreForOne[i], V.PoI.multiply(b));
            table.addToZeroIndexCheck(d + scoreForZero[i], V.Poo.multiply(b));
        }
        for (l = 0; l < ((DPTableSparse)child).forOne.size; ++l) {
            d = ((DPTableSparse)child).forOne.keys[l];
            b = child.forOne(d);
            table.addToOneIndexCheck(d + scoreForOne[i], V.PII.multiply(b));
            table.addToZeroIndexCheck(d + scoreForZero[i], V.PIo.multiply(b));
        }
        assert (TreeDPSparse.checkProbability(table.forOne));
        assert (TreeDPSparse.checkProbability(table.forZero));
        child.clear();
    }

    private void multipleChildrenVertexPlatt(DPTableSparse table, DPTableSparse[] child, boolean[] query, int[] scoreForZero, int[] scoreForOne, int score) {
        DPTableSparse[] pseudoChilds = new DPTableSparse[child.length];
        for (int k = 0; k < child.length; ++k) {
            pseudoChilds[k] = new DPTableSparse((Tree<FPVariable>)table.node);
            this.innerVertexPlatt(pseudoChilds[k], child[k], query, scoreForZero, scoreForOne, score);
            child[k].clear();
        }
        DPTableSparse temp2 = new DPTableSparse((Tree<FPVariable>)table.node);
        DPTableSparse temp1 = pseudoChilds[0];
        for (int k = 1; k < child.length; ++k) {
            Probability xb;
            int xa;
            int m;
            Probability b;
            int a;
            int l;
            temp2.reserve(temp1.offsetZero + pseudoChilds[k].offsetZero, temp1.offsetOne + pseudoChilds[k].offsetOne, temp1.capaZero + pseudoChilds[k].capaZero, temp1.capaOne + pseudoChilds[k].capaOne, score);
            for (l = 0; l < ((DPTableSparse)temp1).forOne.size; ++l) {
                a = ((DPTableSparse)temp1).forOne.keys[l];
                b = temp1.forOne(a);
                if (b.isZeroProbability()) continue;
                for (m = 0; m < ((DPTableSparse)pseudoChilds[k]).forOne.size; ++m) {
                    xa = ((DPTableSparse)pseudoChilds[k]).forOne.keys[m];
                    xb = pseudoChilds[k].forOne(xa);
                    temp2.addToOneIndexCheck(a + xa, b.multiply(xb));
                }
            }
            for (l = 0; l < ((DPTableSparse)temp1).forZero.size; ++l) {
                a = ((DPTableSparse)temp1).forZero.keys[l];
                b = temp1.forZero(a);
                if (b.isZeroProbability()) continue;
                for (m = 0; m < ((DPTableSparse)pseudoChilds[k]).forZero.size; ++m) {
                    xa = ((DPTableSparse)pseudoChilds[k]).forZero.keys[m];
                    xb = pseudoChilds[k].forZero(xa);
                    temp2.addToZeroIndexCheck(a + xa, b.multiply(xb));
                }
            }
            temp1 = temp2;
            temp2 = new DPTableSparse((Tree<FPVariable>)table.node);
        }
        table.forOne = temp1.forOne;
        table.forZero = temp1.forZero;
        for (DPTableSparse pchild : pseudoChilds) {
            pchild.clear();
        }
        assert (TreeDPSparse.checkProbability(table.forOne));
        assert (TreeDPSparse.checkProbability(table.forZero));
    }

    private Probability rootPlatt(DPTableSparse table, int score) {
        int k;
        Probability pvalue = Probability.ZERO;
        for (k = table.offsetOne; k <= Math.min(((DPTableSparse)table).forOne.maxIndex, score); ++k) {
            pvalue = pvalue.add(table.forOne(k));
        }
        for (k = table.offsetZero; k <= Math.min(((DPTableSparse)table).forZero.maxIndex, score); ++k) {
            pvalue = pvalue.add(table.forZero(k));
        }
        return pvalue;
    }

    protected static final class DPTableSparse {
        private final Tree<FPVariable> node;
        private final FPVariable variable;
        private SparseMap forZero;
        private SparseMap forOne;
        private int capaOne;
        private int capaZero;
        private int offsetOne;
        private int offsetZero;

        public DPTableSparse(Tree<FPVariable> node) {
            this.node = node;
            this.variable = (FPVariable)node.getLabel();
        }

        void reserve(int offsetZero, int offsetOne, int zeros, int ones, int maxEntries) {
            this.offsetOne = offsetOne;
            this.offsetZero = offsetZero;
            this.capaOne = offsetOne + ones > maxEntries ? maxEntries - offsetOne : ones;
            this.capaZero = offsetZero + zeros > maxEntries ? maxEntries - offsetZero : zeros;
            this.forZero = new SparseMap(offsetZero, this.capaZero);
            this.forOne = new SparseMap(offsetOne, this.capaOne);
        }

        Probability addToOne(int k, Probability value) {
            if (!value.isZeroProbability()) {
                return this.forOne.add(k, value);
            }
            return Probability.ZERO;
        }

        Probability addToZero(int k, Probability value) {
            if (!value.isZeroProbability()) {
                return this.forZero.add(k, value);
            }
            return Probability.ZERO;
        }

        Probability addToOneIndexCheck(int k, Probability value) {
            if (!value.isZeroProbability() && k <= this.forOne.maxIndex) {
                return this.forOne.add(k, value);
            }
            return Probability.ZERO;
        }

        Probability addToZeroIndexCheck(int k, Probability value) {
            if (!value.isZeroProbability() && k <= this.forZero.maxIndex) {
                return this.forZero.add(k, value);
            }
            return Probability.ZERO;
        }

        Probability forOne(int k) {
            return this.forOne.get(k);
        }

        Probability forZero(int k) {
            return this.forZero.get(k);
        }

        void clear() {
            this.forOne = null;
            this.forZero = null;
        }

        void copyTo(DPTableSparse other) {
            other.forZero = this.forZero;
            other.forOne = this.forOne;
            this.reserve(this.offsetZero, this.offsetOne, this.capaZero, this.capaOne, Integer.MAX_VALUE);
        }
    }

    protected static final class SparseMap {
        protected final Probability[] values;
        protected final int[] keys;
        protected final int offset;
        protected final int maxIndex;
        protected int size;

        public SparseMap(int offset, int size) {
            this.values = new Probability[size];
            this.keys = new int[size];
            this.offset = offset;
            assert (offset >= 0);
            this.size = 0;
            this.maxIndex = offset + size - 1;
            assert (this.maxIndex >= offset);
        }

        public Probability get(int k) {
            Probability p = this.values[k - this.offset];
            if (p == null) {
                return Probability.ZERO;
            }
            return p;
        }

        public void set(int k, Probability p) {
            Probability prev = this.values[k - this.offset];
            if (prev == null) {
                this.values[k - this.offset] = p;
                this.keys[this.size++] = k;
            } else {
                this.values[k - this.offset] = p;
            }
        }

        public Probability add(int k, Probability p) {
            Probability prev = this.values[k - this.offset];
            if (prev == null) {
                this.values[k - this.offset] = p;
                this.keys[this.size++] = k;
                return p;
            }
            this.values[k - this.offset] = p.add(prev);
            return this.values[k - this.offset];
        }
    }
}

