/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.fp.BooleanFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.chemdb.ChemicalDatabase;
import de.unijena.bioinf.chemdb.CompoundCandidate;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.fingerid.Fingerprinter;
import de.unijena.bioinf.fingerid.fingerprints.FixedMACCSFingerprinter;
import de.unijena.bioinf.fingerid.fingerprints.OpenBabelFingerprinter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.KlekotaRothFingerprinter;
import org.openscience.cdk.fingerprint.PubchemFingerprinter;
import org.openscience.cdk.fingerprint.SubstructureFingerprinter;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFingerprintDatabaseWrapper
extends ChemicalDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFingerprintDatabaseWrapper.class);
    private final CdkFingerprintVersion version;
    private Fingerprinter fingerprinter;

    public CustomFingerprintDatabaseWrapper(CdkFingerprintVersion version) throws DatabaseException {
        this.version = version;
    }

    public CustomFingerprintDatabaseWrapper(CdkFingerprintVersion version, String host, String username, String password) throws DatabaseException {
        super(host, username, password);
        this.version = version;
    }

    public CustomFingerprintDatabaseWrapper(CdkFingerprintVersion version, ChemicalDatabase db) throws DatabaseException {
        super(db);
        this.version = version;
    }

    private synchronized Fingerprinter getFingerprinter() {
        if (this.fingerprinter == null) {
            try {
                this.fingerprinter = Fingerprinter.getFor((FingerprintVersion)this.version);
            }
            catch (CDKException e) {
                throw new RuntimeException(e);
            }
        }
        return this.fingerprinter;
    }

    public <T extends Collection<FingerprintCandidate>> T lookupStructuresAndFingerprintsByFormula(MolecularFormula formula, final T fingerprintCandidates) throws DatabaseException {
        super.lookupStructuresAndFingerprintsByFormula(formula, (Collection)new AbstractCollection<FingerprintCandidate>(){

            @Override
            public Iterator<FingerprintCandidate> iterator() {
                return fingerprintCandidates.iterator();
            }

            @Override
            public int size() {
                return fingerprintCandidates.size();
            }

            @Override
            public boolean add(FingerprintCandidate fingerprintCandidate) {
                FingerprintCandidate wrapped = CustomFingerprintDatabaseWrapper.this.wrap(fingerprintCandidate);
                return fingerprintCandidates.add(wrapped);
            }
        });
        return fingerprintCandidates;
    }

    public List<FingerprintCandidate> lookupFingerprintsByInchis(Iterable<String> inchi_keys) throws DatabaseException {
        List inchis = super.lookupManyInchisByInchiKeys(inchi_keys);
        ArrayList<CompoundCandidate> cs = new ArrayList<CompoundCandidate>(inchis.size());
        for (InChI i : inchis) {
            cs.add(new CompoundCandidate(i));
        }
        List fcs = super.lookupFingerprintsByInchi(cs);
        return this.wrap(fcs);
    }

    public List<FingerprintCandidate> lookupManyFingerprintsByInchis(Iterable<String> inchi_keys) throws DatabaseException {
        return this.lookupFingerprintsByInchis(inchi_keys);
    }

    public List<FingerprintCandidate> lookupFingerprintsByInchi(Iterable<CompoundCandidate> compounds) throws DatabaseException {
        return this.wrap(super.lookupFingerprintsByInchi(compounds));
    }

    protected List<FingerprintCandidate> wrap(List<FingerprintCandidate> fpc) {
        ArrayList<FingerprintCandidate> xs = new ArrayList<FingerprintCandidate>(fpc.size());
        for (FingerprintCandidate fc : fpc) {
            xs.add(this.wrap(fc));
        }
        return xs;
    }

    protected FingerprintCandidate wrap(FingerprintCandidate fpc) {
        if (this.version == CdkFingerprintVersion.getDefault() || this.version.compatible((FingerprintVersion)CdkFingerprintVersion.getDefault())) {
            return fpc;
        }
        boolean[] fps = CustomFingerprintDatabaseWrapper.mergeDatabaseAndCDKFingerprints(this.getFingerprinter(), fpc.getInchi(), fpc.getFingerprint().toBooleanArray());
        return new FingerprintCandidate((CompoundCandidate)fpc, (Fingerprint)new BooleanFingerprint((FingerprintVersion)this.version, fps));
    }

    private static boolean isDefaultSetOfFingerprints(Fingerprinter fp) {
        List fps = fp.getFingerprinters();
        return fps.size() == 5 && fps.get(0) instanceof OpenBabelFingerprinter && ((IFingerprinter)fps.get(1)).getClass().equals(SubstructureFingerprinter.class) && fps.get(2) instanceof FixedMACCSFingerprinter && fps.get(3) instanceof PubchemFingerprinter && fps.get(4) instanceof KlekotaRothFingerprinter;
    }

    public static boolean[] mergeDatabaseAndCDKFingerprints(Fingerprinter fp, InChI inchi, boolean[] database) {
        if (CustomFingerprintDatabaseWrapper.isDefaultSetOfFingerprints(fp)) {
            return database;
        }
        IAtomContainer atomContainer = null;
        List defaultFingerprinters = Fingerprinter.createListOfFingerprints();
        int[] offsets = new int[defaultFingerprinters.size()];
        for (int k = 1; k < offsets.length; ++k) {
            offsets[k] = offsets[k - 1] + ((IFingerprinter)defaultFingerprinters.get(k - 1)).getSize();
        }
        boolean[] bits = new boolean[fp.numberOfFingerprints()];
        int offset = 0;
        block3: for (IFingerprinter f : fp.getFingerprinters()) {
            for (int j = 0; j < defaultFingerprinters.size(); ++j) {
                if (!((IFingerprinter)defaultFingerprinters.get(j)).getClass().equals(f.getClass())) continue;
                System.arraycopy(database, offsets[j], bits, offset, f.getSize());
                offset += f.getSize();
                continue block3;
            }
            if (atomContainer == null) {
                atomContainer = CustomFingerprintDatabaseWrapper.inchi2mol(inchi.in2D);
            }
            try {
                Fingerprinter ifp = new Fingerprinter(Arrays.asList(f));
                boolean[] bits2 = ifp.fingerprintsToBooleans(ifp.computeFingerprints(atomContainer));
                System.arraycopy(bits2, 0, bits, offset, ifp.numberOfFingerprints());
                offset += ifp.numberOfFingerprints();
            }
            catch (CDKException e) {
                throw new RuntimeException(e);
            }
        }
        return bits;
    }

    public static IAtomContainer inchi2mol(String inchi) {
        try {
            if (inchi == null) {
                throw new NullPointerException("Given InChI is null");
            }
            if (inchi.isEmpty()) {
                throw new IllegalArgumentException("Empty string given as InChI");
            }
            InChIToStructure s = InChIGeneratorFactory.getInstance().getInChIToStructure(inchi, DefaultChemObjectBuilder.getInstance());
            if (s.getReturnStatus() != INCHI_RET.OKAY) {
                if (s.getReturnStatus() == INCHI_RET.WARNING) {
                    LOGGER.warn(s.getMessage());
                } else {
                    throw new CDKException(s.getMessage());
                }
            }
            return s.getAtomContainer();
        }
        catch (CDKException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomFingerprintDatabaseWrapper clone() {
        try {
            CustomFingerprintDatabaseWrapper db = new CustomFingerprintDatabaseWrapper(this.version, this);
            db.setBioFilter(this.getBioFilter());
            return db;
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}

