/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import com.google.common.base.Joiner;
import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.babelms.json.FTJsonReader;
import de.unijena.bioinf.babelms.ms.JenaMsParser;
import de.unijena.bioinf.chemdb.BioFilter;
import de.unijena.bioinf.chemdb.ChemicalDatabase;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.chemdb.SearchStructureByFormula;
import de.unijena.bioinf.fingerid.Prediction;
import de.unijena.bioinf.fingerid.SpectralPreprocessor;
import de.unijena.bioinf.fingerid.TrainedCSIFingerId;
import de.unijena.bioinf.fingerid.blast.CovarianceScoring;
import de.unijena.bioinf.fingerid.blast.Fingerblast;
import de.unijena.bioinf.fingerid.blast.FingerblastScoringMethod;
import de.unijena.bioinf.fingerid.blast.ScoringMethodFactory;
import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.DBCandidate;
import de.unijena.bioinf.fingeriddb.FingerIdInstance;
import de.unijena.bioinf.fingeriddb.MolecularFeatureStats;
import de.unijena.bioinf.fingeriddb.job.FingerIdJob;
import de.unijena.bioinf.fingeriddb.job.JobState;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import de.unijena.bioinf.fingeriddb.job.SiriusPredictionJob;
import de.unijena.bioinf.fingerworker.CustomFingerprintDatabaseWrapper;
import de.unijena.bioinf.fingerworker.SiriusWebWorker;
import de.unijena.bioinf.fingerworker.WebWorker;
import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.sirius.Sirius;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerIdWebWorker
extends WebWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FingerIdWebWorker.class);
    protected Prediction prediction = null;
    protected SpectralPreprocessor preprocessor = null;
    protected boolean enforceBio = false;
    protected MaskedFingerprintVersion fpVersion = null;
    protected PredictionPerformance[] performances;
    protected File confidenceFileBio;
    protected File confidenceFilePubChem;
    protected File covarianceTreeFile = null;
    private long predictorBits;
    private File fingerIdFile = null;
    private FingerIdWebWorker origin = null;
    private FingerblastScoringMethod treeScoring = null;

    public FingerIdWebWorker(String prefix, EnumSet<PredictorType> predictors, File fingerIdFile, File confidenceFileBio, File confidenceFilePubChem, File covarianceTreeFile) throws IOException, DatabaseException, SQLException {
        super(prefix);
        this.confidenceFileBio = confidenceFileBio;
        this.confidenceFilePubChem = confidenceFilePubChem;
        this.covarianceTreeFile = covarianceTreeFile;
        this.fingerIdFile = fingerIdFile;
        this.predictorBits = PredictorType.getBits(predictors);
    }

    public FingerIdWebWorker(FingerIdWebWorker origin) throws SQLException, IOException, DatabaseException {
        super(origin.prefix);
        this.origin = origin;
        this.confidenceFilePubChem = origin.confidenceFilePubChem;
        this.confidenceFileBio = origin.confidenceFileBio;
        this.covarianceTreeFile = origin.covarianceTreeFile;
        this.predictorBits = origin.predictorBits;
    }

    @Override
    protected void startUpWorker() throws DatabaseException, IOException, SQLException, InterruptedException {
        super.startUpWorker();
        if (this.prediction == null) {
            if (this.origin != null) {
                while (this.fingerIdDB().isStarting(this.origin.id)) {
                    Thread.sleep(10000L);
                }
                this.prediction = this.origin.prediction;
                this.enforceBio = this.origin.enforceBio;
                this.origin = null;
            } else if (this.fingerIdFile != null) {
                this.prediction = Prediction.loadFromFile((File)this.fingerIdFile, (boolean)PredictorType.IOKR_POSITIVE.isBitSet(this.predictorBits));
                this.fingerIdFile = null;
            } else {
                throw new IOException("No FingerID File given (NULL)");
            }
        }
        LOGGER.info("Prediction loaded");
        if (this.preprocessor == null) {
            this.preprocessor = new SpectralPreprocessor(new Sirius("qtof").getMs2Analyzer());
        }
        this.enforceBio = false;
        if (this.fpVersion == null) {
            this.fpVersion = this.prediction.getFingerid().getMaskedFingerprintVersion();
        }
        this.treeScoring = this.covarianceTreeFile != null ? CovarianceScoring.readScoringFromFile((Path)this.covarianceTreeFile.toPath(), (FingerprintVersion)this.fpVersion, (double)(1.0 / (double)this.prediction.getFingerid().numberOfTrainingData())) : new ScoringMethodFactory.CSIFingerIdScoringMethod(this.performances);
        this.makeStatistics(this.confidenceFileBio, this.confidenceFilePubChem, this.covarianceTreeFile);
    }

    private Fingerblast fpblast() throws DatabaseException {
        Fingerblast fpblast;
        if (this.fpVersion.getMaskedFingerprintVersion().compatible((FingerprintVersion)CdkFingerprintVersion.getDefault())) {
            fpblast = new Fingerblast(this.treeScoring, (SearchStructureByFormula)this.chemDb());
        } else {
            System.out.println("Custom fingerprint db wrapper!?");
            fpblast = new Fingerblast(this.treeScoring, (SearchStructureByFormula)new CustomFingerprintDatabaseWrapper((CdkFingerprintVersion)this.fpVersion.getMaskedFingerprintVersion()));
        }
        ((ChemicalDatabase)fpblast.getSearchEngine()).setBioFilter(this.enforceBio ? BioFilter.ONLY_BIO : BioFilter.ALL);
        return fpblast;
    }

    @Override
    public Worker.WorkerType getWorkerType() {
        return Worker.WorkerType.FINGER_ID;
    }

    @Override
    protected int registerToDB(String prefix, boolean isBackup) throws SQLException {
        return this.fingerIdDB().addWorker(prefix, FingerIDProperties.fingeridVersion(), this.getWorkerType().name(), PredictorType.bitsToNames((long)this.predictorBits), Boolean.valueOf(isBackup));
    }

    protected void makeStatistics(File confidenceFileBio, File confidenceFilePubchem, File covarianceTreeFile) throws IOException {
        TrainedCSIFingerId fingerid = this.prediction.getFingerid();
        MolecularFeatureStats[] stats = new MolecularFeatureStats[fingerid.numberOfFingerprints()];
        this.performances = new PredictionPerformance[fingerid.numberOfFingerprints()];
        for (int k = 0; k < fingerid.numberOfFingerprints(); ++k) {
            int absoluteIndex = fingerid.getFingerprintIndizes()[k];
            PredictionPerformance performance = fingerid.getPredictors()[k].getPerformance();
            stats[k] = new MolecularFeatureStats(absoluteIndex, performance.getTp(), performance.getFp(), performance.getTn(), performance.getFn());
            this.performances[k] = performance;
        }
        if (this.isBackup) {
            return;
        }
        String confidenceJsonBio = confidenceFileBio != null ? Joiner.on((char)'\n').join(Files.readAllLines(confidenceFileBio.toPath(), Charset.forName("UTF-8"))) : null;
        String confidenceJsonPubchem = confidenceFilePubchem != null ? Joiner.on((char)'\n').join(Files.readAllLines(confidenceFilePubchem.toPath(), Charset.forName("UTF-8"))) : null;
        String covarianceTreeCsv = covarianceTreeFile != null ? Joiner.on((char)'\n').join(Files.readAllLines(covarianceTreeFile.toPath(), Charset.forName("UTF-8"))) : null;
        try {
            this.fingerIdDB().submitStatistics(this.prefix, this.predictorBits, stats, FingerIDProperties.fingeridVersion(), fingerid.getVersion(), confidenceJsonBio, confidenceJsonPubchem, covarianceTreeCsv);
        }
        catch (SQLException e) {
            LOGGER.warn("Submitting statistics file failed! Hopefully somebody else has already submitted it.", (Throwable)e);
        }
    }

    public Prediction getPredictionModel() {
        return this.prediction;
    }

    @Override
    protected void shutdown() {
        super.shutdown();
        try {
            this.prediction.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean listen() throws SQLException, DatabaseException {
        return this.listenToFingerblastJob() || this.listenToFingerIdJob();
    }

    public boolean listenToFingerblastJob() throws SQLException, DatabaseException {
        FingerIdJob job = this.fingerIdDB().fetchLastFingerIdJob(this.prefix);
        Fingerblast fpblast = this.fpblast();
        if (job == null) {
            return false;
        }
        LOGGER.info("incoming web-fingerid request with id " + job.getInstanceId() + " | " + job.getCandidateId());
        try {
            String jsonTree = this.fingerIdDB().getTree(job.getInstanceId(), job.getCandidateId());
            if (jsonTree == null) {
                job.setErrorMessage("selected tree does not exist.");
                job.setState(JobState.CRASHED);
                this.fingerIdDB().updateFingerIdJobFinished(job);
                return false;
            }
            FTree tree = new FTJsonReader().parse(new BufferedReader(new StringReader(jsonTree)), null);
            FingerIdInstance instance = this.fingerIdDB().getInstanceNoSecurityCheck(job.getInstanceId());
            MutableMs2Experiment experiment = SiriusWebWorker.fingerInstance2Ms2Experiment(instance.input);
            ArrayList<DBCandidate> candidates = this.predictAndSearch(tree, (Ms2Experiment)experiment, fpblast);
            this.fingerIdDB().submitFingerIdResults(job, candidates);
            this.fingerIdDB().setNumberOfCompoundCandidates(job.getInstanceId(), job.getCandidateId(), candidates.size());
        }
        catch (Throwable e) {
            job.setErrorMessage(e.getMessage());
            job.setState(JobState.CRASHED);
            this.fingerIdDB().updateFingerIdJobFinished(job);
            LOGGER.warn("request processing crashed", e);
        }
        LOGGER.info("request processed");
        return true;
    }

    public ArrayList<DBCandidate> search(MolecularFormula formula, double[] prediction, Fingerblast fpblast) throws ExecutionException, InterruptedException, DatabaseException, IOException {
        ArrayList<DBCandidate> candidates = new ArrayList<DBCandidate>();
        ProbabilityFingerprint prob = new ProbabilityFingerprint((FingerprintVersion)this.fpVersion, prediction);
        Fingerprint binfp = prob.asDeterministic();
        int rank = 0;
        for (Scored fp : fpblast.search(formula, prob)) {
            DBCandidate c = new DBCandidate();
            c.setFlags(((FingerprintCandidate)fp.getCandidate()).getBitset());
            c.setSmiles(((FingerprintCandidate)fp.getCandidate()).getSmiles());
            c.setInchi(((FingerprintCandidate)fp.getCandidate()).getInchi().in2D);
            c.setInchKey2D(((FingerprintCandidate)fp.getCandidate()).getInchiKey2D());
            c.setName(((FingerprintCandidate)fp.getCandidate()).getName());
            c.setRank(++rank);
            c.setScore(fp.getScore());
            c.setMatchScore(((FingerprintCandidate)fp.getCandidate()).getFingerprint().tanimoto(binfp));
            candidates.add(c);
        }
        return candidates;
    }

    public ArrayList<DBCandidate> predictAndSearch(FTree tree, Ms2Experiment experiment, Fingerblast fpblast) throws InterruptedException, ExecutionException, DatabaseException, IOException {
        this.preprocessor.preprocessTrees(tree);
        SimpleSpectrum spectrum = this.preprocessor.preprocess(experiment, tree);
        double precursor = this.preprocessor.getPrecursorMass(tree);
        double[] platts = this.prediction.predictPlatts(spectrum, tree, precursor);
        return this.search(tree.getRoot().getFormula(), platts, fpblast);
    }

    public double calculateJaccard(boolean[] rf, double[] fingerprint) {
        int shared = 0;
        int features = 0;
        for (int k = 0; k < fingerprint.length; ++k) {
            boolean isset;
            boolean bl = isset = fingerprint[k] > 0.5;
            if (rf[k] && isset) {
                ++shared;
            }
            if (!isset && !rf[k]) continue;
            ++features;
        }
        return (double)shared / (double)features;
    }

    public boolean listenToFingerIdJob() throws SQLException {
        SiriusPredictionJob job = this.fingerIdDB().fetchLastSiriusPredictionJob(this.prefix, this.predictorBits);
        if (job == null) {
            return false;
        }
        LOGGER.info("incoming sirius-fingerid request with id " + job.getJobId());
        try {
            String jsonTree = job.getJsonTree();
            if (jsonTree == null) {
                this.fingerIdDB().updateSiriusPredictionJobFinished(job.getJobId(), JobState.CRASHED, "Tree is null.", null, null);
                return false;
            }
            FTree tree = new FTJsonReader().parse(new BufferedReader(new StringReader(jsonTree)), null);
            if (tree.numberOfEdges() == 0 && ((Peak)tree.getFragmentAnnotationOrThrow(Peak.class).get(tree.getRoot())).getIntensity() <= 0.0) {
                this.fingerIdDB().updateSiriusPredictionJobFinished(job.getJobId(), JobState.CRASHED, "Tree contains no edges and Root node has intensity <= 0", null, null);
                return false;
            }
            this.preprocessor.preprocessTrees(tree);
            Ms2Experiment experiment = new JenaMsParser().parse(new BufferedReader(new StringReader(job.getMs())), null);
            SimpleSpectrum spectrum = this.preprocessor.preprocess(experiment, tree);
            double precursor = this.preprocessor.getPrecursorMass(tree);
            double[][] kernels = this.prediction.computeCenteredNormalizedKernelValues(spectrum, tree, precursor);
            double[] platts = this.prediction.predictPlattsFromCenteredNormalizedKernels(kernels);
            double[] iokrVector = null;
            if (job.containsPredictor(PredictorType.IOKR_POSITIVE)) {
                iokrVector = this.prediction.getFingerid().getIOKRModel().getPredictor().predict(kernels);
            }
            this.fingerIdDB().updateSiriusPredictionJobFinished(job.getJobId(), JobState.DONE, "", platts, iokrVector);
            return true;
        }
        catch (Throwable e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof DatabaseException) {
                throw new SQLException(e);
            }
            LOGGER.error(e.getMessage(), e);
            this.fingerIdDB().updateSiriusPredictionJobFinished(job.getJobId(), JobState.CRASHED, e.getMessage(), null, null);
            return false;
        }
    }
}

