/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import com.lexicalscope.jewel.cli.CliFactory;
import de.unijena.bioinf.ChemistryBase.properties.PropertyFileWatcher;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.fingeriddb.FingerIdDB;
import de.unijena.bioinf.fingerworker.FingerIdWebWorker;
import de.unijena.bioinf.fingerworker.Guardian;
import de.unijena.bioinf.fingerworker.SiriusWebWorker;
import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.WorkerManager;
import de.unijena.bioinf.fingerworker.WorkerOpts;
import de.unijena.bioinf.fingerworker.WorkerProperties;
import de.unijena.bioinf.fingerworker.executor.LocalExecutor;
import de.unijena.bioinf.jjobs.JobManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import java.util.stream.Collectors;
import net.efabrika.util.DBTablePrinter;
import org.slf4j.LoggerFactory;

public class FingerWorkerMain {
    public static Path FINGER_WORKER_HOME;
    private static PropertyFileWatcher WORKER_PROPERTY_WATCHER;
    private static WorkerProperties WORKER_PROPS;
    private static ExecutorService WORKER_THREADS;

    public static void main(String[] args) {
        int exit = 0;
        try {
            FINGER_WORKER_HOME = Paths.get(FingerWorkerMain.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), new String[0]).getParent().getParent().toAbsolutePath();
            WorkerOpts opts = (WorkerOpts)CliFactory.createCliUsingInstance((Object)new WorkerOpts()).parseArguments(args);
            new FingerWorkerMain().run(opts);
        }
        catch (Throwable e) {
            e.printStackTrace();
            exit = 1;
        }
        finally {
            FingerWorkerMain.shutdown(exit);
        }
    }

    public static void shutdown(int exit) {
        boolean ex = false;
        try {
            JobManager.shutDownAllInstances();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            ex = true;
        }
        try {
            if (WORKER_THREADS != null) {
                WORKER_THREADS.shutdown();
                WORKER_THREADS.awaitTermination(1L, TimeUnit.MINUTES);
            }
            LoggerFactory.getLogger(FingerWorkerMain.class).info("All Worker threads finished. Stopping Process!");
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(FingerWorkerMain.class).warn("Unexpected Worker Termination", (Throwable)e);
            ex = true;
        }
        try {
            if (WORKER_PROPERTY_WATCHER != null) {
                WORKER_PROPERTY_WATCHER.stopThread();
                WORKER_PROPERTY_WATCHER.join();
            }
            LoggerFactory.getLogger(FingerWorkerMain.class).info("File Watcher Service properly stopped");
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(FingerWorkerMain.class).warn("Unexpected File Watcher Termination", (Throwable)e);
            ex = true;
        }
        if (ex) {
            Thread.currentThread().interrupt();
        }
        System.exit(exit);
    }

    public void run(WorkerOpts opts) throws IOException, SQLException, DatabaseException {
        switch (opts.task) {
            case START: {
                this.runStart(opts);
                break;
            }
            case SHOW: {
                this.runShow(opts);
                break;
            }
            case STOP: {
                this.runStop(opts);
                break;
            }
            default: {
                System.err.print("Please specify a task you want to execute " + WorkerOpts.TaskType.values());
            }
        }
    }

    private void runShow(WorkerOpts opts) throws DatabaseException, IOException, SQLException {
        FingerIdDB fingerIdDB = new FingerIdDB();
        ResultSet result = fingerIdDB.getRegisteredWorkers(opts.prefixe, opts.version, opts.workerTypes().stream().map(Enum::name).collect(Collectors.toList()), null);
        DBTablePrinter.printResultSet((ResultSet)result);
    }

    private void runStop(WorkerOpts opts) throws DatabaseException, IOException, SQLException {
        FingerIdDB fingerIdDB = new FingerIdDB();
        int workerID = opts.id;
        if (workerID < 0) {
            if (opts.all) {
                fingerIdDB.shutdownWorkersByVersion(opts.version);
            } else {
                for (Worker.WorkerType workerType : opts.workerTypes()) {
                    for (String prefix : opts.prefixe) {
                        fingerIdDB.shutdownWorkers(prefix, opts.version, workerType.name(), Boolean.valueOf(opts.isBackup));
                    }
                }
            }
        } else {
            fingerIdDB.shutdownWorker(workerID);
        }
    }

    private void runStart(WorkerOpts opts) throws DatabaseException, IOException, SQLException {
        Object loggingDir2;
        Throwable throwable;
        InputStream input;
        Path loggingPropFile = FINGER_WORKER_HOME.resolve("logging.properties");
        if (Files.notExists(loggingPropFile, new LinkOption[0])) {
            try {
                input = this.getClass().getResourceAsStream("/logging.properties");
                throwable = null;
                try {
                    loggingDir2 = FINGER_WORKER_HOME.resolve("log").resolve("worker.log");
                    Files.createDirectories(loggingDir2.getParent(), new FileAttribute[0]);
                    Properties pros = new Properties();
                    pros.load(input);
                    pros.setProperty("java.util.logging.FileHandler.pattern", loggingDir2.toAbsolutePath().toString());
                    pros.store(Files.newBufferedWriter(loggingPropFile, StandardOpenOption.CREATE), "Worker logging Properties");
                }
                catch (Throwable loggingDir2) {
                    throwable = loggingDir2;
                    throw loggingDir2;
                }
                finally {
                    if (input != null) {
                        if (throwable != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable loggingDir2) {
                                throwable.addSuppressed(loggingDir2);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
            }
            catch (IOException | NullPointerException e) {
                System.err.println("Could not set logging properties, using default java logging properties and directories");
                e.printStackTrace();
            }
        }
        if (Files.exists(loggingPropFile, new LinkOption[0])) {
            System.setProperty("java.util.logging.config.file", loggingPropFile.toString());
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (IOException e) {
                System.err.println("Could not read logging configuration.");
                e.printStackTrace();
            }
        }
        WORKER_PROPS = new WorkerProperties(opts);
        try {
            input = this.getClass().getResourceAsStream("/worker.properties");
            throwable = null;
            try {
                WORKER_PROPS.load(new InputStreamReader(input, Charset.forName("UTF-8")));
            }
            catch (Throwable loggingDir2) {
                throwable = loggingDir2;
                throw loggingDir2;
            }
            finally {
                if (input != null) {
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable loggingDir2) {
                            throwable.addSuppressed(loggingDir2);
                        }
                    } else {
                        input.close();
                    }
                }
            }
        }
        catch (IOException | NullPointerException e) {
            LoggerFactory.getLogger(this.getClass()).error("could not load Hardcoded Worker Properties", (Throwable)e);
        }
        Path props = FINGER_WORKER_HOME.resolve("worker.properties");
        if (Files.notExists(props, new LinkOption[0])) {
            try {
                OutputStream w = Files.newOutputStream(props, new OpenOption[0]);
                loggingDir2 = null;
                try {
                    WORKER_PROPS.store(w, "Creates at: " + new Date());
                }
                catch (Throwable pros) {
                    loggingDir2 = pros;
                    throw pros;
                }
                finally {
                    if (w != null) {
                        if (loggingDir2 != null) {
                            try {
                                w.close();
                            }
                            catch (Throwable pros) {
                                ((Throwable)loggingDir2).addSuppressed(pros);
                            }
                        } else {
                            w.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        WORKER_PROPERTY_WATCHER = Files.isReadable(props) ? new PropertyFileWatcher(props, (Properties)WORKER_PROPS) : null;
        WORKER_PROPS.setProperty("de.unijena.bioinf.fingerid.fingerworker.home", FINGER_WORKER_HOME.toAbsolutePath().toString());
        if (opts.localhost) {
            PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.fingerid.chemical_db.host", "localhost:5432");
            PropertyManager.PROPERTIES.setProperty("de.unijena.bioinf.fingerid.fingerid_db.host", "localhost:3306");
        }
        WORKER_PROPERTY_WATCHER.start();
        if (opts.isGuardian()) {
            LocalExecutor.setGlobalWorkerProperties(WORKER_PROPS);
            this.runAsGuardian(opts);
        } else {
            int threads;
            String prefix;
            String string = prefix = opts.prefix() == null ? "Default" : opts.prefix();
            if (opts.isFingerid() && (threads = opts.getThreads(WORKER_PROPS, Worker.WorkerType.FINGER_ID)) > 0) {
                FingerIdWebWorker first = new FingerIdWebWorker(prefix, opts.getPredictors(), opts.fingerIdData(), opts.confidenceBio, opts.confidencePubchem, opts.covarianceTree());
                first.setBackup(opts.isBackup);
                WORKER_THREADS.submit(first);
                for (int i = 1; i < threads; ++i) {
                    FingerIdWebWorker w = new FingerIdWebWorker(first);
                    w.setBackup(opts.isBackup);
                    WORKER_THREADS.submit(w);
                }
            }
            if (opts.isSirius()) {
                threads = opts.getThreads(WORKER_PROPS, Worker.WorkerType.SIRIUS);
                for (int i = 0; i < threads; ++i) {
                    SiriusWebWorker w = new SiriusWebWorker(prefix, opts.profile);
                    w.setBackup(opts.isBackup);
                    WORKER_THREADS.submit(w);
                }
            }
            WORKER_THREADS.shutdown();
            try {
                WORKER_THREADS.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                LoggerFactory.getLogger(this.getClass()).info("All Worker threads finished. Stopping Process!");
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Unexpected Worker Termination", (Throwable)e);
            }
        }
    }

    private void runAsGuardian(WorkerOpts opts) throws SQLException {
        Guardian guardian = new Guardian(!opts.notWatchWorkers, !opts.noStats);
        EnumSet<Worker.WorkerType> noGuards = EnumSet.copyOf(opts.workerTypes());
        noGuards.remove((Object)Worker.WorkerType.GUARDIAN);
        for (Worker.WorkerType type : noGuards) {
            for (String prefix : opts.prefixe) {
                guardian.addWorkerType(new WorkerManager(prefix, type, WORKER_PROPS));
            }
        }
        guardian.run();
    }

    static {
        WORKER_THREADS = Executors.newCachedThreadPool();
    }
}

