/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.FingerIdDB;
import de.unijena.bioinf.fingeriddb.stats.Localizer;
import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.WorkerManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import net.efabrika.util.DBTablePrinter;

public class Guardian
extends Worker {
    protected Date lastStatisticsUpdate;
    private final boolean doStats;
    boolean watchLocalWorkers;
    private LinkedHashSet<WorkerManager> workerTypes = new LinkedHashSet();

    public boolean addWorkerType(WorkerManager manager) {
        return this.workerTypes.add(manager);
    }

    public boolean removeWorkerType(WorkerManager manager) {
        return this.workerTypes.remove(manager);
    }

    public Guardian() throws SQLException {
        this(true, true);
    }

    public Guardian(boolean watchLocalWorkers, boolean doStats) throws SQLException {
        super(new FingerIdDB());
        this.watchLocalWorkers = watchLocalWorkers;
        this.doStats = doStats;
    }

    public String getPrefix() {
        return "Guardian: " + Strings.join(this.workerTypes.stream().map(manager -> manager.prefix).distinct().sorted().collect(Collectors.toList()), (String)";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOGGER.info("Starting Guardian...");
            this.id = this.registerToDB(this.getPrefix(), false);
            LOGGER.info("Guardian registered with ID: " + this.id);
            Worker.Heartbeat heartbeat = new Worker.Heartbeat();
            heartbeat.start();
            int ticks = 0;
            this.fingerIdDB().setRunning(this.id);
            LOGGER.info("...Guardian successfully started!");
            boolean isShutdown = this.isShutdown();
            while (!isShutdown) {
                try {
                    if (ticks == 0) {
                        this.updateStatistics(this.fingerIdDB());
                    }
                    long time = System.currentTimeMillis();
                    ResultSet r = this.fingerIdDB().shutdownUnreachableWorkers(time - 300000L);
                    if (r != null && r.next()) {
                        LOGGER.info("Shutting down unreachable workers");
                        DBTablePrinter.printResultSet((ResultSet)r);
                    }
                    if ((r = this.fingerIdDB().removeShutdownedWorkersByTime(time - 86400000L)) != null && r.next()) {
                        LOGGER.info("Removing shut downed worker by timeout");
                        DBTablePrinter.printResultSet((ResultSet)r);
                    }
                    for (WorkerManager workerManager : this.workerTypes) {
                        if (this.watchLocalWorkers) {
                            workerManager.checkLocalWorkers(this.fingerIdDB());
                        }
                        workerManager.checkBackupWorkers(this.fingerIdDB());
                    }
                    Thread.sleep(10000L);
                    if (++ticks % 120 == 0) {
                        this.updateStatistics(this.fingerIdDB());
                    }
                    isShutdown = this.isShutdown();
                }
                catch (SQLException e) {
                    LOGGER.warn("DB Connection problem! Waiting 20s for reconnect");
                    this.waitForDBReconnection();
                }
                catch (Throwable e) {
                    LOGGER.error("Something went wrong!", e);
                }
            }
            heartbeat.stopAndJoinHeartbeat();
            LOGGER.info("Shutdown " + this.getWorkerType().name() + "whith ID " + this.id);
        }
        catch (Throwable e) {
            LOGGER.error("Something went wrong!", e);
        }
        finally {
            this.shutdown();
        }
    }

    private void updateStatistics(FingerIdDB db) throws SQLException {
        if (!this.doStats) {
            return;
        }
        Date now = new Date();
        if (this.lastStatisticsUpdate == null || now.getTime() - this.lastStatisticsUpdate.getTime() > 86400000L) {
            LOGGER.info("Update stats at " + now.toString());
            try {
                Localizer.updateDBFile();
                db.updateUsageStats();
                this.lastStatisticsUpdate = now;
            }
            catch (SQLException e) {
                LOGGER.error("Error during static update. try again later", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public Worker.WorkerType getWorkerType() {
        return Worker.WorkerType.GUARDIAN;
    }

    @Override
    protected void shutdown() {
        LOGGER.info("Shutting down Guardian and all corresponding workers");
        for (WorkerManager manager : this.workerTypes) {
            try {
                this.fingerIdDB().shutdownWorkers(manager.prefix, FingerIDProperties.fingeridVersion());
            }
            catch (SQLException e) {
                LOGGER.warn("Guardian could not stop workers with prefix: " + manager.prefix);
            }
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.shutdown();
    }
}

