/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import java.util.Arrays;

public class IntRingBuffer {
    protected final int[] buffer;
    protected int offset;
    protected int len;

    public IntRingBuffer(int size) {
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new int[size];
        this.offset = 0;
        this.len = 0;
    }

    public void clear() {
        Arrays.fill(this.buffer, 0);
        this.len = 0;
        this.offset = 0;
    }

    public void add(int value) {
        this.buffer[this.offset++] = value;
        this.len = Math.min(this.len + 1, this.buffer.length);
        if (this.offset >= this.buffer.length) {
            this.offset = 0;
        }
    }

    public int median() {
        return this.buffer[this.buffer.length / 2];
    }

    public double average() {
        double avg = 0.0;
        for (int i = 0; i < this.len; ++i) {
            avg += (double)this.buffer[i];
        }
        return avg / (double)this.len;
    }
}

