/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.Ionization;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.jobs.SiriusJobs;
import de.unijena.bioinf.ChemistryBase.ms.CollisionEnergy;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.ArrayWrapperSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.chemdb.FormulaCandidate;
import de.unijena.bioinf.fingeriddb.FingerCandidate;
import de.unijena.bioinf.fingeriddb.FingerIdInstance;
import de.unijena.bioinf.fingeriddb.FingerSpectrum;
import de.unijena.bioinf.fingeriddb.FingerTreeResult;
import de.unijena.bioinf.fingeriddb.MsInput;
import de.unijena.bioinf.fingeriddb.job.JobState;
import de.unijena.bioinf.fingeriddb.job.TreeJob;
import de.unijena.bioinf.fingerworker.WebWorker;
import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.sirius.Feedback;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.IsotopePatternHandling;
import de.unijena.bioinf.sirius.Progress;
import de.unijena.bioinf.sirius.Sirius;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiriusWebWorker
extends WebWorker {
    protected Sirius sirius;
    protected String profile;
    private static final Logger LOGGER = LoggerFactory.getLogger(SiriusWebWorker.class);
    private static int[] SIZES = new int[]{200, 400, 600, 800, 1000, 1200};
    private static int[] MAXNUMBEROFTREES = new int[]{1000, 500, 300, 200, 100, 50};

    public SiriusWebWorker(String prefix, String profile) throws SQLException, DatabaseException, IOException {
        super(prefix);
        this.profile = profile;
    }

    @Override
    protected void startUpWorker() throws DatabaseException, IOException, SQLException, InterruptedException {
        super.startUpWorker();
        this.sirius = new Sirius(this.profile);
    }

    @Override
    public Worker.WorkerType getWorkerType() {
        return Worker.WorkerType.SIRIUS;
    }

    @Override
    public boolean listen() throws SQLException, DatabaseException {
        TreeJob job = this.fingerIdDB().fetchLastTreeJob(this.prefix);
        if (job == null) {
            return false;
        }
        LOGGER.info("incoming request");
        FingerIdInstance instance = this.fingerIdDB().getInstanceNoSecurityCheck(job.getInstanceId());
        MutableMs2Experiment experiment = SiriusWebWorker.fingerInstance2Ms2Experiment(instance.input);
        Deviation massDeviation = new Deviation(instance.input.maxPPM, 2.0E-4);
        FormulaConstraints constraints = null;
        switch (instance.input.allowedElements) {
            case ALL: {
                constraints = null;
                break;
            }
            case HALOGENS: {
                constraints = new FormulaConstraints("CHNOPSClBrIF");
                break;
            }
            case CHNOPS: {
                constraints = new FormulaConstraints("CHNOPS");
            }
        }
        Ionization[] allowedIons = (Ionization[])Arrays.stream(instance.input.ionizations).map(it -> PrecursorIonType.getPrecursorIonType((String)it).getIonization()).toArray(Ionization[]::new);
        HashSet<MolecularFormula> whiteForms = new HashSet<MolecularFormula>();
        for (String ion : instance.input.ionizations) {
            PrecursorIonType ionType = PrecursorIonType.getPrecursorIonType((String)ion);
            List candidates = this.chemDb().lookupMolecularFormulas(experiment.getIonMass(), massDeviation, ionType);
            for (FormulaCandidate fc : candidates) {
                if (constraints != null && constraints.isViolated(fc.getFormula())) continue;
                whiteForms.add(fc.getFormula());
            }
        }
        try {
            this.sirius.setProgress((Progress)new WebProgress(job, SiriusWebWorker.getMaxNumberOfTrees(experiment.getIonMass())));
            this.sirius.setIsotopeMode(experiment, IsotopePatternHandling.score);
            this.sirius.enableRecalibration(experiment, true);
            this.sirius.setAllowedIonModes((Ms2Experiment)experiment, allowedIons);
            this.sirius.setAllowedAdducts((Ms2Experiment)experiment, (PrecursorIonType[])Arrays.stream(allowedIons).map(PrecursorIonType::getPrecursorIonType).toArray(PrecursorIonType[]::new));
            this.sirius.setAllowedMassDeviation(experiment, massDeviation);
            this.sirius.setFormulaConstraints((Ms2Experiment)experiment, constraints);
            this.sirius.setFormulaSearchList((Ms2Experiment)experiment, whiteForms);
            List results = (List)((Sirius.SiriusIdentificationJob)SiriusJobs.getGlobalJobManager().submitJob((JJob)this.sirius.makeIdentificationJob((Ms2Experiment)experiment, 20))).takeResult();
            FingerTreeResult treeResult = new FingerTreeResult();
            treeResult.candidates = new ArrayList();
            for (IdentificationResult result : results) {
                long flags = 0L;
                try {
                    flags = this.chemDb().getFlagsByFormula(result.getMolecularFormula());
                }
                catch (DatabaseException e) {
                    LOGGER.error("Error while fetching db flag for formula");
                }
                if (flags == 0L) continue;
                FingerCandidate fc = new FingerCandidate(result.getNeutralizedJSONTree(), result.getMolecularFormula().toString(), result.getScore(), result.getTreeScore(), result.getIsotopeScore(), result.getRank(), flags);
                treeResult.candidates.add(fc);
            }
            this.fingerIdDB().submitTreeResults(job, treeResult);
        }
        catch (Throwable t) {
            job.setErrorMessage(t.getMessage());
            job.setState(JobState.CRASHED);
            this.fingerIdDB().updateTreeJobFinished(job);
            LOGGER.warn("request processing crashed", t);
        }
        LOGGER.info("request processed");
        return true;
    }

    private static int getMaxNumberOfTrees(double mz) {
        for (int k = 0; k < SIZES.length; ++k) {
            if (!(mz < (double)SIZES[k])) continue;
            return MAXNUMBEROFTREES[k];
        }
        return 0;
    }

    static MutableMs2Experiment fingerInstance2Ms2Experiment(MsInput fi) {
        ArrayList<MutableMs2Spectrum> spectra = new ArrayList<MutableMs2Spectrum>(fi.spectra.size());
        ArrayList<SimpleSpectrum> ms1Spectra = new ArrayList<SimpleSpectrum>();
        for (FingerSpectrum spec : fi.spectra) {
            if (spec.isMs1()) {
                ms1Spectra.add(new SimpleSpectrum(spec.getMz(), spec.getIntens()));
                continue;
            }
            MutableMs2Spectrum ms2 = new MutableMs2Spectrum((Spectrum)new ArrayWrapperSpectrum(spec.getMz(), spec.getIntens()));
            ms2.setCollisionEnergy(CollisionEnergy.none());
            ms2.setPrecursorMz(fi.parentMass);
            spectra.add(ms2);
        }
        MutableMs2Experiment ms2exp = new MutableMs2Experiment();
        int charge = PeriodicTable.getInstance().ionByName(fi.ionizations[0]).getCharge();
        ms2exp.setPrecursorIonType(PrecursorIonType.unknown((int)charge));
        ms2exp.setIonMass(fi.parentMass);
        if (fi.molecularFormula != null && !fi.molecularFormula.isEmpty()) {
            ms2exp.setMolecularFormula(MolecularFormula.parse((String)fi.molecularFormula));
        }
        for (Spectrum spectrum : ms1Spectra) {
            ms2exp.getMs1Spectra().add(new SimpleSpectrum(spectrum));
        }
        for (Spectrum spectrum : spectra) {
            ms2exp.getMs2Spectra().add(new MutableMs2Spectrum(spectrum));
        }
        if (ms2exp.getMs1Spectra().size() > 0) {
            ms2exp.setMergedMs1Spectrum((SimpleSpectrum)ms2exp.getMs1Spectra().get(0));
        }
        return ms2exp;
    }

    protected class WebProgress
    implements Progress {
        protected final TreeJob job;
        protected final int maxNumberOfTrees;
        protected long lastUpdate;

        public WebProgress(TreeJob job, int maxNumberOfTrees) {
            this.job = job;
            this.maxNumberOfTrees = maxNumberOfTrees;
        }

        public void init(double maxProgress) {
            if (maxProgress > (double)this.maxNumberOfTrees) {
                throw new RuntimeException("Too high mass and/or too many possible molecular formulas");
            }
            this.lastUpdate = System.currentTimeMillis();
        }

        public void update(double currentProgress, double maxProgress, String value, Feedback feedback) {
            long newTime = System.currentTimeMillis();
            if (newTime - this.lastUpdate > 5000L) {
                this.updateJobStatus(currentProgress, maxProgress);
            }
        }

        private void updateJobStatus(double currentProgress, double maxProgress) {
            try {
                this.job.setNumberOfProcessedCandidates((int)currentProgress);
                this.job.setNumberOfCandidates((int)maxProgress);
                SiriusWebWorker.this.fingerIdDB().updateTreeJobProgress(this.job);
            }
            catch (SQLException e) {
                LOGGER.error("Error when updating Job status", (Throwable)e);
            }
        }

        public void finished() {
        }

        public void info(String message) {
        }
    }
}

