/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.chemdb.ChemicalDatabase;
import de.unijena.bioinf.chemdb.DatabaseException;
import de.unijena.bioinf.fingeriddb.FingerIdDB;
import de.unijena.bioinf.fingerworker.Worker;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.LoggerFactory;

public abstract class WebWorker
extends Worker {
    protected final String prefix;
    private ChemicalDatabase chemDb = null;
    private final AtomicBoolean reconnectingChemDB = new AtomicBoolean(false);
    protected boolean isBackup;

    protected ChemicalDatabase chemDb() {
        while (this.reconnectingChemDB.get()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.chemDb;
    }

    public WebWorker(String prefix) throws SQLException {
        super(new FingerIdDB());
        this.prefix = prefix;
    }

    public boolean isBackup() {
        return this.isBackup;
    }

    public void setBackup(boolean backup) {
        this.isBackup = backup;
    }

    public void run(Runnable runnable) {
        this.run(runnable, false);
    }

    public void run(Runnable runnable, boolean shared) {
        runnable.run();
        if (!shared) {
            this.shutdown();
        }
        this.fingerIdDB().close();
        try {
            this.chemDb().close();
        }
        catch (IOException e) {
            LOGGER.error("Error whie closing Chem DB connection!", (Throwable)e);
        }
    }

    protected void startUpWorker() throws DatabaseException, IOException, SQLException, InterruptedException {
        if (this.chemDb == null) {
            this.chemDb = new ChemicalDatabase();
        } else {
            this.chemDb().refresh();
        }
        LOGGER.info("Start listening at '" + this.prefix + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("Starting Worker...");
        try {
            try {
                this.id = this.registerToDB(this.prefix, this.isBackup);
                LOGGER.info("...Worker registered to DB with ID " + this.id);
                this.startUpWorker();
                Worker.Heartbeat heartbeat = new Worker.Heartbeat();
                heartbeat.start();
                int iddleCounter = 0;
                this.fingerIdDB().setRunning(this.id);
                LOGGER.info("...Worker Successfully Started!");
                boolean isShutdown = this.isShutdown();
                while (!isShutdown) {
                    try {
                        if (!this.listen()) {
                            Thread.sleep(1000L);
                            if (++iddleCounter % 300 == 0 && this.isBackup) break;
                        }
                        isShutdown = this.isShutdown();
                    }
                    catch (DatabaseException | SQLException e) {
                        LOGGER.warn("Could not connect to DB try reconnect in 20s...", e);
                        this.waitForDBReconnection();
                    }
                    catch (Throwable e) {
                        LoggerFactory.getLogger(this.getClass()).error("Unknown Error", e);
                    }
                }
                heartbeat.stopAndJoinHeartbeat();
                LOGGER.info("Shutdown webworker");
            }
            catch (SQLException e) {
                LOGGER.warn("Could not connect to DB try reconnect...", (Throwable)e);
                this.waitForDBReconnection();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected Interruption", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected Error", (Throwable)e);
        }
        finally {
            this.shutdown();
            this.fingerIdDB().close();
            try {
                this.chemDb().close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close csi_fingerid DB connection", (Throwable)e);
            }
        }
    }

    @Override
    protected void waitForDBReconnection() {
        this.reconnectChemDB();
        super.waitForDBReconnection();
    }

    protected void reconnectChemDB() {
        if (this.reconnectingChemDB.get()) {
            return;
        }
        this.reconnectingChemDB.set(true);
        while (this.reconnectingChemDB.get()) {
            try {
                try {
                    this.chemDb.refresh();
                }
                catch (DatabaseException e) {
                    LOGGER.warn("Could not reconnect ChemDB. Try reinstantiation");
                    try {
                        this.chemDb.close();
                    }
                    catch (IOException e1) {
                        LOGGER.error("Could not close Chemical DB connection", (Throwable)e1);
                    }
                    this.chemDb = new ChemicalDatabase();
                }
                this.reconnectingChemDB.set(false);
            }
            catch (DatabaseException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error during ChemDB reconnect, Waiting 20s ...", (Throwable)e);
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public abstract boolean listen() throws SQLException, DatabaseException;

    public String getPrefix() {
        return this.prefix;
    }
}

