/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.FingerIdDB;
import de.unijena.bioinf.fingeriddb.job.FingerIdJob;
import de.unijena.bioinf.fingeriddb.job.SiriusPredictionJob;
import de.unijena.bioinf.fingeriddb.job.TreeJob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Worker
implements Runnable {
    protected static final long NUMBER_OF_MILLISECONDS_A_MINUTE = 60000L;
    protected static final long NUMBER_OF_MILLISECONDS_FIVE_MINUTES = 300000L;
    protected static final long NUMBER_OF_MILLISECONDS_A_DAY = 86400000L;
    protected static final long NUMBER_OF_MILLISECONDS_A_HALVE_DAY = 43200000L;
    protected static final long NUMBER_OF_MILLISECONDS_TEN_SECONDS = 5000L;
    private final AtomicBoolean reconnectingFingerIdDB = new AtomicBoolean(false);
    protected static final Logger LOGGER = LoggerFactory.getLogger(Worker.class);
    protected int id = -1;
    private final FingerIdDB fingerIdDB;

    protected FingerIdDB fingerIdDB() {
        while (this.reconnectingFingerIdDB.get()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.fingerIdDB;
    }

    public Worker(FingerIdDB fingerIdDB) {
        this.fingerIdDB = fingerIdDB;
    }

    abstract WorkerType getWorkerType();

    public boolean isShutdown() throws SQLException {
        return this.fingerIdDB().isShutdown(this.id);
    }

    protected void shutdown() {
        try {
            this.unregisterFromDB();
        }
        catch (SQLException e) {
            LOGGER.error("Error when unregistering worker with ID " + this.id + " from csi_fingerid DB ", (Throwable)e);
        }
    }

    protected int registerToDB(String prefix, boolean isBackup) throws SQLException {
        return this.fingerIdDB().addWorker(prefix, FingerIDProperties.fingeridVersion(), this.getWorkerType().name(), "NONE", Boolean.valueOf(isBackup));
    }

    protected void unregisterFromDB() throws SQLException {
        this.fingerIdDB().removeWorker(this.id);
    }

    protected void waitForDBReconnection() {
        this.reconnectFingerIdDB();
    }

    protected void reconnectFingerIdDB() {
        if (this.reconnectingFingerIdDB.get()) {
            return;
        }
        this.reconnectingFingerIdDB.set(true);
        while (this.reconnectingFingerIdDB.get()) {
            try {
                this.fingerIdDB.refresh();
                this.reconnectingFingerIdDB.set(false);
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error during FingerDB reconnect, Waiting 20s", (Throwable)e);
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected class Heartbeat
    extends Thread {
        private AtomicBoolean isRunning = null;

        protected Heartbeat() {
        }

        @Override
        public void run() {
            try {
                this.isRunning = new AtomicBoolean(true);
                while (this.isRunning.get()) {
                    try {
                        Worker.this.fingerIdDB().updateWorkerAliveState(Worker.this.id);
                        Thread.sleep(5000L);
                    }
                    catch (SQLException e) {
                        LoggerFactory.getLogger(Heartbeat.class).warn("Could not connect to db for heartbeat -> retry in 20 sec");
                        Thread.sleep(10000L);
                    }
                }
                LoggerFactory.getLogger(Heartbeat.class).info("Heartbeat canceled regularly");
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger(Heartbeat.class).error("Interuption of HeartbeatThread", (Throwable)e);
            }
        }

        public void stopHeartbeat() {
            if (this.isRunning == null) {
                throw new RuntimeException("Thread has not been started");
            }
            this.isRunning.set(false);
        }

        public void stopAndJoinHeartbeat() throws InterruptedException {
            this.stopHeartbeat();
            this.join();
        }
    }

    public static enum WorkerType {
        SIRIUS(new String[]{TreeJob.getTableName()}),
        FINGER_ID(new String[]{FingerIdJob.getTableName(), SiriusPredictionJob.getTableName()}),
        GUARDIAN(null);

        private final String[] jobTables;

        private WorkerType(String[] jobTableNames) {
            this.jobTables = jobTableNames;
        }

        public String[] jobTables() {
            return this.jobTables;
        }
    }
}

