/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.FingerIdDB;
import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.WorkerProperties;
import de.unijena.bioinf.fingerworker.executor.AbstractWorkerExecutor;
import de.unijena.bioinf.fingerworker.executor.LocalExecutor;
import de.unijena.bioinf.fingerworker.executor.SGEExecutor;
import de.unijena.bioinf.fingerworker.executor.WorkerExecutor;
import java.sql.SQLException;
import org.slf4j.LoggerFactory;

public class WorkerManager {
    final String prefix;
    final Worker.WorkerType type;
    final WorkerProperties workerProperties;
    private final WorkerExecutor executor;
    private int hashCache = Integer.MIN_VALUE;

    public WorkerManager(String prefix, Worker.WorkerType type, WorkerProperties properties) {
        this.prefix = prefix;
        this.type = type;
        this.workerProperties = properties;
        this.executor = this.getBackupExecutorInstance();
    }

    private <T extends AbstractWorkerExecutor> T getBackupExecutorInstance() {
        AbstractWorkerExecutor executor;
        String ref = this.workerProperties.getProperty("de.unijena.bioinf.fingerid.fingerworker.executor.backup");
        try {
            Class<?> cls = ClassLoader.getSystemClassLoader().loadClass(ref);
            executor = (AbstractWorkerExecutor)cls.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Illegal executor Class. Falling back to " + SGEExecutor.class.getSimpleName() + ".", (Throwable)e);
            executor = new SGEExecutor();
        }
        executor.setWorkerProperties(this.workerProperties);
        return (T)executor;
    }

    public void checkLocalWorkers(FingerIdDB fingerIdDB) throws SQLException {
        int activeLocalWorkers = fingerIdDB.countNumberOfRegisteredWorkersOnHost(this.prefix, FingerIDProperties.fingeridVersion(), this.type.name());
        int numberOfLocals = this.workerProperties.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.number.local", this.type);
        for (int toAdd = numberOfLocals - activeLocalWorkers; toAdd > 0; --toAdd) {
            LocalExecutor.INSTANCE.execute(this.prefix, this.type);
        }
    }

    public void checkBackupWorkers(FingerIdDB fingerIdDB) throws SQLException {
        int jobs = fingerIdDB.countNumberOfActiveJobs(this.type.jobTables());
        int THRESHOLD_FOR_ACTIVATING_CLUSTER_WORKERS = this.workerProperties.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.increaseThreshold.backup", this.type);
        int DECREASE = this.workerProperties.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.decreasePerWorker.backup", this.type);
        if (jobs >= THRESHOLD_FOR_ACTIVATING_CLUSTER_WORKERS) {
            int maxWorkers = this.workerProperties.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.maxNumber.backup", this.type);
            int activeBackups = fingerIdDB.countNumberOfActiveBackupWorkers(this.prefix, FingerIDProperties.fingeridVersion(), this.type.name());
            int nf = jobs;
            for (int maxCount = maxWorkers - activeBackups; maxCount > 0 && nf >= THRESHOLD_FOR_ACTIVATING_CLUSTER_WORKERS; --maxCount) {
                if (nf < THRESHOLD_FOR_ACTIVATING_CLUSTER_WORKERS) continue;
                this.executor.execute(this.prefix, this.type);
                nf -= DECREASE;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerManager that = (WorkerManager)o;
        if (!this.prefix.equals(that.prefix)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.workerProperties.equals(that.workerProperties);
    }

    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            int result = this.prefix.hashCode();
            result = 31 * result + this.type.hashCode();
            this.hashCache = result = 31 * result + this.workerProperties.hashCode();
        }
        return this.hashCache;
    }
}

