/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.Unparsed;
import de.unijena.bioinf.fingerid.utils.FingerIDProperties;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import de.unijena.bioinf.fingerworker.FingerWorkerMain;
import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.WorkerProperties;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class WorkerOpts {
    private static final EnumSet<Worker.WorkerType> NO_GUARDIAN_LIST = EnumSet.complementOf(EnumSet.of(Worker.WorkerType.GUARDIAN));
    TaskType task = null;
    private EnumSet<Worker.WorkerType> workerTypes;
    private List<PredictorType> predictorTypes;
    private EnumSet<PredictorType> predictors = null;
    boolean isBackup;
    boolean all;
    boolean notWatchWorkers;
    boolean noStats;
    boolean localhost;
    List<String> prefixe;
    String version = FingerIDProperties.fingeridVersion();
    int id;
    String profile;
    File confidencePubchem;
    File confidenceBio;
    private File covarianceTree;
    private int threads = 0;
    List<File> files;

    @Option(shortName={"t"}, description="specify the task you want to execute")
    void setTask(TaskType task) {
        this.task = task;
    }

    @Option(shortName={"w"}, description="Specify the Workertype", defaultToNull=true)
    void setWorkerTypes(List<Worker.WorkerType> type) {
        this.workerTypes = type == null || type.isEmpty() ? null : EnumSet.copyOf(type);
    }

    public EnumSet<Worker.WorkerType> workerTypes() {
        switch (this.task) {
            case START: {
                return this.workerTypes == null || this.workerTypes.isEmpty() ? EnumSet.allOf(Worker.WorkerType.class) : this.workerTypes;
            }
            case SHOW: {
                return this.workerTypes == null || this.workerTypes.isEmpty() ? EnumSet.noneOf(Worker.WorkerType.class) : this.workerTypes;
            }
        }
        return this.workerTypes == null || this.workerTypes.isEmpty() ? NO_GUARDIAN_LIST : this.workerTypes;
    }

    @Option(shortName={"P"}, description="Specify the predictors that should be used by the fingerid worker", defaultToNull=true)
    void setPredictorType(List<PredictorType> type) {
        this.predictorTypes = type;
    }

    public EnumSet<PredictorType> getPredictors() {
        if (this.predictors == null || this.predictors.isEmpty()) {
            this.predictors = this.predictorTypes == null || this.predictorTypes.isEmpty() ? PredictorType.defaultPredictorSet() : EnumSet.copyOf(this.predictorTypes);
        }
        this.predictors = PredictorType.makeValid(this.predictors);
        return this.predictors;
    }

    boolean isGuardian() {
        return this.workerTypes().contains((Object)Worker.WorkerType.GUARDIAN);
    }

    boolean isSirius() {
        return this.workerTypes().contains((Object)Worker.WorkerType.SIRIUS);
    }

    boolean isFingerid() {
        return this.workerTypes().contains((Object)Worker.WorkerType.FINGER_ID);
    }

    @Option(description="this worker will shutdown itself as soon as the job queue is empty")
    void setBackup(boolean isBackup) {
        this.isBackup = isBackup;
    }

    @Option(description="This will stop local and backup workers of the given specs")
    void setAll(boolean all) {
        this.all = all;
    }

    @Option(description="If set, the quardian will NOT automatically start and restart local workers")
    void setNoLocalWorkerRestart(boolean noWatchWorkers) {
        this.notWatchWorkers = noWatchWorkers;
    }

    @Option(description="If set, the guardian will not make usage stats and doe not clean the job lists")
    void setNoStats(boolean noStats) {
        this.noStats = noStats;
    }

    @Option(description="If set, the worker will search at localhost for all db connections. This is needed that local workers survive the IP-float")
    void setLocalhost(boolean localhost) {
        this.localhost = localhost;
    }

    @Option(shortName={"x"}, description="this worker will only process jobs with the given prefix", defaultToNull=true)
    public void setPrefix(List<String> prefixe) {
        this.prefixe = prefixe;
    }

    String prefix() {
        return this.prefixe == null || this.prefixe.isEmpty() ? null : this.prefixe.get(0);
    }

    @Option(description="Specify the version of a worker to shutdown, this allows to delete outdated workers from the db", defaultToNull=true)
    public void setVersion(String version) {
        this.version = version == null ? FingerIDProperties.fingeridVersion() : version;
    }

    @Option(shortName={"i"}, description="Stop worker with specific ID", defaultValue={"-1"})
    public void setId(int id) {
        this.id = id;
    }

    @Option(shortName={"p"}, description="either orbitrap, qtof or fticr", defaultValue={"qtof"})
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Option(longName={"confidence_pubchem"}, description="file of confidence predictors", defaultToNull=true)
    public void setConfidencePubchem(File confidencePubchem) {
        this.confidencePubchem = confidencePubchem;
    }

    @Option(longName={"confidence_bio"}, description="file of confidence predictors", defaultToNull=true)
    public void setConfidenceBio(File confidenceBio) {
        this.confidenceBio = confidenceBio;
    }

    @Option(longName={"covariance_tree"}, description="file with covariance tree description", defaultToNull=true)
    public void setCovarianceTree(File covarianceTree) {
        this.covarianceTree = covarianceTree;
    }

    @Nullable
    File covarianceTree() {
        if (this.covarianceTree == null) {
            if (this.getPredictors().contains(PredictorType.CSI_FINGERID_POSITIVE)) {
                this.covarianceTree = FingerWorkerMain.FINGER_WORKER_HOME.resolve("data").resolve("treeWithCovariance.tree").toFile();
            } else if (this.getPredictors().contains(PredictorType.CSI_FINGERID_NEGATIVE)) {
                this.covarianceTree = FingerWorkerMain.FINGER_WORKER_HOME.resolve("data").resolve("treeWithCovariance_neg.tree").toFile();
            }
        }
        return this.covarianceTree == null || Files.notExists(this.covarianceTree.toPath(), new LinkOption[0]) ? null : this.covarianceTree;
    }

    @Option(description="number of parallel workers", defaultValue={"0"})
    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getThreads(WorkerProperties props, Worker.WorkerType type) {
        if (this.threads > 0) {
            return this.threads;
        }
        if (this.isBackup) {
            return props.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.threads.backup", type);
        }
        return props.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.threads.local", type);
    }

    @Unparsed
    public void setFiles(List<File> files) {
        this.files = files;
    }

    @Nullable
    File fingerIdData() {
        if (this.files == null || this.files.isEmpty()) {
            if (this.getPredictors().contains(PredictorType.CSI_FINGERID_POSITIVE)) {
                return FingerWorkerMain.FINGER_WORKER_HOME.resolve("data").resolve("fingerid.data").toFile();
            }
            if (this.getPredictors().contains(PredictorType.CSI_FINGERID_NEGATIVE)) {
                return FingerWorkerMain.FINGER_WORKER_HOME.resolve("data").resolve("fingerid_neg.data").toFile();
            }
            return null;
        }
        return this.files.get(0);
    }

    static enum TaskType {
        START,
        SHOW,
        STOP;

    }
}

