/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker;

import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.WorkerOpts;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class WorkerProperties
extends Properties {
    private static final String DEFAULT = "1";
    public static final String FINGER_WORKER_HOME = "de.unijena.bioinf.fingerid.fingerworker.home";
    public static final String NUMBER_LOCAL_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.number.local";
    public static final String THREADS_LOCAL_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.threads.local";
    public static final String BACKUP_WORKERS_EXECUTOR = "de.unijena.bioinf.fingerid.fingerworker.executor.backup";
    public static final String PATH_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.path.backup";
    public static final String Q_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.q.backup";
    public static final String THREADS_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.threads.backup";
    public static final String MAX_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.maxNumber.backup";
    public static final String MIN_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.minNumber.backup";
    public static final String INCREASE_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.increaseNumber.backup";
    public static final String THRESHOLD_TO_SPAWN_BACKUP_WORKERS = "de.unijena.bioinf.fingerid.fingerworker.increaseThreshold.backup";
    public static final String DECREASE_PER_BACKUP_WORKER = "de.unijena.bioinf.fingerid.fingerworker.decreasePerWorker.backup";
    public static final String PATH_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.path.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String Q_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.q.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String THREADS_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.threads.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String MAX_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.maxNumber.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String MIN_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.minNumber.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String INCREASE_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.increaseNumber.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String THRESHOLD_TO_SPAWN_BACKUP_WORKERS_SIRIUS = "de.unijena.bioinf.fingerid.fingerworker.increaseThreshold.backup." + Worker.WorkerType.SIRIUS.name();
    public static final String PATH_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.path.backup." + Worker.WorkerType.FINGER_ID.name();
    public static final String Q_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.q.backup." + Worker.WorkerType.FINGER_ID.name();
    public static final String THREADS_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.threads.backup." + Worker.WorkerType.FINGER_ID.name();
    public static final String MAX_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.maxNumber.backup." + Worker.WorkerType.FINGER_ID.name();
    public static final String MIN_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.minNumber.backup." + Worker.WorkerType.FINGER_ID.name();
    public static final String INCREASE_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.increaseNumber.backup." + Worker.WorkerType.FINGER_ID.name();
    public static final String THRESHOLD_TO_SPAWN_BACKUP_WORKERS_FINGER_ID = "de.unijena.bioinf.fingerid.fingerworker.increaseThreshold.backup." + Worker.WorkerType.FINGER_ID.name();
    public final WorkerOpts cmdArgs;

    public WorkerProperties(WorkerOpts opts) {
        this(null, opts);
    }

    public WorkerProperties(Properties defaults, WorkerOpts opts) {
        super(defaults);
        this.cmdArgs = opts;
    }

    public String getStringProperty(String key, String backupKey, String defaultValue) {
        return this.getProperty(key, this.getProperty(backupKey, defaultValue));
    }

    public String getStringProperty(String key, String backupKey) {
        return this.getStringProperty(key, backupKey, null);
    }

    public int getIntProperty(String key, String backupKey) {
        return Integer.valueOf(this.getStringProperty(key, backupKey));
    }

    public double getDoubleProperty(String key, String backupKey) {
        return Double.valueOf(this.getStringProperty(key, backupKey));
    }

    public boolean getBooleanProperty(String key, String backupKey) {
        return Boolean.valueOf(this.getStringProperty(key, backupKey));
    }

    public String getStringProperty(String key, Worker.WorkerType type) {
        return this.getStringProperty(key + "." + type.name(), key);
    }

    public int getIntProperty(String key, Worker.WorkerType type) {
        return Integer.valueOf(this.getStringProperty(key, type));
    }

    public double getDoubleProperty(String key, Worker.WorkerType type) {
        return Double.valueOf(this.getStringProperty(key, type));
    }

    public boolean getBooleanProperty(String key, Worker.WorkerType type) {
        return Boolean.valueOf(this.getStringProperty(key, type));
    }

    public Path getFingerWorkerHome() {
        return Paths.get(this.getProperty(FINGER_WORKER_HOME), new String[0]);
    }
}

