/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker.executor;

import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.WorkerProperties;
import de.unijena.bioinf.fingerworker.executor.AbstractWorkerExecutor;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;

public class LocalExecutor
extends AbstractWorkerExecutor {
    public static final LocalExecutor INSTANCE = new LocalExecutor();

    public static void setGlobalWorkerProperties(WorkerProperties props) {
        INSTANCE.setWorkerProperties(props);
    }

    @Override
    public void execute(String prefix, Worker.WorkerType type) {
        try {
            Path fingerIDHome = this.workerProperties.getFingerWorkerHome();
            Path bin = fingerIDHome.resolve("bin");
            int threads = this.workerProperties.cmdArgs.getThreads(this.workerProperties, type);
            Object[] command = new String[]{bin.resolve("worker").toAbsolutePath().toString(), "-t", "START", "--prefix", prefix, "--threads", Integer.toString(threads), "-w", type.toString()};
            LOGGER.info("Running: " + Arrays.toString(command));
            this.exec((String[])command);
        }
        catch (IOException e) {
            LOGGER.error("Could not start local worker process", (Throwable)e);
        }
    }
}

