/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerworker.executor;

import de.unijena.bioinf.fingerworker.Worker;
import de.unijena.bioinf.fingerworker.executor.AbstractWorkerExecutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class SGEExecutor
extends AbstractWorkerExecutor {
    @Override
    public void execute(String prefix, Worker.WorkerType type) {
        try {
            String q = this.workerProperties.getProperty("de.unijena.bioinf.fingerid.fingerworker.q.backup", "FingerID.q");
            int maxWorker = this.workerProperties.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.maxNumber.backup", type);
            int threads = this.workerProperties.getIntProperty("de.unijena.bioinf.fingerid.fingerworker.threads.backup", type);
            if (this.numberOfFingerIdWorkerInQueue() < maxWorker) {
                Path localFingerIDHome = this.workerProperties.getFingerWorkerHome();
                Path fingerIDHome = Paths.get(this.workerProperties.getProperty("de.unijena.bioinf.fingerid.fingerworker.path.backup", "/vol/fingerid/fingerworker"), new String[0]).resolve(localFingerIDHome.getFileName());
                Path bin = fingerIDHome.resolve("bin");
                Path log = fingerIDHome.getParent().resolve("log");
                Object[] command = new String[]{"qsub", "-pe", "threads", Integer.toString(threads), "-q", q, "-o", log.toAbsolutePath().toString(), "-e", log.toAbsolutePath().toString(), bin.resolve("sgeWorker.sh").toAbsolutePath().toString(), bin.resolve("worker").toAbsolutePath().toString(), "-t", "START", "--backup", "--prefix", prefix, "--threads", Integer.toString(threads), "-w", type.toString()};
                LOGGER.info("Running: " + Arrays.toString(command));
                this.exec((String[])command);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not execute SGE Backup worker process", (Throwable)e);
        }
    }

    private int numberOfFingerIdWorkerInQueue() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(Arrays.asList("qstat", "-u", "fingerid"));
        builder.redirectErrorStream(false);
        Process p = builder.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        int counter = 0;
        while (br.readLine() != null) {
            ++counter;
        }
        return counter - 2;
    }
}

