/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.iokr;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.file.Files;

public class IOKRPredict {
    protected double[] model;
    protected double[] mklWeights;

    public static double readBinaryScalar(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        DoubleBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        return buf.get();
    }

    public static double[] readBinaryVector(int m, File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        DoubleBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[] matrix = new double[m];
        for (int i = 0; i < m; ++i) {
            matrix[i] = buf.get();
        }
        return matrix;
    }

    public static double[][] readBinaryMatrix(int m, int n, File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        DoubleBuffer buf = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
        double[][] matrix = new double[m][n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                matrix[j][i] = buf.get();
            }
        }
        return matrix;
    }

    public IOKRPredict(double[] model, double[] mklWeights) {
        this.model = model;
        this.mklWeights = mklWeights;
    }

    public double[] predict(double[][] testKernel) {
        double[] mkl = this.computeMkl(testKernel);
        return IOKRPredict.choleskySolve(this.model, mkl);
    }

    private double[] computeMkl(double[][] testKernel) {
        double[] mkl = new double[testKernel[0].length];
        for (int i = 0; i < this.mklWeights.length; ++i) {
            double[] row = testKernel[i];
            double weight = this.mklWeights[i];
            for (int j = 0; j < row.length; ++j) {
                int n = j;
                mkl[n] = mkl[n] + row[j] * weight;
            }
        }
        return mkl;
    }

    public static double[] choleskySolve(double[] L, double[] x) {
        double[] y = IOKRPredict.ltsolve(L, x);
        return IOKRPredict.ltTransposedSolve(L, y);
    }

    private static double[] ltTransposedSolve(double[] G, double[] y) {
        double[] transposed = (double[])G.clone();
        int l = 0;
        int r = 0;
        for (int row = 0; row < y.length; ++row) {
            int c = r;
            for (int col = row; col < y.length; ++col) {
                transposed[l++] = G[c];
                c += col + 1;
            }
            r += row + 2;
        }
        return IOKRPredict.utsolve(transposed, y);
    }

    public static double[] lusolve(double[] lt, double[] ut, double[] x) {
        double[] y = IOKRPredict.ltsolve(lt, x);
        return IOKRPredict.utsolve(ut, y);
    }

    public static double[] ltsolve(double[] lt, double[] y) {
        double[] x = new double[y.length];
        int offset = 0;
        for (int i = 0; i < y.length; ++i) {
            double val = y[i];
            for (int j = 0; j < i; ++j) {
                val -= lt[offset++] * x[j];
            }
            x[i] = val /= lt[offset++];
        }
        return x;
    }

    public static double[] utsolve(double[] ut, double[] y) {
        double[] x = new double[y.length];
        int n = y.length;
        int offset = ut.length - 1;
        for (int i = n - 1; i >= 0; --i) {
            double val = y[i];
            for (int j = n - 1; j > i; --j) {
                val -= ut[offset--] * x[j];
            }
            x[i] = val /= ut[offset--];
        }
        return x;
    }

    public double[] getModel() {
        return this.model;
    }

    public double[] getMklWeights() {
        return this.mklWeights;
    }
}

