/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.iokr;

import de.unijena.bioinf.ChemistryBase.fp.ArrayFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;

public class IOKRScore {
    protected final double gamma;
    protected final ArrayFingerprint[] trainingFingerprints;
    protected final double[] rowMean;
    protected final double matrixMean;

    public IOKRScore(ArrayFingerprint[] trainingFingerprints, double[] rowMean, double gamma) {
        this.gamma = gamma;
        this.trainingFingerprints = trainingFingerprints;
        this.rowMean = rowMean;
        double r = 0.0;
        for (double val : rowMean) {
            r += val;
        }
        this.matrixMean = r / (double)rowMean.length;
    }

    public double computeScore(Fingerprint candidateFingerprint, double[] iokrPrediction) {
        ArrayFingerprint candidate = candidateFingerprint.asArray();
        double[] kernel = new double[this.trainingFingerprints.length];
        double colMean = 0.0;
        for (int i = 0; i < this.trainingFingerprints.length; ++i) {
            ArrayFingerprint train = this.trainingFingerprints[i];
            double tanimoto = candidate.tanimoto(train);
            kernel[i] = Math.exp(-this.gamma * (2.0 - 2.0 * tanimoto));
            colMean += kernel[i];
        }
        colMean /= (double)kernel.length;
        double score = 0.0;
        for (int i = 0; i < kernel.length; ++i) {
            score += iokrPrediction[i] * ((kernel[i] + this.matrixMean - this.rowMean[i] - colMean) / Math.sqrt((1.0 + this.matrixMean - 2.0 * this.rowMean[i]) * (1.0 - 2.0 * colMean + this.matrixMean)));
        }
        return score;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double[] getRowMean() {
        return this.rowMean;
    }

    public double getMatrixMean() {
        return this.matrixMean;
    }
}

