/*
 * Decompiled with CFR 0.152.
 */
package utils.collections;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import utils.reflection.ReflectionUtils;

public class CloningUtils {
    public static <T> T clone(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return CloningUtils.cloneArray(object);
        }
        if (ReflectionUtils.hasInterface(clazz, Collection.class) || ReflectionUtils.hasInterface(clazz, Map.class)) {
            return CloningUtils.cloneCollection(object);
        }
        return CloningUtils.cloneObject(object);
    }

    protected static <T, E> T cloneArray(T object) throws CloneNotSupportedException {
        Class<?> clazz = object.getClass();
        Class<?> component = clazz.getComponentType();
        if (component.isPrimitive()) {
            if (component.equals(Boolean.TYPE)) {
                return (T)((boolean[])object).clone();
            }
            if (component.equals(Character.TYPE)) {
                return (T)((char[])object).clone();
            }
            if (component.equals(Byte.TYPE)) {
                return (T)((byte[])object).clone();
            }
            if (component.equals(Short.TYPE)) {
                return (T)((short[])object).clone();
            }
            if (component.equals(Integer.TYPE)) {
                return (T)((int[])object).clone();
            }
            if (component.equals(Long.TYPE)) {
                return (T)((long[])object).clone();
            }
            if (component.equals(Float.TYPE)) {
                return (T)((float[])object).clone();
            }
            if (component.equals(Double.TYPE)) {
                return (T)((double[])object).clone();
            }
            throw new CloneNotSupportedException(clazz.getCanonicalName());
        }
        Object[] arr = (Object[])object;
        Object[] copy = (Object[])Array.newInstance(component, arr.length);
        int i = 0;
        while (i < arr.length) {
            copy[i] = CloningUtils.clone(arr[i]);
            ++i;
        }
        return (T)copy;
    }

    protected static <T, K, E> T cloneCollection(T object) throws CloneNotSupportedException {
        Class<?> clazz = object.getClass();
        try {
            if (ReflectionUtils.hasInterface(clazz, Collection.class)) {
                Collection collection = (Collection)object;
                Collection copy = (Collection)clazz.newInstance();
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    copy.add(CloningUtils.clone(it.next()));
                }
                return (T)copy;
            }
            Map map = (Map)object;
            Map copy = (Map)clazz.newInstance();
            for (Object key : map.keySet()) {
                copy.put(CloningUtils.clone(key), CloningUtils.clone(map.get(key)));
            }
            return (T)copy;
        }
        catch (InstantiationException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (UnsupportedOperationException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }

    protected static <T> T cloneObject(T object) throws CloneNotSupportedException {
        Class<?> clazz = object.getClass();
        try {
            if (clazz.equals(Boolean.class)) {
                return (T)new Boolean((Boolean)object);
            }
            if (clazz.equals(Character.class)) {
                return (T)new Character(((Character)object).charValue());
            }
            if (clazz.equals(Byte.class)) {
                return (T)new Byte((Byte)object);
            }
            if (clazz.equals(Short.class)) {
                return (T)new Short((Short)object);
            }
            if (clazz.equals(Integer.class)) {
                return (T)new Integer((Integer)object);
            }
            if (clazz.equals(Long.class)) {
                return (T)new Long((Long)object);
            }
            if (clazz.equals(Float.class)) {
                return (T)new Float(((Float)object).floatValue());
            }
            if (clazz.equals(Double.class)) {
                return (T)new Double((Double)object);
            }
            if (ReflectionUtils.hasInterface(clazz, Cloneable.class)) {
                return (T)clazz.getMethod("clone", new Class[0]).invoke(object, new Object[0]);
            }
            if (Modifier.isPublic(clazz.getMethod("clone", new Class[0]).getModifiers())) {
                return (T)clazz.getMethod("clone", new Class[0]).invoke(object, new Object[0]);
            }
            throw new CloneNotSupportedException(clazz.getCanonicalName());
        }
        catch (IllegalArgumentException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            throw new CloneNotSupportedException(e.getLocalizedMessage());
        }
    }
}

