/*
 * Decompiled with CFR 0.152.
 */
package utils.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import utils.collections.DescendingValueComparator;
import utils.collections.ValueComparator;

public class CollectionUtils {
    public static <E> int search(List<E> haystack, E needle, Rounding rounding, Comparator<E> comparator) {
        Object[] arr = (Object[])Array.newInstance(haystack.get(0).getClass(), 0);
        return CollectionUtils.search(haystack.toArray(arr), needle, rounding, comparator);
    }

    public static <E> int search(E[] haystack, E needle, Rounding rounding, Comparator<E> comparator) {
        Object[] values = (Object[])Array.newInstance(haystack[0].getClass(), haystack.length);
        System.arraycopy(haystack, 0, values, 0, haystack.length);
        Arrays.sort(values, comparator);
        return CollectionUtils.binarySearch(values, needle, rounding, comparator, 0);
    }

    public static <E extends Comparable<E>> int search(List<E> haystack, E needle, Rounding rounding) {
        Comparable[] arr = (Comparable[])Array.newInstance(((Comparable)haystack.get(0)).getClass(), 0);
        return CollectionUtils.search((Comparable[])haystack.toArray(arr), needle, (Rounding)rounding);
    }

    public static <E extends Comparable<E>> int search(E[] haystack, E needle, Rounding rounding) {
        Object[] values = (Comparable[])Array.newInstance(haystack[0].getClass(), haystack.length);
        System.arraycopy(haystack, 0, values, 0, haystack.length);
        Arrays.sort(values);
        return CollectionUtils.binarySearch((Comparable[])values, needle, (Rounding)rounding, (int)0);
    }

    protected static <E extends Comparable<E>> int binarySearch(E[] haystack, E needle, Rounding rounding, int offset) {
        if (haystack.length > 2) {
            E median = haystack[haystack.length / 2];
            int c = median.compareTo(needle);
            if (c > 0) {
                return CollectionUtils.binarySearch((Comparable[])((Comparable[])Arrays.copyOf(haystack, haystack.length / 2 + 1)), needle, (Rounding)rounding, (int)offset);
            }
            if (c < 0) {
                return CollectionUtils.binarySearch((Comparable[])((Comparable[])Arrays.copyOfRange(haystack, haystack.length / 2, haystack.length)), needle, (Rounding)rounding, (int)(offset + haystack.length / 2));
            }
            return offset + haystack.length / 2;
        }
        if (haystack.length == 1) {
            return offset;
        }
        if (haystack.length == 2) {
            if (haystack[0].compareTo(needle) == 0) {
                return offset;
            }
            if (haystack[1].compareTo(needle) == 0) {
                return offset + 1;
            }
            if (rounding == Rounding.FLOOR) {
                return offset;
            }
            return offset + 1;
        }
        return -1;
    }

    protected static <E> int binarySearch(E[] haystack, E needle, Rounding rounding, Comparator<E> comparator, int offset) {
        if (haystack.length > 2) {
            E median = haystack[haystack.length / 2];
            int c = comparator.compare(median, needle);
            if (c > 0) {
                return CollectionUtils.binarySearch(Arrays.copyOf(haystack, haystack.length / 2 + 1), needle, rounding, comparator, offset);
            }
            if (c < 0) {
                return CollectionUtils.binarySearch(Arrays.copyOfRange(haystack, haystack.length / 2, haystack.length), needle, rounding, comparator, offset + haystack.length / 2);
            }
            return offset + haystack.length / 2;
        }
        if (haystack.length == 1) {
            return offset;
        }
        if (haystack.length == 2) {
            if (comparator.compare(haystack[0], needle) == 0) {
                return offset;
            }
            if (comparator.compare(haystack[1], needle) == 0) {
                return offset + 1;
            }
            if (rounding == Rounding.FLOOR) {
                return offset;
            }
            return offset + 1;
        }
        return -1;
    }

    public static <E> List<E> complement(List<E> list1, List<E> list2) {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(list1);
        list.removeAll(list2);
        return list;
    }

    public static <E, L extends List<E>> List<E> complement(Class<L> clazz, List<E> list1, List<E> list2) {
        ArrayList<E> list;
        try {
            list = (ArrayList<E>)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            list = new ArrayList<E>();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            list = new ArrayList();
        }
        list.addAll(list2);
        list.removeAll(list1);
        return list;
    }

    public static <E> List<E> union(List<E> list1, List<E> list2) {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(list1);
        list.addAll(list2);
        return list;
    }

    public static <E, L extends List<E>> List<E> union(Class<L> clazz, List<E> list1, List<E> list2) {
        ArrayList<E> list;
        try {
            list = (ArrayList<E>)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            list = new ArrayList<E>();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            list = new ArrayList();
        }
        list.addAll(list1);
        list.addAll(list2);
        return list;
    }

    public static <E> List<E> intersect(List<E> list1, List<E> list2) {
        ArrayList<E> list = new ArrayList<E>();
        list.addAll(list1);
        list.retainAll(list2);
        return list;
    }

    public static <E, L extends List<E>> List<E> intersect(Class<L> clazz, List<E> list1, List<E> list2) {
        ArrayList<E> list;
        try {
            list = (ArrayList<E>)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            list = new ArrayList<E>();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            list = new ArrayList();
        }
        list.addAll(list1);
        list.retainAll(list2);
        return list;
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortMapByValues(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new ValueComparator());
        return entries;
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> sortMapDescendingByValues(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new DescendingValueComparator());
        return entries;
    }

    public static <E> E[] toArray(Class<E> clazz, List<E> list) {
        Object[] arr = (Object[])Array.newInstance(clazz, list.size());
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static Integer[] toIntArray(int[] arr) {
        Integer[] narr = new Integer[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static int[] toIntArray(Integer[] arr) {
        int[] narr = new int[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static double[] toDoubleArray(List<Double> list) {
        double[] arr = new double[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static Double[] toDoubleArray(double[] arr) {
        Double[] narr = new Double[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static double[] toDoubleArray(Double[] arr) {
        double[] narr = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static boolean[] toBoolArray(List<Boolean> list) {
        boolean[] arr = new boolean[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static Boolean[] toBoolArray(boolean[] arr) {
        Boolean[] narr = new Boolean[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static boolean[] toBoolArray(Boolean[] arr) {
        boolean[] narr = new boolean[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static char[] toCharArray(List<Character> list) {
        char[] arr = new char[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i).charValue();
            ++i;
        }
        return arr;
    }

    public static Character[] toCharArray(char[] arr) {
        Character[] narr = new Character[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = Character.valueOf(arr[i]);
            ++i;
        }
        return narr;
    }

    public static char[] toCharArray(Character[] arr) {
        char[] narr = new char[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i].charValue();
            ++i;
        }
        return narr;
    }

    public static byte[] toByteArray(List<Byte> list) {
        byte[] arr = new byte[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static Byte[] toByteArray(byte[] arr) {
        Byte[] narr = new Byte[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static byte[] toByteArray(Byte[] arr) {
        byte[] narr = new byte[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static short[] toShortArray(List<Short> list) {
        short[] arr = new short[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static Short[] toShortArray(short[] arr) {
        Short[] narr = new Short[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static short[] toShortArray(Short[] arr) {
        short[] narr = new short[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static long[] toLongArray(List<Long> list) {
        long[] arr = new long[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public static Long[] toLongArray(long[] arr) {
        Long[] narr = new Long[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static long[] toLongArray(Long[] arr) {
        long[] narr = new long[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i];
            ++i;
        }
        return narr;
    }

    public static float[] toFloatArray(List<Float> list) {
        float[] arr = new float[list.size()];
        int i = 0;
        while (i < list.size()) {
            arr[i] = list.get(i).floatValue();
            ++i;
        }
        return arr;
    }

    public static Float[] toFloatArray(float[] arr) {
        Float[] narr = new Float[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = Float.valueOf(arr[i]);
            ++i;
        }
        return narr;
    }

    public static float[] toFloatArray(Float[] arr) {
        float[] narr = new float[arr.length];
        int i = 0;
        while (i < arr.length) {
            narr[i] = arr[i].floatValue();
            ++i;
        }
        return narr;
    }

    public static <E, L extends List<E>> List<E> asList(Class<L> clazz, E[] arr) {
        try {
            List list = (List)clazz.newInstance();
            list.addAll(Arrays.asList(arr));
            return list;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return Arrays.asList(arr);
    }

    public static <E> List<E> copyList(List<E> src, int from, int to) {
        try {
            List list = (List)src.getClass().newInstance();
            int i = from;
            while (i <= to) {
                list.add(src.get(i));
                ++i;
            }
            return list;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static enum Rounding {
        FLOOR,
        CEILING;

    }
}

