/*
 * Decompiled with CFR 0.152.
 */
package utils.collections;

import java.lang.reflect.Array;

public class RingBuffer<E> {
    private E[] buffer;
    private int pointer;
    private int length;

    public RingBuffer(Class<E> clazz, int size) {
        this.buffer = (Object[])Array.newInstance(clazz, size);
    }

    public E get(int i) {
        if (i < this.length - this.buffer.length || i > this.length - 1) {
            return null;
        }
        return this.buffer[(i + 1) % this.buffer.length];
    }

    public E getLast() {
        return this.buffer[this.pointer];
    }

    public int size() {
        return this.length + 1;
    }

    public boolean set(E obj, int i) {
        if (i < this.length - this.buffer.length || i > this.length - 1) {
            return false;
        }
        this.buffer[(i + 1) % this.buffer.length] = obj;
        return true;
    }

    public void add(E obj) {
        ++this.pointer;
        this.pointer %= this.buffer.length;
        ++this.length;
        this.buffer[this.pointer] = obj;
    }
}

