/*
 * Decompiled with CFR 0.152.
 */
package utils.collections;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import utils.collections.CollectionUtils;

public class SerializedStack<E> {
    private static long LONG_LENGTH = ("-" + Long.toHexString(Long.MAX_VALUE)).getBytes().length;
    private boolean open;
    private FilePointer pointer;
    private RAFileInputStream in;
    private RAFileOutputStream out;
    private Class<E> clazz;

    public SerializedStack(Class<E> clazz, File dir) throws IOException {
        this.pointer = new FilePointer(File.createTempFile("dta", ".stk", dir), File.createTempFile("idx", ".stk", dir));
        this.in = new RAFileInputStream(this.pointer);
        this.out = new RAFileOutputStream(this.pointer);
        this.clazz = clazz;
        this.open = true;
    }

    public SerializedStack(Class<E> clazz) throws IOException {
        File file = File.createTempFile("dta", ".stk");
        File indices = File.createTempFile("idx", ".stk");
        file.deleteOnExit();
        indices.deleteOnExit();
        this.pointer = new FilePointer(file, indices);
        this.in = new RAFileInputStream(this.pointer);
        this.out = new RAFileOutputStream(this.pointer);
        this.clazz = clazz;
        this.open = true;
    }

    private void open() throws FileNotFoundException {
        this.pointer.open();
        this.in = new RAFileInputStream(this.pointer);
        this.out = new RAFileOutputStream(this.pointer);
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.pointer.close();
        this.open = false;
    }

    public boolean isEmpty() throws IOException {
        if (!this.open) {
            this.open();
        }
        return this.pointer.isEmpty();
    }

    public E peek() throws IOException, ClassNotFoundException {
        if (this.isEmpty()) {
            return null;
        }
        Object obj = null;
        this.in.reset();
        if (this.clazz.equals(Integer.TYPE) || this.clazz.equals(Integer.class)) {
            obj = new Integer(Integer.parseInt(this.readPrimitiveString()));
        } else if (this.clazz.equals(Boolean.TYPE) || this.clazz.equals(Boolean.class)) {
            obj = new Boolean(Boolean.parseBoolean(this.readPrimitiveString()));
        } else if (this.clazz.equals(Byte.TYPE) || this.clazz.equals(Byte.class)) {
            obj = new Byte(Byte.parseByte(this.readPrimitiveString()));
        } else if (this.clazz.equals(Character.TYPE) || this.clazz.equals(Character.class)) {
            obj = new Character(this.readPrimitiveString().charAt(0));
        } else if (this.clazz.equals(Long.TYPE) || this.clazz.equals(Long.class)) {
            obj = new Long(Long.parseLong(this.readPrimitiveString()));
        } else if (this.clazz.equals(Short.TYPE) || this.clazz.equals(Short.class)) {
            obj = new Short(Short.parseShort(this.readPrimitiveString()));
        } else if (this.clazz.equals(Float.TYPE) || this.clazz.equals(Float.class)) {
            obj = new Float(Float.parseFloat(this.readPrimitiveString()));
        } else if (this.clazz.equals(Double.TYPE) || this.clazz.equals(Double.class)) {
            obj = new Double(Double.parseDouble(this.readPrimitiveString()));
        } else {
            ObjectInputStream oin = new ObjectInputStream(this.in);
            obj = oin.readObject();
            oin.close();
        }
        return (E)obj;
    }

    private String readPrimitiveString() throws IOException {
        int r;
        ArrayList<Byte> b = new ArrayList<Byte>();
        while ((r = this.in.read()) != -1) {
            b.add((byte)r);
        }
        return new String(CollectionUtils.toByteArray(b));
    }

    public E pop() throws IOException, ClassNotFoundException {
        if (this.isEmpty()) {
            return null;
        }
        E obj = this.peek();
        this.pointer.delete();
        return obj;
    }

    public void push(E item) throws IOException, ClassNotFoundException {
        if (!this.open) {
            this.open();
        }
        if (this.clazz.equals(Integer.TYPE) || this.clazz.equals(Integer.class)) {
            this.writePrimitiveString(Integer.toString((Integer)item));
        } else if (this.clazz.equals(Boolean.TYPE) || this.clazz.equals(Boolean.class)) {
            this.writePrimitiveString(Boolean.toString((Boolean)item));
        } else if (this.clazz.equals(Byte.TYPE) || this.clazz.equals(Byte.class)) {
            this.writePrimitiveString(Byte.toString((Byte)item));
        } else if (this.clazz.equals(Character.TYPE) || this.clazz.equals(Character.class)) {
            this.writePrimitiveString(Character.toString(((Character)item).charValue()));
        } else if (this.clazz.equals(Short.TYPE) || this.clazz.equals(Short.class)) {
            this.writePrimitiveString(Short.toString((Short)item));
        } else if (this.clazz.equals(Long.TYPE) || this.clazz.equals(Long.class)) {
            this.writePrimitiveString(Long.toString((Long)item));
        } else if (this.clazz.equals(Float.TYPE) || this.clazz.equals(Float.class)) {
            this.writePrimitiveString(Float.toString(((Float)item).floatValue()));
        } else if (this.clazz.equals(Double.TYPE) || this.clazz.equals(Double.class)) {
            this.writePrimitiveString(Double.toString((Double)item));
        } else {
            ObjectOutputStream oout = new ObjectOutputStream(this.out);
            oout.writeObject(item);
            this.out.flushBuffer();
            oout.close();
        }
    }

    private void writePrimitiveString(String s) throws IOException {
        this.out.write(s.getBytes());
        this.out.flushBuffer();
    }

    private class FilePointer {
        private RandomAccessFile file;
        private RandomAccessFile indices;
        private File _file;
        private File _indices;
        private long index;

        public FilePointer(File file, File indices) throws FileNotFoundException {
            this.file = new RandomAccessFile(file, "rws");
            this.indices = new RandomAccessFile(indices, "rws");
        }

        public boolean isEmpty() throws IOException {
            return this.file.length() == 0L;
        }

        public void open() throws FileNotFoundException {
            this.file = new RandomAccessFile(this._file, "rws");
            this.indices = new RandomAccessFile(this._indices, "rws");
        }

        public void close() throws IOException {
            this.file.close();
            this.indices.close();
        }

        public Deque<Byte> read() throws IOException {
            ArrayDeque<Byte> deque = new ArrayDeque<Byte>((int)(this.file.length() - this.index));
            this.file.seek(this.index);
            int i = 0;
            while ((long)i < this.file.length() - this.index) {
                byte b = (byte)this.file.read();
                deque.addLast(b);
                ++i;
            }
            return deque;
        }

        public void write(Deque<Byte> buffer) throws IOException {
            this.file.seek(this.file.length());
            this.index = this.file.length();
            for (byte b : buffer) {
                this.file.write(b);
            }
            StringBuffer sbuf = new StringBuffer(this.index < 0L ? "-" : "+");
            String s = Long.toHexString(Math.abs(this.index));
            int i = 0;
            while ((long)i < LONG_LENGTH - (long)s.getBytes().length - 1L) {
                sbuf.append("0");
                ++i;
            }
            sbuf.append(s);
            this.indices.writeBytes(sbuf.toString());
        }

        public void delete() throws IOException {
            this.file.getChannel().truncate(this.index);
            this.indices.getChannel().truncate(this.indices.length() - LONG_LENGTH);
            if (this.indices.length() > LONG_LENGTH) {
                this.indices.seek(this.indices.length() - LONG_LENGTH);
                byte[] buf = new byte[(int)LONG_LENGTH];
                this.indices.read(buf);
                String hex = new String(buf);
                this.index = hex.startsWith("+") ? Long.parseLong(hex.substring(1), 16) : Long.parseLong(hex, 16);
            } else {
                this.index = 0L;
            }
        }
    }

    private class RAFileInputStream
    extends InputStream {
        private FilePointer pointer;
        private Deque<Byte> buffer;

        public RAFileInputStream(FilePointer pointer) {
            this.pointer = pointer;
            this.buffer = new ArrayDeque<Byte>(0);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.buffer = this.pointer.read();
        }

        @Override
        public int read() throws IOException {
            if (this.buffer.isEmpty()) {
                return -1;
            }
            return this.buffer.pollFirst().byteValue();
        }
    }

    private class RAFileOutputStream
    extends OutputStream {
        private FilePointer pointer;
        private Deque<Byte> buffer;

        public RAFileOutputStream(FilePointer pointer) {
            this.pointer = pointer;
            this.buffer = new ArrayDeque<Byte>();
        }

        public void flushBuffer() throws IOException {
            this.pointer.write(this.buffer);
            this.buffer = new ArrayDeque<Byte>();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int i = off;
            while (i < off + len) {
                this.write(b[i]);
                ++i;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            byte[] byArray = b;
            int n = b.length;
            int n2 = 0;
            while (n2 < n) {
                byte by = byArray[n2];
                this.write(by);
                ++n2;
            }
        }

        @Override
        public void write(int arg0) throws IOException {
            this.buffer.addLast((byte)arg0);
        }
    }
}

