/*
 * Decompiled with CFR 0.152.
 */
package utils.gui;

import com.panayotis.gnuplot.JavaPlot;
import com.panayotis.gnuplot.terminal.GNUPlotTerminal;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.swing.JPanel;
import utils.gui.ConfigurableImageTerminal;
import utils.gui.MouseZoomAdapter;
import utils.gui.PlotUtils;

public class JPlotPanel
extends JPanel {
    private static final long serialVersionUID = -6068758567429946454L;
    protected JavaPlot plot;
    protected ConfigurableImageTerminal term;
    protected double scale;
    protected Rectangle2D.Double selectionRect;
    protected Point mouseDown;
    protected Point mouseHere;
    protected boolean mouseB1Down;
    protected double[] xrangemax;
    protected double[] yrangemax;
    protected Deque<double[]> xrange;
    protected Deque<double[]> yrange;
    protected double minX = 135.0;
    protected double maxX = 560.0;
    protected double minY = 14.0;
    protected double maxY = 439.0;

    public JPlotPanel(int fontSize, double[] xrange, double[] yrange, double scale, double minX, double maxX, double minY, double maxY) {
        this(new JavaPlot(), fontSize, xrange, yrange, scale, minX, maxX, minY, maxY);
    }

    public JPlotPanel(JavaPlot plot, int fontSize, double[] xrange, double[] yrange, double scale, double minX, double maxX, double minY, double maxY) {
        this.initComponents();
        this.scale = scale;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.term = new ConfigurableImageTerminal("font \"," + fontSize + "\"");
        this.setJavaPlot(plot);
        this.xrange = new ArrayDeque<double[]>();
        this.yrange = new ArrayDeque<double[]>();
        double[] _xrange = new double[]{Math.nextAfter(xrange[0], Math.floor(xrange[0])), Math.nextAfter(xrange[1], Math.ceil(xrange[1]))};
        double[] _yrange = new double[]{Math.nextAfter(yrange[0], Math.floor(yrange[0])), Math.nextAfter(yrange[1], Math.ceil(yrange[1]))};
        this.xrange.add(_xrange);
        this.yrange.add(_yrange);
        this.xrangemax = _xrange;
        this.yrangemax = _yrange;
        plot.set("xrange", "[" + _xrange[0] + ":" + _xrange[1] + "]");
        plot.set("yrange", "[" + _yrange[0] + ":" + _yrange[1] + "]");
    }

    public void setJavaPlot(JavaPlot javaplot) {
        this.plot = javaplot;
        this.plot.setTerminal((GNUPlotTerminal)this.term);
    }

    public JavaPlot getJavaPlot() {
        return this.plot;
    }

    public void plot() {
        if (this.plot == null) {
            return;
        }
        this.plot.plot();
        BufferedImage img = PlotUtils.getScaledImage(this.term.getImage(), this.scale);
        this.setPreferredSize(new Dimension(img.getWidth(), img.getHeight()));
    }

    @Override
    public void paint(Graphics g) {
        BufferedImage img = PlotUtils.getScaledImage(this.term.getImage(), this.scale);
        if (img == null) {
            return;
        }
        g.drawImage(img, 0, 0, null);
        if (this.mouseB1Down) {
            double downX = Math.max(Math.min(this.mouseDown.getX(), this.maxX), this.minX);
            double downY = Math.max(Math.min(this.mouseDown.getY(), this.maxY), this.minY);
            double hereX = Math.max(Math.min(this.mouseHere.getX(), this.maxX), this.minX);
            double hereY = Math.max(Math.min(this.mouseHere.getY(), this.maxY), this.minY);
            double l = Math.min(downX, hereX);
            double t = Math.min(downY, hereY);
            double w = Math.abs(downX - hereX);
            double h = Math.abs(downY - hereY);
            this.selectionRect = new Rectangle2D.Double(l, t, w, h);
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite ta = AlphaComposite.getInstance(3, 0.1f);
            g2d.setComposite(ta);
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.fill(this.selectionRect);
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.setColor(Color.DARK_GRAY);
            g2d.draw(this.selectionRect);
        }
    }

    protected void initComponents() {
        MouseZoomAdapter zoom = new MouseZoomAdapter(this);
        this.addMouseListener(zoom);
        this.addMouseMotionListener(zoom);
    }

    public void zoomIn() {
        if (this.mouseHere != null && this.mouseDown != null) {
            double downX = Math.max(Math.min(this.mouseDown.getX(), this.maxX), this.minX);
            double downY = Math.max(Math.min(this.mouseDown.getY(), this.maxY), this.minY);
            double hereX = Math.max(Math.min(this.mouseHere.getX(), this.maxX), this.minX);
            double hereY = Math.max(Math.min(this.mouseHere.getY(), this.maxY), this.minY);
            double l = Math.min(downX, hereX);
            double t = Math.min(downY, hereY);
            double w = Math.abs(downX - hereX);
            double h = Math.abs(downY - hereY);
            if (w > 1.0 && h > 1.0) {
                double[] xr = this.xrange.peekLast();
                double[] yr = this.yrange.peekLast();
                double[] x = new double[2];
                double[] y = new double[2];
                x[0] = xr[0] + (l - this.minX) / (this.maxX - this.minX) * (xr[1] - xr[0]);
                x[1] = xr[0] + (l + w - this.minX) / (this.maxX - this.minX) * (xr[1] - xr[0]);
                y[1] = yr[1] - (t - this.minY) / (this.maxY - this.minY) * (yr[1] - yr[0]);
                y[0] = yr[1] - (t + h - this.minY) / (this.maxY - this.minY) * (yr[1] - yr[0]);
                x[0] = Math.nextAfter(x[0], Math.floor(x[0]));
                x[1] = Math.nextAfter(x[1], Math.ceil(x[1]));
                y[0] = Math.nextAfter(y[0], Math.floor(y[0]));
                y[1] = Math.nextAfter(y[1], Math.ceil(y[1]));
                this.xrange.addLast(x);
                this.yrange.addLast(y);
                this.plot.set("xrange", "[" + x[0] + ":" + x[1] + "]");
                this.plot.set("yrange", "[" + y[0] + ":" + y[1] + "]");
                this.plot();
            }
        }
    }

    public void zoomOut() {
        if (this.xrange.size() > 1) {
            this.xrange.removeLast();
            this.yrange.removeLast();
            double[] x = this.xrange.peekLast();
            double[] y = this.yrange.peekLast();
            this.plot.set("xrange", "[" + x[0] + ":" + x[1] + "]");
            this.plot.set("yrange", "[" + y[0] + ":" + y[1] + "]");
            this.plot();
        }
    }
}

