/*
 * Decompiled with CFR 0.152.
 */
package utils.gui;

import com.panayotis.gnuplot.JavaPlot;
import com.panayotis.gnuplot.plot.AbstractPlot;
import com.panayotis.gnuplot.plot.DataSetPlot;
import com.panayotis.gnuplot.plot.Plot;
import com.panayotis.gnuplot.style.NamedPlotColor;
import com.panayotis.gnuplot.style.PlotColor;
import com.panayotis.gnuplot.style.PlotStyle;
import com.panayotis.gnuplot.style.Style;
import com.panayotis.gnuplot.terminal.GNUPlotTerminal;
import com.panayotis.gnuplot.terminal.SVGTerminal;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import utils.collections.CollectionUtils;
import utils.gui.J3DPlotPanel;
import utils.gui.JPlotPanel;
import utils.gui.NiceNamedPlotColor;
import utils.io.IOUtils;
import utils.math.MathUtils;

public class PlotUtils {
    protected static NamedPlotColor[] COLORS = NiceNamedPlotColor.getLightColors();

    public static void exportPlot(File file, JPlotPanel panel, boolean override) throws IOException {
        if (file.exists() && !override) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " exists!");
        }
        JavaPlot plot = panel.getJavaPlot();
        GNUPlotTerminal term = plot.getTerminal();
        plot.setTerminal((GNUPlotTerminal)new SVGTerminal(file.getAbsolutePath()));
        plot.plot();
        plot.setTerminal(term);
    }

    public static JPlotPanel get3DPlot(double[][] data, String xAxis, String yAxis) throws IOException {
        double[] xTicks = new double[data.length];
        double[] yTicks = new double[data[0].length];
        int i = 0;
        while (i < xTicks.length) {
            xTicks[i] = i;
            ++i;
        }
        i = 0;
        while (i < yTicks.length) {
            yTicks[i] = i;
            ++i;
        }
        return PlotUtils.get3DPlot(xTicks, yTicks, data, xAxis, yAxis);
    }

    public static JPlotPanel get3DPlot(double[] xTicks, double[] yTicks, double[][] data, String xAxis, String yAxis) throws IOException {
        File file = File.createTempFile("plot", ".dat");
        file.deleteOnExit();
        double[] xrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] yrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int ylength = Integer.MIN_VALUE;
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            ylength = Math.max(ylength, row.length);
            ++n2;
        }
        BufferedWriter writer = IOUtils.getWriter(file, false);
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                writer.write(String.valueOf(xTicks[i]) + " " + yTicks[j] + " " + data[i][j] + "\n");
                if (Double.isInfinite(data[i][j]) || Double.isNaN(data[i][j])) {
                    writer.close();
                    throw new IllegalArgumentException(Double.toString(data[i][j]));
                }
                xrange[0] = Math.min(xrange[0], xTicks[i]);
                xrange[1] = Math.max(xrange[1], xTicks[i]);
                yrange[0] = Math.min(yrange[0], yTicks[j]);
                yrange[1] = Math.max(yrange[1], yTicks[j]);
                ++j;
            }
            j = data[i].length;
            while (j < ylength) {
                writer.write(String.valueOf(xTicks[i]) + " " + yTicks[j] + " " + 0.0 + "\n");
                ++j;
            }
            writer.write("\n");
            ++i;
        }
        writer.close();
        JavaPlot plot = new JavaPlot(true);
        plot.addPlot("'" + file.getAbsolutePath() + "'");
        ((AbstractPlot)plot.getPlots().get(0)).setTitle("");
        ((AbstractPlot)plot.getPlots().get(0)).setPlotStyle(new PlotStyle(Style.LINES));
        plot.getAxis("x").setLabel(xAxis);
        plot.getAxis("y").setLabel(yAxis);
        plot.set("hidden3d", "");
        plot.set("isosample", String.valueOf(data.length) + "," + data[0].length);
        double minX = 158.0;
        double maxX = 477.0;
        double minY = 78.0;
        double maxY = 397.0;
        J3DPlotPanel pl = new J3DPlotPanel(plot, 8, xrange, yrange, 1.0, minX, maxX, minY, maxY);
        pl.plot();
        return pl;
    }

    public static JPlotPanel get3DMapPlot(double[][] data, String xAxis, String yAxis) throws IOException {
        double[] xTicks = new double[data.length];
        double[] yTicks = new double[data[0].length];
        int i = 0;
        while (i < xTicks.length) {
            xTicks[i] = i;
            ++i;
        }
        i = 0;
        while (i < yTicks.length) {
            yTicks[i] = i;
            ++i;
        }
        return PlotUtils.get3DMapPlot(xTicks, yTicks, data, xAxis, yAxis);
    }

    public static JPlotPanel get3DMapPlot(double[] xTicks, double[] yTicks, double[][] data, String xAxis, String yAxis) throws IOException {
        File file = File.createTempFile("plot", ".dat");
        file.deleteOnExit();
        double[] xrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] yrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int ylength = Integer.MIN_VALUE;
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            ylength = Math.max(ylength, row.length);
            ++n2;
        }
        BufferedWriter writer = IOUtils.getWriter(file, false);
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[i].length) {
                writer.write(String.valueOf(xTicks[i]) + " " + yTicks[j] + " " + data[i][j] + "\n");
                if (Double.isInfinite(data[i][j]) || Double.isNaN(data[i][j])) {
                    writer.close();
                    throw new IllegalArgumentException(Double.toString(data[i][j]));
                }
                xrange[0] = Math.min(xrange[0], xTicks[i]);
                xrange[1] = Math.max(xrange[1], xTicks[i]);
                yrange[0] = Math.min(yrange[0], yTicks[j]);
                yrange[1] = Math.max(yrange[1], yTicks[j]);
                ++j;
            }
            j = data[i].length;
            while (j < ylength) {
                writer.write(String.valueOf(xTicks[i]) + " " + yTicks[j] + " " + 0.0 + "\n");
                ++j;
            }
            writer.write("\n");
            ++i;
        }
        writer.close();
        JavaPlot plot = new JavaPlot(true);
        plot.addPlot("'" + file.getAbsolutePath() + "'");
        ((AbstractPlot)plot.getPlots().get(0)).setTitle("");
        plot.getAxis("x").setLabel(xAxis);
        plot.getAxis("y").setLabel(yAxis);
        plot.set("pm3d", "map");
        plot.set("size", "square");
        plot.set("lmargin", "2");
        plot.set("bmargin", "2");
        plot.set("rmargin", "1");
        plot.set("tmargin", "1");
        double minX = 158.0;
        double maxX = 477.0;
        double minY = 78.0;
        double maxY = 397.0;
        JPlotPanel pl = new JPlotPanel(plot, 8, xrange, yrange, 1.0, minX, maxX, minY, maxY);
        pl.plot();
        return pl;
    }

    public static JPlotPanel getLinePlot(double[][] data, String xAxis, String yAxis) {
        ArrayList<double[][]> list = new ArrayList<double[][]>(1);
        list.add(data);
        return PlotUtils.getLinePlot(list, null, xAxis, yAxis);
    }

    public static JPlotPanel getLinePlot(double[][] data, String title, String xAxis, String yAxis) {
        ArrayList<double[][]> dList = new ArrayList<double[][]>(1);
        dList.add(data);
        ArrayList<String> tList = new ArrayList<String>(1);
        tList.add(title);
        return PlotUtils.getLinePlot(dList, tList, xAxis, yAxis);
    }

    public static JPlotPanel getLinePlot(List<double[][]> data, String xAxis, String yAxis) {
        return PlotUtils.getLinePlot(data, null, xAxis, yAxis);
    }

    public static JPlotPanel getLinePlot(List<double[][]> data, List<String> title, String xAxis, String yAxis) {
        ArrayList<PlotStyle> style = new ArrayList<PlotStyle>(data.size());
        int i = 0;
        while (i < data.size()) {
            PlotStyle pl = new PlotStyle(Style.LINES);
            pl.setLineType((PlotColor)COLORS[i % COLORS.length]);
            style.add(pl);
            ++i;
        }
        return PlotUtils.getPlot(data, title, style, 1.0, xAxis, yAxis);
    }

    public static JPlotPanel getLinePointsPlot(double[][] data, String xAxis, String yAxis) {
        ArrayList<double[][]> list = new ArrayList<double[][]>(1);
        list.add(data);
        return PlotUtils.getLinePointsPlot(list, null, xAxis, yAxis);
    }

    public static JPlotPanel getLinePointsPlot(double[][] data, String title, String xAxis, String yAxis) {
        ArrayList<double[][]> dList = new ArrayList<double[][]>(1);
        dList.add(data);
        ArrayList<String> tList = new ArrayList<String>(1);
        tList.add(title);
        return PlotUtils.getLinePointsPlot(dList, tList, xAxis, yAxis);
    }

    public static JPlotPanel getLinePointsPlot(List<double[][]> data, String xAxis, String yAxis) {
        return PlotUtils.getLinePointsPlot(data, null, xAxis, yAxis);
    }

    public static JPlotPanel getLinePointsPlot(List<double[][]> data, List<String> title, String xAxis, String yAxis) {
        ArrayList<PlotStyle> style = new ArrayList<PlotStyle>(data.size());
        int i = 0;
        while (i < data.size()) {
            PlotStyle pl = new PlotStyle(Style.LINESPOINTS);
            pl.setLineType((PlotColor)COLORS[i % COLORS.length]);
            style.add(pl);
            ++i;
        }
        return PlotUtils.getPlot(data, title, style, 1.0, xAxis, yAxis);
    }

    public static JPlotPanel getPointsPlot(double[][] data, String xAxis, String yAxis) {
        ArrayList<double[][]> list = new ArrayList<double[][]>(1);
        list.add(data);
        return PlotUtils.getPointsPlot(list, null, xAxis, yAxis);
    }

    public static JPlotPanel getPointsPlot(double[][] data, String title, String xAxis, String yAxis) {
        ArrayList<double[][]> dList = new ArrayList<double[][]>(1);
        dList.add(data);
        ArrayList<String> tList = new ArrayList<String>(1);
        tList.add(title);
        return PlotUtils.getPointsPlot(dList, tList, xAxis, yAxis);
    }

    public static JPlotPanel getPointsPlot(List<double[][]> data, String xAxis, String yAxis) {
        return PlotUtils.getPointsPlot(data, null, xAxis, yAxis);
    }

    public static JPlotPanel getPointsPlot(List<double[][]> data, List<String> title, String xAxis, String yAxis) {
        ArrayList<PlotStyle> style = new ArrayList<PlotStyle>(data.size());
        int i = 0;
        while (i < data.size()) {
            PlotStyle pl = new PlotStyle(Style.POINTS);
            pl.setLineType((PlotColor)COLORS[i % COLORS.length]);
            style.add(pl);
            ++i;
        }
        return PlotUtils.getPlot(data, title, style, 1.0, xAxis, yAxis);
    }

    public static JPlotPanel getImpulsePlot(double[][] data, String xAxis, String yAxis) {
        ArrayList<double[][]> list = new ArrayList<double[][]>(1);
        list.add(data);
        return PlotUtils.getImpulsePlot(list, xAxis, yAxis);
    }

    public static JPlotPanel getImpulsePlot(double[][] data, String title, String xAxis, String yAxis) {
        ArrayList<double[][]> dList = new ArrayList<double[][]>(1);
        dList.add(data);
        ArrayList<String> tList = new ArrayList<String>(1);
        tList.add(title);
        return PlotUtils.getImpulsePlot(dList, tList, xAxis, yAxis);
    }

    public static JPlotPanel getImpulsePlot(List<double[][]> data, String xAxis, String yAxis) {
        return PlotUtils.getImpulsePlot(data, null, xAxis, yAxis);
    }

    public static JPlotPanel getImpulsePlot(List<double[][]> data, List<String> title, String xAxis, String yAxis) {
        ArrayList<PlotStyle> style = new ArrayList<PlotStyle>(data.size());
        int i = 0;
        while (i < data.size()) {
            PlotStyle pl = new PlotStyle(Style.IMPULSES);
            pl.setLineType((PlotColor)COLORS[i % COLORS.length]);
            style.add(pl);
            ++i;
        }
        return PlotUtils.getPlot(data, title, style, 1.0, xAxis, yAxis);
    }

    public static JPlotPanel getPlot(List<double[][]> data, List<String> title, List<PlotStyle> style, String xAxis, String yAxis) {
        return PlotUtils.getPlot(data, title, style, 1.0, xAxis, yAxis);
    }

    protected static JPlotPanel getPlot(List<double[][]> data, List<String> title, List<PlotStyle> style, double scale, String xAxis, String yAxis) {
        ArrayList<DataSetPlot> p = new ArrayList<DataSetPlot>(data.size());
        double[] xrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] yrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int i = 0;
        while (i < data.size()) {
            double[][] dArray = data.get(i);
            DataSetPlot _p = new DataSetPlot(dArray);
            _p.setPlotStyle(style.get(i));
            if (title != null && i < title.size()) {
                _p.setTitle(title.get(i));
            } else {
                _p.setTitle("");
            }
            p.add(_p);
            ArrayList<Double> xvals = new ArrayList<Double>();
            ArrayList<Double> yvals = new ArrayList<Double>();
            double[][] dArray2 = dArray;
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double[] _d = dArray2[n2];
                xvals.add(_d[0]);
                yvals.add(_d[1]);
                if (Double.isInfinite(_d[0]) || Double.isNaN(_d[0]) || Double.isInfinite(_d[1]) || Double.isNaN(_d[1])) {
                    throw new IllegalArgumentException(String.valueOf(_d[0]) + " " + _d[1]);
                }
                ++n2;
            }
            xrange[0] = Math.min(xrange[0], (Double)MathUtils.min(xvals));
            yrange[0] = Math.min(yrange[0], (Double)MathUtils.min(yvals));
            xrange[1] = Math.max(xrange[1], (Double)MathUtils.max(xvals));
            yrange[1] = Math.max(yrange[1], (Double)MathUtils.max(yvals));
            ++i;
        }
        JavaPlot plot = new JavaPlot();
        for (AbstractPlot abstractPlot : p) {
            plot.addPlot((Plot)abstractPlot);
        }
        plot.getAxis("x").setLabel(xAxis);
        plot.getAxis("y").setLabel(yAxis);
        plot.set("size", "square");
        plot.set("lmargin", "10");
        plot.set("bmargin", "3");
        plot.set("rmargin", "2");
        plot.set("tmargin", "1");
        double d = 135.0;
        double maxX = 560.0;
        double minY = 14.0;
        double maxY = 439.0;
        JPlotPanel pl = new JPlotPanel(plot, 8, xrange, yrange, scale, d, maxX, minY, maxY);
        pl.plot();
        return pl;
    }

    public static JPlotPanel getBoxWhiskerPlot(List<double[]> data, List<String> title, String xAxis, String yAxis) throws IOException {
        File file = File.createTempFile("plot", ".dat");
        file.deleteOnExit();
        double[] xrange = new double[]{0.0, data.size() + 1};
        double[] yrange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        BufferedWriter writer = IOUtils.getWriter(file, false);
        int i = 0;
        while (i < data.size()) {
            Number[] d = CollectionUtils.toDoubleArray(data.get(i));
            double min = (Double)MathUtils.min((Number[])d);
            double fq = (Double)MathUtils.quartile((Number[])d, (MathUtils.Quartile)MathUtils.Quartile.FIRST);
            double med = (Double)MathUtils.quartile((Number[])d, (MathUtils.Quartile)MathUtils.Quartile.SECOND);
            double tq = (Double)MathUtils.quartile((Number[])d, (MathUtils.Quartile)MathUtils.Quartile.THIRD);
            double max = (Double)MathUtils.max((Number[])d);
            writer.write(String.valueOf(i + 1) + " " + min + " " + fq + " " + med + " " + tq + " " + max + "\n");
            yrange[0] = (Double)MathUtils.min((Number[])new Double[]{yrange[0], min, min - (Double)MathUtils.min((Number[])new Double[]{max - tq, tq - med, med - fq, fq - min})});
            yrange[1] = Math.max(yrange[1], max + (Double)MathUtils.min((Number[])new Double[]{max - tq, tq - med, med - fq, fq - min}));
            ++i;
        }
        writer.close();
        StringBuffer buf = new StringBuffer("(");
        int i2 = 0;
        while (i2 < title.size() - 1) {
            buf.append("\"" + title.get(i2) + "\" " + (i2 + 1) + ", ");
            ++i2;
        }
        buf.append("\"" + title.get(title.size() - 1) + "\" " + title.size() + ")");
        String xtics = buf.toString();
        JavaPlot plot = new JavaPlot();
        PlotStyle style = new PlotStyle(Style.CANDLESTICKS){
            private static final long serialVersionUID = 7008441713383177812L;

            public void appendProperties(StringBuffer buf) {
                buf.append(" using 1:3:2:6:5 with candlesticks lt -1 lw 2 notitle whiskerbars ,       ''                 using 1:4:4:4:4 with candlesticks lt -1 lw 1 notitle");
            }
        };
        plot.addPlot("'" + file.getAbsolutePath() + "'");
        ((AbstractPlot)plot.getPlots().get(0)).setPlotStyle(style);
        ((AbstractPlot)plot.getPlots().get(0)).unset("title");
        plot.getAxis("x").setLabel(xAxis);
        plot.getAxis("y").setLabel(yAxis);
        plot.set("boxwidth", "0.2 absolute");
        plot.set("xtics", xtics);
        plot.set("size", "square");
        plot.set("lmargin", "10");
        plot.set("bmargin", "3");
        plot.set("rmargin", "2");
        plot.set("tmargin", "1");
        double minX = 135.0;
        double maxX = 560.0;
        double minY = 14.0;
        double maxY = 439.0;
        JPlotPanel pl = new JPlotPanel(plot, 8, xrange, yrange, 1.0, minX, maxX, minY, maxY);
        pl.plot();
        return pl;
    }

    protected static BufferedImage getScaledImage(BufferedImage image, double scale) {
        int w = (int)((double)image.getWidth() * scale);
        int h = (int)((double)image.getHeight() * scale);
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        AffineTransform at = AffineTransform.getScaleInstance(scale, scale);
        g2.drawRenderedImage(image, at);
        g2.dispose();
        return bi;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<double[][]> scatter = new ArrayList<double[][]>();
        int i = 0;
        while (i < 2) {
            double[][] data = new double[10][2];
            int j = 0;
            while (j < 10) {
                data[j][0] = Math.random() - 0.5;
                data[j][1] = Math.random() - 0.5;
                ++j;
            }
            scatter.add(data);
            ++i;
        }
        ArrayList<String> title = new ArrayList<String>();
        title.add("foo");
        title.add("bar");
        JFrame f = new JFrame();
        f.getContentPane().add(PlotUtils.getPointsPlot(scatter, title, "x Axis", "y Axis"));
        f.pack();
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

