/*
 * Decompiled with CFR 0.152.
 */
package utils.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class IOUtils {
    public static String FILE_SEPARATOR = System.getProperty("file.separator");
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    private static int TEMP_DIR_ATTEMPTS = 5;
    private static int BUFFER_SIZE = 1024;

    public static File createTempDir() throws IOException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = String.valueOf(System.currentTimeMillis()) + "-";
        int counter = 0;
        while (counter < TEMP_DIR_ATTEMPTS) {
            File tempDir = new File(baseDir, String.valueOf(baseName) + counter);
            if (tempDir.mkdir()) {
                return tempDir;
            }
            ++counter;
        }
        throw new IOException("Failed to create directory within " + TEMP_DIR_ATTEMPTS + " attempts (tried " + baseName + "0 to " + baseName + (TEMP_DIR_ATTEMPTS - 1) + ')');
    }

    public static BufferedReader getReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    public static BufferedReader getReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in));
    }

    public static BufferedWriter getWriter(File file, boolean append) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        return new BufferedWriter(new FileWriter(file, append));
    }

    public static void copy(File from, File to) throws IOException {
        int length;
        if (to.exists()) {
            throw new IOException(to + " already exists.");
        }
        if (!from.exists()) {
            throw new FileNotFoundException(from.getAbsolutePath());
        }
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        byte[] buf = new byte[BUFFER_SIZE];
        while ((length = in.read(buf)) > 0) {
            if (length < BUFFER_SIZE) {
                byte[] b = new byte[length];
                System.arraycopy(buf, 0, b, 0, length);
                out.write(b);
                continue;
            }
            out.write(buf);
        }
        in.close();
        out.close();
    }

    public static boolean delete(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            return file.delete();
        }
        File[] list = file.listFiles();
        boolean deleted = true;
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            deleted = deleted && IOUtils.delete(f);
            ++n2;
        }
        return deleted ? file.delete() : false;
    }

    public static long getFileSize(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            return file.length();
        }
        long size = 0L;
        File[] files = file.listFiles();
        if (files == null) {
            return 0L;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            size += IOUtils.getFileSize(f);
            ++n2;
        }
        return size;
    }
}

