/*
 * Decompiled with CFR 0.152.
 */
package utils.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import utils.collections.CollectionUtils;
import utils.math.NumberComparator;

public class MathUtils {
    public static double GAMMA = 0.5772156649015329;

    public static <N extends Number> N median(List<N> values) {
        ArrayList<N> tmp = new ArrayList<N>(values);
        Collections.sort(tmp, new NumberComparator());
        Double median = 0.0;
        if (values.size() % 2 == 1) {
            median = ((Number)tmp.get((tmp.size() + 1) / 2 - 1)).doubleValue();
        } else {
            Number lower = (Number)tmp.get(tmp.size() / 2 - 1);
            Number upper = (Number)tmp.get(tmp.size() / 2);
            median = (lower.doubleValue() + upper.doubleValue()) / 2.0;
        }
        return (N)median;
    }

    public static <N extends Number> N median(N[] values) {
        List<N> list = CollectionUtils.asList(ArrayList.class, values);
        return MathUtils.median(list);
    }

    public static double median(double[] values) {
        double[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        double median = 0.0;
        if (values.length % 2 == 1) {
            median = tmp[(tmp.length + 1) / 2 - 1];
        } else {
            double lower = tmp[tmp.length / 2 - 1];
            double upper = tmp[tmp.length / 2];
            median = (lower + upper) / 2.0;
        }
        return median;
    }

    public static float median(float[] values) {
        float[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        float median = 0.0f;
        if (values.length % 2 == 1) {
            median = tmp[(tmp.length + 1) / 2 - 1];
        } else {
            float lower = tmp[tmp.length / 2 - 1];
            float upper = tmp[tmp.length / 2];
            median = (lower + upper) / 2.0f;
        }
        return median;
    }

    public static long median(long[] values) {
        long[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        long median = 0L;
        if (values.length % 2 == 1) {
            median = tmp[(tmp.length + 1) / 2 - 1];
        } else {
            long lower = tmp[tmp.length / 2 - 1];
            long upper = tmp[tmp.length / 2];
            median = (lower + upper) / 2L;
        }
        return median;
    }

    public static int median(int[] values) {
        int[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int median = 0;
        if (values.length % 2 == 1) {
            median = tmp[(tmp.length + 1) / 2 - 1];
        } else {
            int lower = tmp[tmp.length / 2 - 1];
            int upper = tmp[tmp.length / 2];
            median = (lower + upper) / 2;
        }
        return median;
    }

    public static short median(short[] values) {
        short[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        short median = 0;
        if (values.length % 2 == 1) {
            median = tmp[(tmp.length + 1) / 2 - 1];
        } else {
            short lower = tmp[tmp.length / 2 - 1];
            short upper = tmp[tmp.length / 2];
            median = (short)((lower + upper) / 2);
        }
        return median;
    }

    public static byte median(byte[] values) {
        byte[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        byte median = 0;
        if (values.length % 2 == 1) {
            median = tmp[(tmp.length + 1) / 2 - 1];
        } else {
            byte lower = tmp[tmp.length / 2 - 1];
            byte upper = tmp[tmp.length / 2];
            median = (byte)((lower + upper) / 2);
        }
        return median;
    }

    public static <N extends Number> N quartile(List<N> values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        ArrayList<N> tmp = new ArrayList<N>(values);
        NumberComparator comp = new NumberComparator();
        Collections.sort(tmp, comp);
        int index = tmp.size() / 2 - 1;
        if (quartile == Quartile.FIRST) {
            return MathUtils.median(CollectionUtils.copyList(tmp, 0, index));
        }
        return MathUtils.median(CollectionUtils.copyList(tmp, index, tmp.size() - 1));
    }

    public static <N extends Number> N quartile(N[] values, Quartile quartile) {
        List<N> list = CollectionUtils.asList(ArrayList.class, values);
        return MathUtils.quartile(list, quartile);
    }

    public static double quartile(double[] values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        double[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int nlength = tmp.length / 2;
        if (quartile == Quartile.FIRST) {
            double[] ntmp = new double[nlength];
            System.arraycopy(tmp, 0, ntmp, 0, nlength);
            return MathUtils.median(ntmp);
        }
        double[] ntmp = new double[tmp.length - nlength];
        System.arraycopy(tmp, nlength - 1, ntmp, 0, tmp.length - nlength);
        return MathUtils.median(ntmp);
    }

    public static float quartile(float[] values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        float[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int nlength = tmp.length / 2;
        if (quartile == Quartile.FIRST) {
            float[] ntmp = new float[nlength];
            System.arraycopy(tmp, 0, ntmp, 0, nlength);
            return MathUtils.median(ntmp);
        }
        float[] ntmp = new float[tmp.length - nlength];
        System.arraycopy(tmp, nlength - 1, ntmp, 0, tmp.length - nlength);
        return MathUtils.median(ntmp);
    }

    public static long quartile(long[] values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        long[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int nlength = tmp.length / 2;
        if (quartile == Quartile.FIRST) {
            long[] ntmp = new long[nlength];
            System.arraycopy(tmp, 0, ntmp, 0, nlength);
            return MathUtils.median(ntmp);
        }
        long[] ntmp = new long[tmp.length - nlength];
        System.arraycopy(tmp, nlength - 1, ntmp, 0, tmp.length - nlength);
        return MathUtils.median(ntmp);
    }

    public static int quartile(int[] values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        int[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int nlength = tmp.length / 2;
        if (quartile == Quartile.FIRST) {
            int[] ntmp = new int[nlength];
            System.arraycopy(tmp, 0, ntmp, 0, nlength);
            return MathUtils.median(ntmp);
        }
        int[] ntmp = new int[tmp.length - nlength];
        System.arraycopy(tmp, nlength - 1, ntmp, 0, tmp.length - nlength);
        return MathUtils.median(ntmp);
    }

    public static short quartile(short[] values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        short[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int nlength = tmp.length / 2;
        if (quartile == Quartile.FIRST) {
            short[] ntmp = new short[nlength];
            System.arraycopy(tmp, 0, ntmp, 0, nlength);
            return MathUtils.median(ntmp);
        }
        short[] ntmp = new short[tmp.length - nlength];
        System.arraycopy(tmp, nlength - 1, ntmp, 0, tmp.length - nlength);
        return MathUtils.median(ntmp);
    }

    public static byte quartile(byte[] values, Quartile quartile) {
        if (quartile == Quartile.SECOND) {
            return MathUtils.median(values);
        }
        byte[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int nlength = tmp.length / 2;
        if (quartile == Quartile.FIRST) {
            byte[] ntmp = new byte[nlength];
            System.arraycopy(tmp, 0, ntmp, 0, nlength);
            return MathUtils.median(ntmp);
        }
        byte[] ntmp = new byte[tmp.length - nlength];
        System.arraycopy(tmp, nlength - 1, ntmp, 0, tmp.length - nlength);
        return MathUtils.median(ntmp);
    }

    public static <N extends Number> N mean(List<N> values) {
        double sum = 0.0;
        for (Number num : values) {
            sum += num.doubleValue();
        }
        Double mean = sum / (double)values.size();
        return (N)mean;
    }

    public static <N extends Number> N mean(N[] values) {
        List<N> list = CollectionUtils.asList(ArrayList.class, values);
        return MathUtils.mean(list);
    }

    public static double mean(double[] values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double num = dArray[n2];
            sum += num;
            ++n2;
        }
        return sum / (double)values.length;
    }

    public static float mean(float[] values) {
        float sum = 0.0f;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float num = fArray[n2];
            sum += num;
            ++n2;
        }
        return sum / (float)values.length;
    }

    public static long mean(long[] values) {
        long sum = 0L;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long num = lArray[n2];
            sum += num;
            ++n2;
        }
        return sum / (long)values.length;
    }

    public static int mean(int[] values) {
        int sum = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            sum += num;
            ++n2;
        }
        return sum / values.length;
    }

    public static short mean(short[] values) {
        int sum = 0;
        short[] sArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            short num = sArray[n2];
            sum = (short)(sum + num);
            ++n2;
        }
        return (short)(sum / values.length);
    }

    public static byte mean(byte[] values) {
        int sum = 0;
        byte[] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte num = byArray[n2];
            sum = (byte)(sum + num);
            ++n2;
        }
        return (byte)(sum / values.length);
    }

    public static <N extends Number> N trimmedMean(List<N> values, double alpha) {
        ArrayList<N> tmp = new ArrayList<N>(values);
        Collections.sort(tmp, new NumberComparator());
        int trim = (int)Math.floor(alpha * (double)tmp.size());
        return MathUtils.mean(CollectionUtils.copyList(tmp, trim, tmp.size() - trim - 1));
    }

    public static <N extends Number> N trimmedMean(N[] values, double alpha) {
        List<N> list = CollectionUtils.asList(ArrayList.class, values);
        return MathUtils.trimmedMean(list, alpha);
    }

    public static double trimmedMean(double[] values, double alpha) {
        double[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int trim = (int)Math.floor(alpha * (double)tmp.length);
        double[] ntmp = Arrays.copyOfRange(tmp, trim, tmp.length - trim);
        return MathUtils.mean(ntmp);
    }

    public static float trimmedMean(float[] values, double alpha) {
        float[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int trim = (int)Math.floor(alpha * (double)tmp.length);
        float[] ntmp = Arrays.copyOfRange(tmp, trim, tmp.length - trim);
        return MathUtils.mean(ntmp);
    }

    public static long trimmedMean(long[] values, double alpha) {
        long[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int trim = (int)Math.floor(alpha * (double)tmp.length);
        long[] ntmp = Arrays.copyOfRange(tmp, trim, tmp.length - trim);
        return MathUtils.mean(ntmp);
    }

    public static int trimmedMean(int[] values, double alpha) {
        int[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int trim = (int)Math.floor(alpha * (double)tmp.length);
        int[] ntmp = Arrays.copyOfRange(tmp, trim, tmp.length - trim);
        return MathUtils.mean(ntmp);
    }

    public static short trimmedMean(short[] values, double alpha) {
        short[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int trim = (int)Math.floor(alpha * (double)tmp.length);
        short[] ntmp = Arrays.copyOfRange(tmp, trim, tmp.length - trim);
        return MathUtils.mean(ntmp);
    }

    public static byte trimmedMean(byte[] values, double alpha) {
        byte[] tmp = Arrays.copyOf(values, values.length);
        Arrays.sort(tmp);
        int trim = (int)Math.floor(alpha * (double)tmp.length);
        byte[] ntmp = Arrays.copyOfRange(tmp, trim, tmp.length - trim);
        return MathUtils.mean(ntmp);
    }

    public static <N extends Number> N max(List<N> values) {
        ArrayList<N> tmp = new ArrayList<N>(values);
        Collections.sort(tmp, new NumberComparator());
        return (N)((Number)tmp.get(tmp.size() - 1));
    }

    public static <N extends Number> N max(N[] values) {
        List<N> list = CollectionUtils.asList(ArrayList.class, values);
        return MathUtils.max(list);
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double num = dArray[n2];
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return max;
    }

    public static float max(float[] values) {
        float max = Float.NEGATIVE_INFINITY;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float num = fArray[n2];
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return max;
    }

    public static long max(long[] values) {
        long max = Long.MIN_VALUE;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long num = lArray[n2];
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return max;
    }

    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return max;
    }

    public static short max(short[] values) {
        short max = Short.MIN_VALUE;
        short[] sArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            short num = sArray[n2];
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return max;
    }

    public static byte max(byte[] values) {
        byte max = -128;
        byte[] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte num = byArray[n2];
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return max;
    }

    public static <N extends Number> N min(List<N> values) {
        ArrayList<N> tmp = new ArrayList<N>(values);
        Collections.sort(tmp, new NumberComparator());
        return (N)((Number)tmp.get(0));
    }

    public static <N extends Number> N min(N[] values) {
        List<N> list = CollectionUtils.asList(ArrayList.class, values);
        return MathUtils.min(list);
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double num = dArray[n2];
            if (num < min) {
                min = num;
            }
            ++n2;
        }
        return min;
    }

    public static float min(float[] values) {
        float min = Float.POSITIVE_INFINITY;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float num = fArray[n2];
            if (num < min) {
                min = num;
            }
            ++n2;
        }
        return min;
    }

    public static long min(long[] values) {
        long min = Long.MAX_VALUE;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long num = lArray[n2];
            if (num < min) {
                min = num;
            }
            ++n2;
        }
        return min;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            if (num < min) {
                min = num;
            }
            ++n2;
        }
        return min;
    }

    public static short min(short[] values) {
        short min = Short.MAX_VALUE;
        short[] sArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            short num = sArray[n2];
            if (num < min) {
                min = num;
            }
            ++n2;
        }
        return min;
    }

    public static byte min(byte[] values) {
        byte min = 127;
        byte[] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte num = byArray[n2];
            if (num < min) {
                min = num;
            }
            ++n2;
        }
        return min;
    }

    public static <N extends Number> N nearest(List<N> haystack, N needle) {
        Number diff2;
        ArrayList<N> tmp = new ArrayList<N>(haystack);
        Collections.sort(tmp, new NumberComparator());
        int min = 0;
        int max = tmp.size() - 1;
        int mid = 0;
        NumberComparator<Number> comparator = new NumberComparator<Number>();
        do {
            if (comparator.compare(needle, (Number)tmp.get(mid = (min + max) / 2)) > 0) {
                min = mid;
                continue;
            }
            max = mid;
        } while (min != max - 1);
        Number diff1 = MathUtils.abs(MathUtils.subtract((Number)tmp.get(max), needle));
        Number nearest = comparator.compare(diff1, diff2 = MathUtils.abs(MathUtils.subtract((Number)tmp.get(min), needle))) < 0 ? (Number)((Number)tmp.get(max)) : (Number)((Number)tmp.get(min));
        return (N)nearest;
    }

    public static <N extends Number> N nearest(N[] haystack, N needle) {
        List<N> list = CollectionUtils.asList(ArrayList.class, haystack);
        return MathUtils.nearest(list, needle);
    }

    public static double nearest(double[] haystack, double needle) {
        double abs = Double.POSITIVE_INFINITY;
        double nearest = Double.POSITIVE_INFINITY;
        double[] dArray = haystack;
        int n = haystack.length;
        int n2 = 0;
        while (n2 < n) {
            double num = dArray[n2];
            double a = Math.abs(needle - num);
            if (a < abs) {
                abs = a;
                num = nearest;
            }
            ++n2;
        }
        return nearest;
    }

    public static float nearest(float[] haystack, float needle) {
        float abs = Float.POSITIVE_INFINITY;
        float nearest = Float.POSITIVE_INFINITY;
        float[] fArray = haystack;
        int n = haystack.length;
        int n2 = 0;
        while (n2 < n) {
            float num = fArray[n2];
            float a = Math.abs(needle - num);
            if (a < abs) {
                abs = a;
                num = nearest;
            }
            ++n2;
        }
        return nearest;
    }

    public static long nearest(long[] haystack, long needle) {
        long abs = Long.MAX_VALUE;
        long nearest = Long.MAX_VALUE;
        long[] lArray = haystack;
        int n = haystack.length;
        int n2 = 0;
        while (n2 < n) {
            long num = lArray[n2];
            long a = Math.abs(needle - num);
            if (a < abs) {
                abs = a;
                num = nearest;
            }
            ++n2;
        }
        return nearest;
    }

    public static int nearest(int[] haystack, int needle) {
        int abs = Integer.MAX_VALUE;
        int nearest = Integer.MAX_VALUE;
        int[] nArray = haystack;
        int n = haystack.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            int a = Math.abs(needle - num);
            if (a < abs) {
                abs = a;
                num = nearest;
            }
            ++n2;
        }
        return nearest;
    }

    public static short nearest(short[] haystack, short needle) {
        short abs = Short.MAX_VALUE;
        short nearest = Short.MAX_VALUE;
        short[] sArray = haystack;
        int n = haystack.length;
        int n2 = 0;
        while (n2 < n) {
            short num = sArray[n2];
            short a = (short)Math.abs(needle - num);
            if (a < abs) {
                abs = a;
                num = nearest;
            }
            ++n2;
        }
        return nearest;
    }

    public static byte nearest(byte[] haystack, byte needle) {
        byte abs = 127;
        byte nearest = 127;
        byte[] byArray = haystack;
        int n = haystack.length;
        int n2 = 0;
        while (n2 < n) {
            byte num = byArray[n2];
            byte a = (byte)Math.abs(needle - num);
            if (a < abs) {
                abs = a;
                num = nearest;
            }
            ++n2;
        }
        return nearest;
    }

    public static <N extends Number> N subtract(N minuend, N subtrahend) {
        Double difference = minuend.doubleValue() - subtrahend.doubleValue();
        return (N)difference;
    }

    public static <N extends Number> N add(N summand1, N summand2) {
        Double sum = summand1.doubleValue() + summand2.doubleValue();
        return (N)sum;
    }

    public static <N extends Number> N multiply(N factor1, N factor2) {
        Double product = factor1.doubleValue() * factor2.doubleValue();
        return (N)product;
    }

    public static <N extends Number> N divide(N dividend, N divisor) {
        Double quotient = dividend.doubleValue() / divisor.doubleValue();
        return (N)quotient;
    }

    public static <N extends Number> N div(N dividend, N divisor) {
        Long quotient = dividend.longValue() / divisor.longValue();
        return (N)quotient;
    }

    public static <N extends Number> N mod(N dividend, N divisor) {
        Long rest = dividend.longValue() % divisor.longValue();
        return (N)rest;
    }

    public static <N extends Number> N abs(N value) {
        Double absolute = Math.abs(value.doubleValue());
        return (N)absolute;
    }

    public static long binomial(int N, int K) {
        long[][] b = new long[N + 1][K + 1];
        int n = 0;
        while (n <= N) {
            b[n][0] = 1L;
            ++n;
        }
        n = 1;
        while (n <= N) {
            int k = 1;
            while (k <= K) {
                b[n][k] = b[n - 1][k - 1] + b[n - 1][k];
                ++k;
            }
            ++n;
        }
        return b[N][K];
    }

    public static long factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        return n == 0 ? 1L : (long)n * MathUtils.factorial(n - 1);
    }

    public static long factorialStirling(int n) {
        double _n = n;
        double result = Math.sqrt(Math.PI * 2 * _n) * Math.pow(_n / Math.E, n);
        return (long)result;
    }

    public static double gamma(double x) {
        double C0 = 1.0;
        double C1 = 0.08333333333333333;
        double C2 = 0.003472222222222222;
        double C3 = -0.0026813271604938273;
        double C4 = -2.2947209362139917E-4;
        double C5 = 7.840392217200666E-4;
        double C6 = 6.972813758365857E-5;
        double C7 = -5.921664373536939E-4;
        double C8 = -5.171790908260592E-5;
        double C9 = 8.394987206720873E-4;
        double offset = 1.0;
        x -= 1.0;
        while (x <= 15.0) {
            offset *= (x += 1.0);
        }
        double z = 1.0 / x;
        return Math.sqrt(Math.PI * 2 * x) * Math.pow(x / Math.E, x) * (((((((((8.394987206720873E-4 * z + -5.171790908260592E-5) * z + -5.921664373536939E-4) * z + 6.972813758365857E-5) * z + 7.840392217200666E-4) * z + -2.2947209362139917E-4) * z + -0.0026813271604938273) * z + 0.003472222222222222) * z + 0.08333333333333333) * z + 1.0) / offset;
    }

    public static double inverseErf(double erf) {
        double INTERCEPT1 = 0.64549336;
        double INTERCEPT2 = 0.99685977;
        double aerf = Math.abs(erf);
        if (aerf > 1.0) {
            return Double.NaN;
        }
        if (erf == 0.0) {
            return 0.0;
        }
        if (erf == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (erf == -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (aerf < 0.64549336) {
            return MathUtils._InverseErfPowerSeries(erf);
        }
        if (aerf < 0.99685977) {
            double powerSeries = MathUtils._InverseErfPowerSeries(erf);
            double poincar\u00e9Series = erf > 0.0 ? MathUtils._InverseErfPoincar\u00e9Expansion(aerf) : -MathUtils._InverseErfPoincar\u00e9Expansion(aerf);
            double poincar\u00e9Contribution = Math.pow((aerf - 0.64549336) * 2.8208216354, 2.0);
            return powerSeries * (1.0 - poincar\u00e9Contribution) + poincar\u00e9Series * poincar\u00e9Contribution;
        }
        if (erf > 0.0) {
            return MathUtils._InverseErfPoincar\u00e9Expansion(aerf);
        }
        return -MathUtils._InverseErfPoincar\u00e9Expansion(aerf);
    }

    private static final double _InverseErfPowerSeries(double erf) {
        return 0.5 * Math.sqrt(Math.PI) * (erf + Math.PI * Math.pow(erf, 3.0) / 12.0 + 7.0 * Math.pow(Math.PI, 2.0) * Math.pow(erf, 5.0) / 480.0 + 127.0 * Math.pow(Math.PI, 3.0) * Math.pow(erf, 7.0) / 40320.0 + 4369.0 * Math.pow(Math.PI, 4.0) * Math.pow(erf, 9.0) / 5806080.0 + 34807.0 * Math.pow(Math.PI, 5.0) * Math.pow(erf, 11.0) / 1.824768E8 + 2.0036983E7 * Math.pow(Math.PI, 6.0) * Math.pow(erf, 13.0) / 3.985293312E11 + 2.280356863E9 * Math.pow(Math.PI, 7.0) * Math.pow(erf, 15.0) / 1.67382319104E14 + 4.9020204823E10 * Math.pow(Math.PI, 8.0) * Math.pow(erf, 17.0) / 1.3007997370368E16);
    }

    private static final double _InverseErfPoincar\u00e9Expansion(double erf) {
        double subValue1 = Math.log(2.0 / (Math.PI * Math.pow(erf - 1.0, 2.0)));
        return Math.sqrt(subValue1 - Math.log(subValue1)) / Math.sqrt(2.0);
    }

    public static enum Quartile {
        FIRST,
        SECOND,
        THIRD;

    }
}

