/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.ChemistryBase.ms.inputValidators;

import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.CompoundQuality;
import de.unijena.bioinf.ChemistryBase.ms.DatasetStatistics;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Dataset;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.SpectrumProperty;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.QualityAnnotator;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleMutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.Spectrums;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePattern;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePatternAnalysis;
import de.unijena.bioinf.sirius.Sirius;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NotMonoisotopicAnnotatorUsingIPA
implements QualityAnnotator {
    private Deviation findMs1PeakDeviation;
    private List<SpectrumProperty> prerequisites = Collections.singletonList(SpectrumProperty.NoMS1Peak);
    private Sirius sirius;
    private double betterThanMonoisotopicThreshold = 0.0;
    private Element F = PeriodicTable.getInstance().getByName("F");
    private Element I = PeriodicTable.getInstance().getByName("I");
    private Element B = PeriodicTable.getInstance().getByName("B");

    public NotMonoisotopicAnnotatorUsingIPA(Deviation findMs1PeakDeviation) {
        this.findMs1PeakDeviation = findMs1PeakDeviation;
    }

    public SpectrumProperty getPropertyToAnnotate() {
        return SpectrumProperty.NotMonoisotopicPeak;
    }

    public List<SpectrumProperty> getPrerequisites() {
        return this.prerequisites;
    }

    public void prepare(DatasetStatistics statistics) {
    }

    public void annotate(Ms2Dataset dataset) {
        if (this.sirius == null) {
            try {
                this.sirius = new Sirius(dataset.getProfile());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.sirius = new Sirius();
            }
        }
        for (Ms2Experiment ms2Experiment : dataset) {
            if (CompoundQuality.hasProperty((Ms2Experiment)ms2Experiment, (SpectrumProperty)SpectrumProperty.NoMS1Peak) || !this.isNotMonoisotopicPeak(ms2Experiment, dataset.getMeasurementProfile())) continue;
            CompoundQuality.setProperty((Ms2Experiment)ms2Experiment, (SpectrumProperty)SpectrumProperty.NotMonoisotopicPeak);
        }
    }

    private boolean isNotMonoisotopicPeak(Ms2Experiment experiment, MeasurementProfile profile) {
        double precursorMass = experiment.getIonMass();
        int mostIntensiveIdx = -1;
        double maxIntensity = -1.0;
        int pos = -1;
        for (Spectrum spectrum : experiment.getMs1Spectra()) {
            double intensity;
            ++pos;
            int idx = Spectrums.mostIntensivePeakWithin((Spectrum)spectrum, (double)precursorMass, (Deviation)this.findMs1PeakDeviation);
            if (idx < 0 || !((intensity = spectrum.getIntensityAt(idx)) > maxIntensity)) continue;
            maxIntensity = intensity;
            mostIntensiveIdx = pos;
        }
        if (mostIntensiveIdx < 0) {
            throw new RuntimeException("no MS1 precursor peak found.");
        }
        return this.isNotMonoisotopicPeak(precursorMass, (Spectrum<Peak>)((Spectrum)experiment.getMs1Spectra().get(mostIntensiveIdx)), profile, experiment.getPrecursorIonType().getCharge());
    }

    private boolean isNotMonoisotopicPeak(double precursorMass, Spectrum<Peak> ms1, MeasurementProfile profile, int charge) {
        SimpleMutableSpectrum massSortedMs1 = new SimpleMutableSpectrum(ms1);
        Spectrums.sortSpectrumByMass((MutableSpectrum)massSortedMs1);
        int idx = Spectrums.mostIntensivePeakWithin((Spectrum)massSortedMs1, (double)precursorMass, (Deviation)this.findMs1PeakDeviation);
        double realPrecursorMass = massSortedMs1.getMzAt(idx);
        double precursorIntensity = massSortedMs1.getIntensityAt(idx);
        if (idx < 0) {
            throw new RuntimeException("could not find precursor peak");
        }
        if (!this.containsAnyAlternativeMonoisotopicPeak(realPrecursorMass, precursorIntensity, idx, (MutableSpectrum<Peak>)massSortedMs1)) {
            return false;
        }
        List<IsotopePattern> patterns = this.computeIsotopePatterns(realPrecursorMass, (MutableSpectrum<Peak>)massSortedMs1, profile, realPrecursorMass, charge);
        double bestMonoScore = Math.max(patterns.size() > 0 ? patterns.get(0).getScore() : 0.0, 0.0);
        double bestScoreWithNotMonoPeak = Double.NEGATIVE_INFINITY;
        int currentIndex = idx;
        while (currentIndex > 0) {
            Peak peak;
            double mass;
            double diff;
            double maxMs1Int = Spectrums.getMaximalIntensity((Spectrum)massSortedMs1);
            if ((diff = precursorMass - (mass = (peak = massSortedMs1.getPeakAt(--currentIndex)).getMass())) > 2.5) break;
            if (this.skipPeak(peak, precursorMass, precursorIntensity)) continue;
            List<IsotopePattern> isotopePatterns = this.computeIsotopePatterns(mass, (MutableSpectrum<Peak>)massSortedMs1, profile, realPrecursorMass, charge);
            for (IsotopePattern isotopePattern : isotopePatterns) {
                if (!this.containsMass(realPrecursorMass, isotopePattern)) continue;
                if (isotopePattern.getScore() > bestMonoScore + this.betterThanMonoisotopicThreshold) {
                    // empty if block
                }
                bestScoreWithNotMonoPeak = Math.max(isotopePattern.getScore(), bestScoreWithNotMonoPeak);
            }
        }
        return bestScoreWithNotMonoPeak > bestMonoScore + this.betterThanMonoisotopicThreshold;
    }

    private boolean containsAnyAlternativeMonoisotopicPeak(double precursorMass, double precursorInt, int idx, MutableSpectrum<Peak> spectrum) {
        Peak peak;
        double diff;
        int currentIndex = idx;
        while (currentIndex > 0 && !((diff = precursorMass - (peak = spectrum.getPeakAt(--currentIndex)).getMass()) > 2.5)) {
            if (this.skipPeak(peak, precursorMass, precursorInt)) continue;
            return true;
        }
        return false;
    }

    private boolean skipPeak(Peak peak, double precursorMass, double precursorInt) {
        double mass = peak.getMass();
        double intensity = peak.getIntensity();
        if (intensity / precursorInt < 0.33) {
            return true;
        }
        double diff = precursorMass - mass;
        return Math.abs(diff - (double)Math.round(diff)) > 0.01;
    }

    private List<IsotopePattern> computeIsotopePatterns(double mass, MutableSpectrum<Peak> spectrum, MeasurementProfile profile, double precursorMass, int charge) {
        int absCharge = Math.abs(charge);
        boolean mergeMasses = false;
        SimpleMutableSpectrum isotopeSpec = Spectrums.extractIsotopePattern(spectrum, (MeasurementProfile)profile, (double)mass, (int)absCharge, (boolean)mergeMasses);
        if (!this.containsMass(precursorMass, (Spectrum<Peak>)(isotopeSpec = this.trimToPossiblePattern(isotopeSpec)))) {
            return new ArrayList<IsotopePattern>();
        }
        MutableMs2Experiment mutableIsoExperiment = new MutableMs2Experiment();
        mutableIsoExperiment.setPrecursorIonType(PrecursorIonType.unknown((int)charge));
        mutableIsoExperiment.setIonMass(mass);
        mutableIsoExperiment.setMergedMs1Spectrum(new SimpleSpectrum((Spectrum)isotopeSpec));
        FormulaConstraints constraints = this.sirius.predictElementsFromMs1((Ms2Experiment)mutableIsoExperiment);
        this.setUpperBounds(constraints);
        IsotopePatternAnalysis isotopePatternAnalysis = this.sirius.getMs1Analyzer();
        MutableMeasurementProfile mutableMeasurementProfile = new MutableMeasurementProfile(profile);
        mutableMeasurementProfile.setFormulaConstraints(constraints);
        List isotopePatterns = isotopePatternAnalysis.deisotope((Ms2Experiment)mutableIsoExperiment, (MeasurementProfile)mutableMeasurementProfile);
        return isotopePatterns;
    }

    private SimpleMutableSpectrum trimToPossiblePattern(SimpleMutableSpectrum isotopeSpec) {
        Peak peak;
        double currentRatio;
        double monoInt = isotopeSpec.getIntensityAt(0);
        SimpleMutableSpectrum s = new SimpleMutableSpectrum();
        double lastIntRatio = 1.0;
        Iterator iterator = isotopeSpec.iterator();
        while (!(!iterator.hasNext() || (currentRatio = (peak = (Peak)iterator.next()).getIntensity() / monoInt) > 0.5 && lastIntRatio < 0.1)) {
            s.addPeak(peak);
            lastIntRatio = currentRatio;
        }
        return s;
    }

    private void setUpperBounds(FormulaConstraints constraints) {
        if (constraints.getUpperbound(this.F) > 2) {
            constraints.setUpperbound(this.F, 2);
        }
        if (constraints.getUpperbound(this.I) > 2) {
            constraints.setUpperbound(this.I, 2);
        }
        if (constraints.getUpperbound(this.B) > 0) {
            constraints.setUpperbound(this.B, 0);
        }
    }

    private boolean containsMass(double mass, IsotopePattern pattern) {
        return this.containsMass(mass, (Spectrum<Peak>)pattern.getPattern());
    }

    private boolean containsMass(double mass, Spectrum<Peak> spectrum) {
        for (Peak peak : spectrum) {
            if (peak.getMass() != mass) continue;
            return true;
        }
        return false;
    }
}

