/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.IsolationWindow;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.SimpleIsolationWindow;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.Spectrums;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePattern;
import de.unijena.bioinf.sirius.Sirius;
import java.util.List;

public class BetterSimpleIsolationWindow
extends SimpleIsolationWindow {
    private Sirius sirius = new Sirius();
    private PrecursorIonType[] precursorIonTypes;

    public BetterSimpleIsolationWindow(double maxWindowSize, PrecursorIonType[] precursorIonTypes) {
        super(maxWindowSize);
        this.precursorIonTypes = precursorIonTypes;
    }

    public BetterSimpleIsolationWindow(double maxWindowSize, double massShift, boolean estimateSize, PrecursorIonType[] precursorIonTypes, Deviation findMs1PeakDeviation) {
        super(maxWindowSize, massShift, estimateSize, findMs1PeakDeviation);
        this.precursorIonTypes = precursorIonTypes;
    }

    public IsolationWindow.ChargedSpectrum extractPatternMs1(Spectrum<Peak> ms1Spec, MeasurementProfile profile, double targetMz) {
        IsolationWindow.ChargedSpectrum bestSpec = null;
        for (int charge : charges) {
            final IsolationWindow.ChargedSpectrum current = this.extractPattern(ms1Spec, profile, targetMz, charge);
            double longestLength = 0.0;
            for (final PrecursorIonType ionType : this.precursorIonTypes) {
                List<MolecularFormula> formulas = this.sirius.decompose(current.getMzAt(0), ionType.getIonization(), profile.getFormulaConstraints(), profile.getAllowedMassDeviation());
                SimpleSpectrum spectrum = current.getAbsCharge() == 1 ? new SimpleSpectrum((Spectrum)current) : Spectrums.map((Spectrum)current, (Spectrums.Transformation)new Spectrums.Transformation<Peak, Peak>(){

                    public Peak transform(Peak input) {
                        double newMass = ionType.getIonization().addToMass((double)current.getAbsCharge() * ionType.getIonization().subtractFromMass(input.getMass()));
                        return new Peak(newMass, input.getIntensity());
                    }
                });
                List patterns = this.sirius.getMs1Analyzer().scoreFormulas(spectrum, formulas, null, profile, ionType);
                for (IsotopePattern pattern : patterns) {
                    longestLength = Math.max(longestLength, (double)pattern.getPattern().size());
                }
            }
            if ((double)current.size() > longestLength) {
                int i = current.size() - 1;
                while ((double)i >= longestLength) {
                    current.removePeakAt(i);
                    --i;
                }
            }
            if (bestSpec == null) {
                bestSpec = current;
                continue;
            }
            if (current.size() <= bestSpec.size()) continue;
            bestSpec = current;
        }
        return bestSpec;
    }
}

