/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.ft.TreeScoring;
import de.unijena.bioinf.sirius.IdentificationResult;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CSVOutputWriter {
    public static void writeHits(Writer w, List<IdentificationResult> results) throws IOException {
        w.write("formula\tadduct\trank\tscore\ttreeScore\tisoScore\texplainedPeaks\texplainedIntensity\n");
        for (IdentificationResult r : results) {
            PrecursorIonType ion = (PrecursorIonType)r.getStandardTree().getAnnotationOrNull(PrecursorIonType.class);
            w.write(r.getMolecularFormula().toString());
            w.write(9);
            w.write(ion != null ? ion.toString() : "?");
            w.write(9);
            w.write(String.valueOf(r.getRank()));
            w.write(9);
            w.write(String.valueOf(r.getScore()));
            w.write(9);
            w.write(String.valueOf(r.getTreeScore()));
            w.write(9);
            w.write(String.valueOf(r.getIsotopeScore()));
            w.write(9);
            TreeScoring scoring = r.getRawTree() == null ? null : (TreeScoring)r.getRawTree().getAnnotationOrNull(TreeScoring.class);
            w.write(r.getRawTree() == null ? "" : String.valueOf(r.getRawTree().numberOfVertices()));
            w.write(9);
            w.write(scoring == null ? "" : String.valueOf(scoring.getExplainedIntensity()));
            w.write(10);
        }
    }
}

