/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.IonTreeUtils;
import de.unijena.bioinf.ChemistryBase.ms.ft.RecalibrationFunction;
import de.unijena.bioinf.ChemistryBase.ms.ft.TreeScoring;
import de.unijena.bioinf.ChemistryBase.ms.ft.UnconsideredCandidatesUpperBound;
import de.unijena.bioinf.babelms.dot.FTDotWriter;
import de.unijena.bioinf.babelms.json.FTJsonWriter;
import de.unijena.bioinf.babelms.ms.AnnotatedSpectrumWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.regex.Pattern;

public class IdentificationResult
implements Cloneable,
Comparable<IdentificationResult> {
    protected FTree tree;
    protected FTree beautifulTree;
    protected FTree resolvedBeautifulTree;
    protected MolecularFormula formula;
    protected int rank;
    protected double score;
    protected HashMap<Class<?>, Object> annotations;
    private static final Pattern NeedToEscape = Pattern.compile("[\t\n\"]");

    public static void writeIdentifications(Writer writer, Ms2Experiment input, Iterable<IdentificationResult> results) throws IOException {
        StringBuilder buffer = new StringBuilder();
        String name = input.getName();
        if (name.indexOf(34) >= 0) {
            name = "\"" + name.replaceAll("\"", "\"\"") + "\"";
        } else if (name.indexOf(9) >= 0 || name.indexOf(10) >= 0) {
            name = "\"" + name + "\"";
        }
        buffer.append(name);
        buffer.append('\t');
        buffer.append(input.getIonMass());
        buffer.append('\t');
        buffer.append(input.getPrecursorIonType().toString());
        for (IdentificationResult r : results) {
            buffer.append('\t');
            buffer.append(r.getMolecularFormula().toString());
            buffer.append('\t');
            buffer.append(r.getScore());
        }
        buffer.append('\n');
        writer.write(buffer.toString());
    }

    public IdentificationResult(IdentificationResult ir) {
        this.annotations = new HashMap();
        this.annotations.putAll(ir.annotations);
        this.rank = ir.rank;
        this.tree = ir.tree;
        this.beautifulTree = ir.beautifulTree;
        this.formula = ir.formula;
        this.resolvedBeautifulTree = ir.resolvedBeautifulTree;
        this.score = ir.score;
    }

    public PrecursorIonType getPrecursorIonType() {
        return (PrecursorIonType)this.getResolvedTree().getAnnotationOrThrow(PrecursorIonType.class);
    }

    public static IdentificationResult withPrecursorIonType(IdentificationResult ir, PrecursorIonType ionType) {
        IdentificationResult r = new IdentificationResult(ir);
        r.resolvedBeautifulTree = new IonTreeUtils().treeToNeutralTree(ir.getBeautifulTree(), ionType);
        r.formula = ionType.measuredNeutralMoleculeToNeutralMolecule(ir.formula);
        return r;
    }

    public IdentificationResult(FTree tree, int rank) {
        this(tree, rank, false);
    }

    protected IdentificationResult(FTree tree, int rank, boolean isBeautiful) {
        this.tree = tree;
        this.score = tree == null ? 0.0 : ((TreeScoring)tree.getAnnotationOrThrow(TreeScoring.class)).getOverallScore();
        this.rank = rank;
        this.annotations = new HashMap();
        if (tree != null) {
            tree.normalizeStructure();
            this.formula = tree.getRoot().getFormula();
            IonTreeUtils.Type type = (IonTreeUtils.Type)tree.getAnnotationOrNull(IonTreeUtils.Type.class);
            this.formula = type == IonTreeUtils.Type.RESOLVED ? tree.getRoot().getFormula() : (type == IonTreeUtils.Type.IONIZED ? ((PrecursorIonType)tree.getAnnotationOrThrow(PrecursorIonType.class)).precursorIonToNeutralMolecule(tree.getRoot().getFormula()) : ((PrecursorIonType)tree.getAnnotationOrThrow(PrecursorIonType.class)).measuredNeutralMoleculeToNeutralMolecule(tree.getRoot().getFormula()));
        }
        if (isBeautiful) {
            this.beautifulTree = tree;
        }
    }

    @Deprecated
    public IdentificationResult transform(PrecursorIonType ionType) {
        FTree tree = new FTree(this.getRawTree());
        PrecursorIonType currentIonType = (PrecursorIonType)tree.getAnnotationOrThrow(PrecursorIonType.class);
        if (!currentIonType.hasNeitherAdductNorInsource() || ionType.getCharge() != currentIonType.getCharge()) {
            if (currentIonType.equals(ionType)) {
                return this;
            }
            throw new RuntimeException("Tree is not compatible with precursor ion type " + ionType.toString() + ": " + tree.getRoot().getFormula() + " with " + currentIonType.toString());
        }
        if (!currentIonType.getIonization().equals((Object)ionType.getIonization())) {
            boolean invalidIonization;
            if (ionType.isIntrinsicalCharged()) {
                PeriodicTable T = PeriodicTable.getInstance();
                invalidIonization = !(ionType.getCharge() > 0 && currentIonType.getIonization().equals((Object)T.getProtonation()) || ionType.getCharge() < 0 && currentIonType.getIonization().equals((Object)T.getDeprotonation()));
            } else {
                invalidIonization = true;
            }
            if (invalidIonization) {
                throw new RuntimeException("Tree is not compatible with precursor ion type " + ionType.getIonization().toString() + ": " + tree.getRoot().getFormula() + " with " + currentIonType.getIonization().toString());
            }
        }
        tree.setAnnotation(PrecursorIonType.class, (Object)ionType);
        return new IdentificationResult(new IonTreeUtils().treeToNeutralTree(tree), this.rank, true);
    }

    public int getRank() {
        return this.rank;
    }

    public MolecularFormula getMolecularFormula() {
        return this.formula;
    }

    public RecalibrationFunction getRecalibrationFunction() {
        RecalibrationFunction f = (RecalibrationFunction)this.getRawTree().getAnnotations().get(RecalibrationFunction.class);
        if (f == null) {
            return RecalibrationFunction.identity();
        }
        return f;
    }

    public double getScore() {
        return this.score;
    }

    public boolean isBeautiful() {
        return this.beautifulTree != null;
    }

    public FTree getRawTree() {
        if (this.isBeautiful()) {
            return this.beautifulTree;
        }
        return this.tree;
    }

    public FTree getResolvedTree() {
        if (this.resolvedBeautifulTree == null) {
            this.resolvedBeautifulTree = new IonTreeUtils().treeToNeutralTree(new FTree(this.getRawTree()));
        }
        return this.resolvedBeautifulTree;
    }

    public FTree getStandardTree() {
        return this.tree;
    }

    public FTree getBeautifulTree() {
        return this.beautifulTree;
    }

    public void setBeautifulTree(FTree beautifulTree) {
        this.resolvedBeautifulTree = null;
        this.beautifulTree = beautifulTree;
        TreeScoring beautifulScoring = (TreeScoring)this.beautifulTree.getAnnotationOrThrow(TreeScoring.class);
        TreeScoring treeScoring = (TreeScoring)this.tree.getAnnotationOrThrow(TreeScoring.class);
        beautifulScoring.setBeautificationPenalty(beautifulScoring.getOverallScore() - treeScoring.getOverallScore());
        beautifulScoring.setOverallScore(treeScoring.getOverallScore());
        this.copyAnnotations(this.tree, beautifulTree);
    }

    private void copyAnnotations(FTree tree, FTree beautifulTree) {
        UnconsideredCandidatesUpperBound upperBound = (UnconsideredCandidatesUpperBound)tree.getAnnotationOrNull(UnconsideredCandidatesUpperBound.class);
        if (upperBound == null) {
            return;
        }
        beautifulTree.removeAnnotation(UnconsideredCandidatesUpperBound.class);
        beautifulTree.addAnnotation(UnconsideredCandidatesUpperBound.class, (Object)upperBound);
    }

    public double getTreeScore() {
        TreeScoring treeScore = (TreeScoring)this.tree.getAnnotationOrThrow(TreeScoring.class);
        return treeScore.getOverallScore() - treeScore.getIsotopeMs1Score();
    }

    public void writeTreeToFile(File target) throws IOException {
        String name = target.getName();
        if (name.endsWith(".dot")) {
            new FTDotWriter().writeTreeToFile(target, this.getRawTree());
        } else {
            new FTJsonWriter().writeTreeToFile(target, this.getRawTree());
        }
    }

    public String getNeutralizedJSONTree() {
        StringWriter sw = new StringWriter(1024);
        try {
            new FTJsonWriter().writeTree((Writer)sw, this.getResolvedTree());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public String getRawJSONTree() {
        StringWriter sw = new StringWriter(1024);
        try {
            new FTJsonWriter().writeTree((Writer)sw, this.getRawTree());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void writeAnnotatedSpectrumToFile(File target) throws IOException {
        new AnnotatedSpectrumWriter().writeFile(target, this.getRawTree());
    }

    public double getIsotopeScore() {
        TreeScoring treeScore = (TreeScoring)this.tree.getAnnotationOrThrow(TreeScoring.class);
        return treeScore.getIsotopeMs1Score();
    }

    public IdentificationResult clone() {
        IdentificationResult r = new IdentificationResult(new FTree(this.tree), this.rank);
        if (this.beautifulTree != null) {
            r.beautifulTree = new FTree(this.beautifulTree);
        }
        r.score = this.score;
        return r;
    }

    public <T> T getAnnotationOrThrow(Class<T> klass) {
        Object ano = this.annotations.get(klass);
        if (ano == null) {
            throw new NullPointerException("No annotation '" + klass.getName() + "' in ProcessedInput");
        }
        return (T)ano;
    }

    public <T> T getAnnotationOrNull(Class<T> klass) {
        return (T)this.annotations.get(klass);
    }

    public boolean removeAnnotation(Class<?> klass) {
        return this.annotations.remove(klass) != null;
    }

    public <T> boolean setAnnotation(Class<T> klass, T annotation) {
        return this.annotations.put(klass, annotation) == annotation;
    }

    public String toString() {
        return this.formula + " with score " + this.getScore() + " at rank " + this.rank;
    }

    @Override
    public int compareTo(IdentificationResult o) {
        if (this.rank == o.rank) {
            return Double.compare(o.score, this.score);
        }
        return Integer.compare(this.rank, o.rank);
    }
}

