/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import com.google.common.collect.Range;
import de.unijena.bioinf.ChemistryBase.chem.ChemicalAlphabet;
import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.Ionization;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.CompoundQuality;
import de.unijena.bioinf.ChemistryBase.ms.DatasetStatistics;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.IsolationWindow;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Dataset;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Dataset;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.SimpleIsolationWindow;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.SpectrumProperty;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.ChimericAnnotator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.EmptySpectraValidator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.FewPeaksAnnotator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.InvalidException;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.LowIntensityAnnotator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.MissingMergedSpectrumValidator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.Ms2ExperimentValidator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.NoMs1PeakAnnotator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.NotMonoisotopicAnnotatorUsingIPA;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.QualityAnnotator;
import de.unijena.bioinf.ChemistryBase.ms.inputValidators.Warning;
import de.unijena.bioinf.ChemistryBase.ms.utils.PeaklistSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleMutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.Spectrums;
import de.unijena.bioinf.IsotopePatternAnalysis.prediction.DNNRegressionPredictor;
import de.unijena.bioinf.IsotopePatternAnalysis.prediction.ElementPredictor;
import de.unijena.bioinf.MassDecomposer.Chemistry.MassToFormulaDecomposer;
import de.unijena.bioinf.sirius.Sirius;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ms2DatasetPreprocessor {
    private static final boolean DEBUG = false;
    protected static final Logger LOG = LoggerFactory.getLogger(Ms2DatasetPreprocessor.class);
    private static String[] STANDARD_IONIZATIONS_POSITIVE = new String[]{"[M]+", "[M+H]+", "[M+Na]+", "[M+K]+"};
    private static String[] STANDARD_IONIZATIONS_NEGATIVE = new String[]{"[M]-", "[M-H]-", "[M+Cl]-"};
    private static Deviation findMs1PeakDeviation = new Deviation(100.0, 0.1);
    private int MIN_NUMBER_OF_PEAKS = 5;
    private Sirius sirius;
    private PrecursorIonType[] precursorIonTypes;
    private DatasetStatistics datasetStatistics;
    List<Ms2ExperimentValidator> ms2ExperimentValidators;
    private Warning validatorWarning;
    private boolean repairInput;
    private static final String SEP = "\t";

    public Ms2DatasetPreprocessor() {
        this(true);
    }

    public Ms2DatasetPreprocessor(boolean repairInput) {
        this.repairInput = repairInput;
        this.setInitials();
    }

    private void setInitials() {
        this.ms2ExperimentValidators = new ArrayList<Ms2ExperimentValidator>();
        this.ms2ExperimentValidators.add((Ms2ExperimentValidator)new EmptySpectraValidator());
        this.ms2ExperimentValidators.add((Ms2ExperimentValidator)new MissingMergedSpectrumValidator());
        this.validatorWarning = new WarningLog();
    }

    public List<Ms2Experiment> preprocess(List<Ms2Experiment> experiments) {
        MutableMs2Dataset dataset = new MutableMs2Dataset(experiments, "default", Double.NaN, (MeasurementProfile)new Sirius().getMs2Analyzer().getDefaultProfile());
        Ms2DatasetPreprocessor preprocessor = new Ms2DatasetPreprocessor(true);
        dataset = preprocessor.preprocess((Ms2Dataset)dataset);
        return dataset.getExperiments();
    }

    public Ms2Dataset preprocess(Ms2Dataset ms2Dataset) {
        ms2Dataset = this.validate(ms2Dataset);
        ms2Dataset = this.flagBadQualitySpectra(ms2Dataset);
        this.estimateIsolationWindow((MutableMs2Dataset)ms2Dataset);
        double max2ndMostIntenseRatio = 0.33;
        double maxSummedIntensitiesRatio = 1.0;
        ChimericAnnotator chimericAnnotator = new ChimericAnnotator(findMs1PeakDeviation, max2ndMostIntenseRatio, maxSummedIntensitiesRatio);
        chimericAnnotator.prepare(ms2Dataset.getDatasetStatistics());
        chimericAnnotator.annotate(ms2Dataset);
        for (Ms2Experiment experiment : ms2Dataset.getExperiments()) {
            experiment.setAnnotation(IsolationWindow.class, (Object)ms2Dataset.getIsolationWindow());
            CompoundQuality quality = (CompoundQuality)experiment.getAnnotation(CompoundQuality.class);
            if (quality == null) {
                experiment.setAnnotation(CompoundQuality.class, (Object)new CompoundQuality(SpectrumProperty.Good));
                continue;
            }
            if (!quality.isNotBadQuality() || quality.isGoodQuality()) continue;
            quality.addProperty(SpectrumProperty.Good);
        }
        return ms2Dataset;
    }

    public MutableMs2Dataset validate(Ms2Dataset ms2Dataset) {
        MutableMs2Dataset mutableMs2Dataset = new MutableMs2Dataset(ms2Dataset);
        ArrayList<Ms2Experiment> validatedExperiments = new ArrayList<Ms2Experiment>();
        Iterator iterator = ms2Dataset.getExperiments().iterator();
        while (iterator.hasNext()) {
            Ms2Experiment experiment;
            Ms2Experiment validatedExperiment = experiment = (Ms2Experiment)iterator.next();
            for (Ms2ExperimentValidator ms2ExperimentValidator : this.ms2ExperimentValidators) {
                try {
                    validatedExperiment = ms2ExperimentValidator.validate(validatedExperiment, this.validatorWarning, this.repairInput);
                }
                catch (InvalidException exception) {
                    LOG.warn("validation error: remove compound " + experiment.getName());
                    validatedExperiment = null;
                    break;
                }
            }
            if (validatedExperiment == null) continue;
            validatedExperiments.add(validatedExperiment);
        }
        mutableMs2Dataset.setExperiments(validatedExperiments);
        return mutableMs2Dataset;
    }

    private void init(Ms2Dataset ms2Dataset) {
        int chargeSign;
        try {
            this.sirius = new Sirius(ms2Dataset.getProfile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            chargeSign = this.testCharge(ms2Dataset);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("currently do not support preprocessing datasets with positive and negative charges.");
        }
        String[] STANDARD_IONIZATIONS = chargeSign < 0 ? STANDARD_IONIZATIONS_NEGATIVE : STANDARD_IONIZATIONS_POSITIVE;
        this.precursorIonTypes = new PrecursorIonType[STANDARD_IONIZATIONS.length];
        for (int i = 0; i < STANDARD_IONIZATIONS.length; ++i) {
            this.precursorIonTypes[i] = PrecursorIonType.getPrecursorIonType((String)STANDARD_IONIZATIONS[i]);
        }
        MeasurementProfile measurementProfile = ms2Dataset.getMeasurementProfile();
        this.sirius.getMs2Analyzer().setDefaultProfile(measurementProfile);
        DNNRegressionPredictor defaultPredictor = new DNNRegressionPredictor();
        this.sirius.setElementPrediction((ElementPredictor)defaultPredictor);
    }

    private int testCharge(Ms2Dataset ms2Dataset) throws IllegalArgumentException {
        int charge = 0;
        for (Ms2Experiment experiment : ms2Dataset) {
            PrecursorIonType precursorIonType = experiment.getPrecursorIonType();
            int currentCharge = precursorIonType.getCharge();
            if (charge == 0) {
                charge = (int)Math.signum(currentCharge);
                continue;
            }
            if (charge * currentCharge >= 0) continue;
            throw new IllegalArgumentException("charge differs between experiments");
        }
        return charge;
    }

    public MutableMs2Dataset flagBadQualitySpectra(Ms2Dataset ms2Dataset) {
        MutableMs2Dataset mutableMs2Dataset = new MutableMs2Dataset(ms2Dataset);
        this.init(ms2Dataset);
        this.datasetStatistics = this.makeStatistics((Ms2Dataset)mutableMs2Dataset);
        mutableMs2Dataset.setDatasetStatistics(this.datasetStatistics);
        NoMs1PeakAnnotator noMs1PeakAnnotator = new NoMs1PeakAnnotator(findMs1PeakDeviation);
        FewPeaksAnnotator fewPeaksAnnotator = new FewPeaksAnnotator((double)this.MIN_NUMBER_OF_PEAKS);
        LowIntensityAnnotator lowIntensityAnnotator = new LowIntensityAnnotator(findMs1PeakDeviation, 0.01, 0.0);
        NotMonoisotopicAnnotatorUsingIPA notMonoisotopicAnnotator = new NotMonoisotopicAnnotatorUsingIPA(findMs1PeakDeviation);
        ArrayList<Object> qualityAnnotators = new ArrayList<Object>();
        qualityAnnotators.add(noMs1PeakAnnotator);
        qualityAnnotators.add(fewPeaksAnnotator);
        qualityAnnotators.add(lowIntensityAnnotator);
        qualityAnnotators.add(notMonoisotopicAnnotator);
        for (QualityAnnotator qualityAnnotator : qualityAnnotators) {
            qualityAnnotator.prepare(this.datasetStatistics);
            qualityAnnotator.annotate((Ms2Dataset)mutableMs2Dataset);
        }
        return mutableMs2Dataset;
    }

    private DatasetStatistics makeStatistics(Ms2Dataset ms2Dataset) {
        for (Ms2Experiment experiment : ms2Dataset.getExperiments()) {
            FormulaConstraints constraints = this.predictElements(experiment, ms2Dataset);
            experiment.setAnnotation(FormulaConstraints.class, (Object)constraints);
        }
        DatasetStatistics datasetStatistics = new DatasetStatistics();
        List<ExperimentWithAnnotatedSpectra> experiments = this.extractSpectra(ms2Dataset);
        for (ExperimentWithAnnotatedSpectra experiment : experiments) {
            for (Spectrum<PeakWithAnnotation> spectrum : experiment.getMs1spectra()) {
                datasetStatistics.addMaxMs1Intensity(Spectrums.getMaximalIntensity(spectrum));
                datasetStatistics.addMinMs1Intensity(Spectrums.getMinimalIntensity(spectrum));
            }
            for (Spectrum<PeakWithAnnotation> spectrum : experiment.getMs2spectra()) {
                datasetStatistics.addMaxMs2Intensity(Spectrums.getMaximalIntensity(spectrum));
                datasetStatistics.addMinMs2Intensity(Spectrums.getMinimalIntensity(spectrum));
            }
        }
        for (ExperimentWithAnnotatedSpectra experiment : experiments) {
            this.annotateNoise(experiment);
            for (Spectrum<PeakWithAnnotation> spectrum : experiment.getMs2spectra()) {
                for (PeakWithAnnotation peakWithAnnotation : spectrum) {
                    if (!peakWithAnnotation.isNoise()) continue;
                    datasetStatistics.addMs2NoiseIntensity(peakWithAnnotation.getIntensity());
                }
            }
        }
        return datasetStatistics;
    }

    private boolean isNotMonoisotopicPeak(Ms2Experiment experiment, MeasurementProfile profile) {
        double precursorMass = experiment.getIonMass();
        SimpleMutableSpectrum merged = new SimpleMutableSpectrum(this.getMergedMs2(experiment, profile.getAllowedMassDeviation()));
        int idx = Spectrums.mostIntensivePeakWithin((Spectrum)merged, (double)precursorMass, (Deviation)profile.getAllowedMassDeviation());
        if (idx < 0) {
            merged.addPeak(precursorMass, experiment.getIonMass());
        }
        Spectrums.filterIsotpePeaks((MutableSpectrum)merged, (Deviation)profile.getAllowedMassDeviation());
        return Spectrums.search((Spectrum)merged, (double)precursorMass, (Deviation)profile.getAllowedMassDeviation()) < 0;
    }

    private Spectrum<Peak> getMergedMs2(Ms2Experiment experiment, Deviation deviation) {
        if (experiment.getMs2Spectra().size() == 1) {
            return (Spectrum)experiment.getMs2Spectra().get(0);
        }
        return Spectrums.mergeSpectra((Deviation)deviation, (boolean)true, (boolean)true, (List)experiment.getMs2Spectra());
    }

    public void writeExperimentInfos(Ms2Dataset ms2Dataset, Path outputFile) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(outputFile, Charset.defaultCharset(), new OpenOption[0]);
        SpectrumProperty[] allProperties = SpectrumProperty.values();
        writer.write("name\tmass");
        for (SpectrumProperty property : allProperties) {
            writer.write(SEP + property.toString());
        }
        for (Ms2Experiment experiment : ms2Dataset.getExperiments()) {
            writer.write("\n" + experiment.getName() + SEP + experiment.getIonMass());
            for (SpectrumProperty property : allProperties) {
                if (this.hasProperty(experiment, property)) {
                    writer.write("\t1");
                    continue;
                }
                writer.write("\t0");
            }
        }
        writer.close();
    }

    private void setSpectrumProperty(Ms2Experiment experiment, SpectrumProperty property) {
        CompoundQuality quality = (CompoundQuality)experiment.getAnnotation(CompoundQuality.class);
        if (quality == null) {
            quality = new CompoundQuality(property);
            experiment.setAnnotation(CompoundQuality.class, (Object)quality);
        } else {
            quality.addProperty(property);
        }
    }

    private boolean hasProperty(Ms2Experiment experiment, SpectrumProperty property) {
        CompoundQuality quality = (CompoundQuality)experiment.getAnnotation(CompoundQuality.class);
        if (quality == null) {
            return false;
        }
        return quality.hasProperty(property);
    }

    private boolean isNotBadQuality(Ms2Experiment experiment) {
        return ((CompoundQuality)experiment.getAnnotation(CompoundQuality.class, (Object)new CompoundQuality(SpectrumProperty.Good))).isGoodQuality();
    }

    private FormulaConstraints predictElements(Ms2Experiment experiment, Ms2Dataset ms2Dataset) {
        FormulaConstraints constraints = this.sirius.predictElementsFromMs1(experiment);
        FormulaConstraints globalConstraints = ms2Dataset.getMeasurementProfile().getFormulaConstraints();
        if (constraints == null) {
            return globalConstraints;
        }
        ElementPredictor elementPredictor = this.sirius.getElementPrediction();
        for (Element element : globalConstraints.getChemicalAlphabet()) {
            if (elementPredictor.isPredictable(element) || globalConstraints.getUpperbound(element) <= constraints.getUpperbound(element)) continue;
            constraints.setUpperbound(element, globalConstraints.getUpperbound(element));
        }
        return constraints;
    }

    private void annotateNoise(ExperimentWithAnnotatedSpectra experiment) {
        for (Spectrum<PeakWithAnnotation> spectrum : experiment.getMs1spectra()) {
            this.annotateNoise(spectrum, (Ms2Experiment)experiment.getExperiment());
        }
        for (Spectrum<PeakWithAnnotation> spectrum : experiment.getMs2spectra()) {
            this.annotateNoise(spectrum, (Ms2Experiment)experiment.getExperiment());
        }
    }

    private void annotateNoise(Spectrum<PeakWithAnnotation> spectrum, Ms2Experiment experiment) {
        for (PeakWithAnnotation peakWithAnnotation : spectrum) {
            peakWithAnnotation.setNoise(true);
        }
        FormulaConstraints constraints = experiment.hasAnnotation(FormulaConstraints.class) ? (FormulaConstraints)experiment.getAnnotation(FormulaConstraints.class) : new FormulaConstraints(ChemicalAlphabet.getExtendedAlphabet());
        Deviation deviation = this.sirius.getMs2Analyzer().getDefaultProfile().getAllowedMassDeviation().multiply(4);
        MassToFormulaDecomposer decomposer = this.sirius.getMs2Analyzer().getDecomposerFor(constraints.getChemicalAlphabet());
        Ionization[] ionizations = new Ionization[this.precursorIonTypes.length];
        for (int i = 0; i < this.precursorIonTypes.length; ++i) {
            ionizations[i] = this.precursorIonTypes[i].getIonization();
        }
        int idx = 0;
        for (PeakWithAnnotation peakWithAnnotation : spectrum) {
            double mass;
            if (peakWithAnnotation.getMass() <= experiment.getIonMass() + 5.0) {
                double mass2;
                if (!experiment.getPrecursorIonType().isIonizationUnknown() && !this.contains(ionizations, experiment.getPrecursorIonType().getIonization()) && this.isDecomposable(mass2 = experiment.getPrecursorIonType().getIonization().subtractFromMass(peakWithAnnotation.getMass()), decomposer, deviation, constraints)) {
                    this.annotateNonNoisePattern(spectrum, idx, (MeasurementProfile)this.sirius.getMs2Analyzer().getDefaultProfile(), constraints.getChemicalAlphabet());
                }
                for (Ionization ionization : ionizations) {
                    mass = ionization.subtractFromMass(peakWithAnnotation.getMass());
                    if (!this.isDecomposable(mass, decomposer, deviation, constraints)) continue;
                    this.annotateNonNoisePattern(spectrum, idx, (MeasurementProfile)this.sirius.getMs2Analyzer().getDefaultProfile(), constraints.getChemicalAlphabet());
                }
            } else {
                for (Ionization ionization : ionizations) {
                    mass = ionization.subtractFromMass(peakWithAnnotation.getMass());
                    if (!this.isDecomposable(mass, decomposer, deviation, constraints)) continue;
                    this.annotateNonNoisePattern(spectrum, idx, (MeasurementProfile)this.sirius.getMs2Analyzer().getDefaultProfile(), constraints.getChemicalAlphabet());
                }
            }
            ++idx;
        }
    }

    private boolean isDecomposable(double mass, MassToFormulaDecomposer decomposer, Deviation deviation, FormulaConstraints constraints) {
        double abs = deviation.absoluteFor(mass);
        return decomposer.maybeDecomposable(mass - abs, mass + abs);
    }

    private void annotateNonNoisePattern(Spectrum<PeakWithAnnotation> spectrum, int monoIdx, MeasurementProfile profile, ChemicalAlphabet alphabet) {
        Deviation massDifferenceDeviation = profile.getStandardMassDifferenceDeviation().multiply(2.0);
        ((PeakWithAnnotation)spectrum.getPeakAt(monoIdx)).setNoise(false);
        double monoMz = spectrum.getMzAt(monoIdx);
        for (int k = 1; k <= 5; ++k) {
            double mz;
            double endPoint;
            Range nextMz = PeriodicTable.getInstance().getIsotopicMassWindow(alphabet, profile.getAllowedMassDeviation(), monoMz, k);
            double a = (Double)nextMz.lowerEndpoint();
            double b = (Double)nextMz.upperEndpoint();
            double startPoint = a - massDifferenceDeviation.absoluteFor(a);
            int nextIndex = Spectrums.indexOfFirstPeakWithin(spectrum, (double)startPoint, (double)(endPoint = b + massDifferenceDeviation.absoluteFor(b)));
            if (nextIndex < 0) break;
            for (int i = nextIndex; i < spectrum.size() && !((mz = spectrum.getMzAt(i)) > endPoint); ++i) {
                ((PeakWithAnnotation)spectrum.getPeakAt(i)).setNoise(false);
            }
        }
    }

    public void estimateIsolationWindow(MutableMs2Dataset ms2Dataset) {
        if (ms2Dataset.getIsolationWindow() == null) {
            double width = ms2Dataset.getIsolationWindowWidth();
            if (Double.isNaN(width) || width <= 0.0) {
                width = 10.0;
                ms2Dataset.setIsolationWindow((IsolationWindow)new SimpleIsolationWindow(width, 0.0, true, findMs1PeakDeviation));
                ms2Dataset.getIsolationWindow().estimate((Ms2Dataset)ms2Dataset);
                width = ms2Dataset.getIsolationWindow().getEstimatedWindowSize();
                ms2Dataset.setIsolationWindowWidth(width);
            } else {
                ms2Dataset.setIsolationWindow((IsolationWindow)new SimpleIsolationWindow(width, 0.0, false, findMs1PeakDeviation));
                ms2Dataset.getIsolationWindow().estimate((Ms2Dataset)ms2Dataset);
            }
        }
    }

    private List<ExperimentWithAnnotatedSpectra> extractSpectra(Ms2Dataset ms2Dataset) {
        ArrayList<ExperimentWithAnnotatedSpectra> experimentsWithAnnotatedSpectra = new ArrayList<ExperimentWithAnnotatedSpectra>();
        List experiments = ms2Dataset.getExperiments();
        for (Ms2Experiment experiment : experiments) {
            List<Spectrum<PeakWithAnnotation>> ms1 = this.convert(experiment.getMs1Spectra());
            List<Spectrum<PeakWithAnnotation>> ms2 = this.convert(experiment.getMs2Spectra());
            experimentsWithAnnotatedSpectra.add(new ExperimentWithAnnotatedSpectra(new MutableMs2Experiment(experiment), ms1, ms2));
        }
        return experimentsWithAnnotatedSpectra;
    }

    private List<Spectrum<PeakWithAnnotation>> extractAllMs1(Ms2Dataset ms2Dataset) {
        ArrayList<Spectrum<PeakWithAnnotation>> ms1Spectra = new ArrayList<Spectrum<PeakWithAnnotation>>();
        List experiments = ms2Dataset.getExperiments();
        for (Ms2Experiment experiment : experiments) {
            for (Spectrum spectrum : experiment.getMs1Spectra()) {
                ms1Spectra.add(this.convert((Spectrum<Peak>)spectrum));
            }
        }
        return ms1Spectra;
    }

    private List<Spectrum<PeakWithAnnotation>> extractAllMs2(Ms2Dataset ms2Dataset) {
        ArrayList<Spectrum<PeakWithAnnotation>> ms2Spectra = new ArrayList<Spectrum<PeakWithAnnotation>>();
        List experiments = ms2Dataset.getExperiments();
        for (Ms2Experiment experiment : experiments) {
            for (Spectrum spectrum : experiment.getMs2Spectra()) {
                ms2Spectra.add(this.convert((Spectrum<Peak>)spectrum));
            }
        }
        return ms2Spectra;
    }

    private List<Spectrum<PeakWithAnnotation>> convert(List<? extends Spectrum<Peak>> spectra) {
        ArrayList<Spectrum<PeakWithAnnotation>> list = new ArrayList<Spectrum<PeakWithAnnotation>>();
        for (Spectrum<Peak> spectrum : spectra) {
            list.add(this.convert(spectrum));
        }
        return list;
    }

    private Spectrum<PeakWithAnnotation> convert(Spectrum<Peak> spectrum) {
        ArrayList<PeakWithAnnotation> pList = new ArrayList<PeakWithAnnotation>(spectrum.size());
        for (Peak peak : spectrum) {
            pList.add(new PeakWithAnnotation(peak));
        }
        Collections.sort(pList);
        return new PeaklistSpectrum(pList);
    }

    private <T> boolean contains(T[] array, T object) {
        for (T o : array) {
            if (!o.equals(object)) continue;
            return true;
        }
        return false;
    }

    private class WarningLog
    implements Warning {
        private WarningLog() {
        }

        public void warn(String message) {
            LOG.warn(message);
        }
    }

    private class PeakWithAnnotation
    extends Peak
    implements Comparable<Peak> {
        private boolean isNoise;

        public PeakWithAnnotation(Peak x) {
            super(x);
        }

        public PeakWithAnnotation(double mass, double intensity) {
            super(mass, intensity);
        }

        public boolean isNoise() {
            return this.isNoise;
        }

        public void setNoise(boolean noise) {
            this.isNoise = noise;
        }
    }

    private class ExperimentWithAnnotatedSpectra {
        private MutableMs2Experiment experiment;
        private List<Spectrum<PeakWithAnnotation>> ms1spectra;
        private List<Spectrum<PeakWithAnnotation>> ms2spectra;

        public ExperimentWithAnnotatedSpectra(MutableMs2Experiment experiment, List<Spectrum<PeakWithAnnotation>> ms1spectra, List<Spectrum<PeakWithAnnotation>> ms2spectra) {
            this.experiment = experiment;
            this.ms1spectra = ms1spectra;
            this.ms2spectra = ms2spectra;
        }

        public MutableMs2Experiment getExperiment() {
            return this.experiment;
        }

        public List<Spectrum<PeakWithAnnotation>> getMs1spectra() {
            return this.ms1spectra;
        }

        public List<Spectrum<PeakWithAnnotation>> getMs2spectra() {
            return this.ms2spectra;
        }
    }
}

