/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import com.google.gson.JsonObject;
import de.unijena.bioinf.ChemistryBase.data.DataDocument;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.FragmentationPatternAnalysis;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePatternAnalysis;
import de.unijena.bioinf.babelms.json.JSONDocumentType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class Profile {
    public final FragmentationPatternAnalysis fragmentationPatternAnalysis;
    public final IsotopePatternAnalysis isotopePatternAnalysis;

    public Profile(String name) throws IOException {
        JsonObject json;
        JSONDocumentType document;
        boolean oldSirius = name.startsWith("oldSirius");
        if (oldSirius) {
            name = name.split(":")[1];
        }
        this.fragmentationPatternAnalysis = (document = new JSONDocumentType()).hasKeyInDictionary((Object)(json = JSONDocumentType.getJSON((String)("/profiles/" + name.toLowerCase() + ".json"), (String)name)), "FragmentationPatternAnalysis") ? FragmentationPatternAnalysis.loadFromProfile((DataDocument)document, (Object)json) : null;
        this.isotopePatternAnalysis = document.hasKeyInDictionary((Object)json, "IsotopePatternAnalysis") ? IsotopePatternAnalysis.loadFromProfile((DataDocument)document, (Object)json) : null;
    }

    public Profile(IsotopePatternAnalysis ms1, FragmentationPatternAnalysis ms2) {
        this.fragmentationPatternAnalysis = ms2;
        this.isotopePatternAnalysis = ms1;
    }

    public void writeToFile(String fileName) throws IOException {
        this.writeToFile(new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File name) throws IOException {
        FileWriter writer = new FileWriter(name);
        JSONDocumentType json = new JSONDocumentType();
        JsonObject obj = json.newDictionary();
        if (this.fragmentationPatternAnalysis != null) {
            this.fragmentationPatternAnalysis.writeToProfile((DataDocument)json, (Object)obj);
        }
        if (this.isotopePatternAnalysis != null) {
            this.isotopePatternAnalysis.writeToProfile((DataDocument)json, (Object)obj);
        }
        try {
            JSONDocumentType.writeJson((DataDocument)json, (Object)obj, (Writer)writer);
        }
        finally {
            writer.close();
        }
    }
}

