/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import com.google.common.collect.Iterables;
import de.unijena.bioinf.ChemistryBase.chem.Charge;
import de.unijena.bioinf.ChemistryBase.chem.ChemicalAlphabet;
import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.Ionization;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.chem.utils.biotransformation.BioTransformation;
import de.unijena.bioinf.ChemistryBase.chem.utils.biotransformation.BioTransformer;
import de.unijena.bioinf.ChemistryBase.chem.utils.scoring.SupportVectorMolecularFormulaScorer;
import de.unijena.bioinf.ChemistryBase.jobs.SiriusJobs;
import de.unijena.bioinf.ChemistryBase.ms.CollisionEnergy;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.MutableMs2Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.MutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.Peak;
import de.unijena.bioinf.ChemistryBase.ms.PossibleAdducts;
import de.unijena.bioinf.ChemistryBase.ms.PossibleIonModes;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.ft.Beautified;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.ChemistryBase.ms.ft.IonTreeUtils;
import de.unijena.bioinf.ChemistryBase.ms.ft.TreeScoring;
import de.unijena.bioinf.ChemistryBase.ms.ft.UnconsideredCandidatesUpperBound;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleMutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.Spectrums;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.AbstractTreeComputationInstance;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.FasterTreeComputationInstance;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.FragmentationPatternAnalysis;
import de.unijena.bioinf.FragmentationTreeConstruction.computation.TreeComputationInstance;
import de.unijena.bioinf.FragmentationTreeConstruction.model.Decomposition;
import de.unijena.bioinf.FragmentationTreeConstruction.model.DecompositionList;
import de.unijena.bioinf.FragmentationTreeConstruction.model.ExtractedIsotopePattern;
import de.unijena.bioinf.FragmentationTreeConstruction.model.ForbidRecalibration;
import de.unijena.bioinf.FragmentationTreeConstruction.model.FormulaSettings;
import de.unijena.bioinf.FragmentationTreeConstruction.model.IsotopeScoring;
import de.unijena.bioinf.FragmentationTreeConstruction.model.ProcessedInput;
import de.unijena.bioinf.FragmentationTreeConstruction.model.Timeout;
import de.unijena.bioinf.FragmentationTreeConstruction.model.Whiteset;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePattern;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePatternAnalysis;
import de.unijena.bioinf.IsotopePatternAnalysis.generation.IsotopePatternGenerator;
import de.unijena.bioinf.IsotopePatternAnalysis.prediction.DNNRegressionPredictor;
import de.unijena.bioinf.IsotopePatternAnalysis.prediction.ElementPredictor;
import de.unijena.bioinf.babelms.CloseableIterator;
import de.unijena.bioinf.babelms.MsExperimentParser;
import de.unijena.bioinf.jjobs.BasicJJob;
import de.unijena.bioinf.jjobs.BasicMasterJJob;
import de.unijena.bioinf.jjobs.JJob;
import de.unijena.bioinf.jjobs.MasterJJob;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.IsotopePatternHandling;
import de.unijena.bioinf.sirius.Profile;
import de.unijena.bioinf.sirius.Progress;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class Sirius {
    private static final double MAX_TREESIZE_INCREASE = 3.0;
    private static final double TREE_SIZE_INCREASE = 1.0;
    private static final int MIN_NUMBER_OF_EXPLAINED_PEAKS = 15;
    private static final double MIN_EXPLAINED_INTENSITY = 0.7;
    private static final int MIN_NUMBER_OF_TREES_CHECK_FOR_INTENSITY = 5;
    private static final double MINIMAL_SCORE_FOR_APPLY_FILTER = 10.0;
    private static final double ISOTOPE_SCORE_FILTER_THRESHOLD = 2.5;
    protected Profile profile;
    protected ElementPredictor elementPrediction;
    protected Progress progress;
    protected PeriodicTable table;
    protected boolean autoIonMode;
    public static boolean USE_FAST_MODE = true;
    private static Comparator<FTree> TREE_SCORE_COMPARATOR = new Comparator<FTree>(){

        @Override
        public int compare(FTree o1, FTree o2) {
            return Double.compare(((TreeScoring)o1.getAnnotationOrThrow(TreeScoring.class)).getOverallScore(), ((TreeScoring)o2.getAnnotationOrThrow(TreeScoring.class)).getOverallScore());
        }
    };

    public static void main(String[] args) {
        Sirius sirius = new Sirius();
        try {
            Ms2Experiment experiment = (Ms2Experiment)sirius.parseExperiment(new File("/home/kaidu/data/ms/demo-data/ms/bicculine_ms1only.ms")).next();
            System.out.println(sirius.identify(experiment).getRawJSONTree());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Sirius(String profileName) throws IOException {
        this.profile = new Profile(profileName);
        this.loadMeasurementProfile();
        this.progress = new Progress.Quiet();
    }

    public Sirius() {
        try {
            this.profile = new Profile("default");
            this.loadMeasurementProfile();
            this.progress = new Progress.Quiet();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SiriusIdentificationJob makeIdentificationJob(Ms2Experiment experiment, int numberOfResultsToReport) {
        return this.makeIdentificationJob(experiment, numberOfResultsToReport, true);
    }

    public SiriusIdentificationJob makeIdentificationJob(Ms2Experiment experiment, int numberOfResultsToReport, boolean beautifyTrees) {
        return new SiriusIdentificationJob(experiment, numberOfResultsToReport, beautifyTrees);
    }

    @Deprecated
    public void setFormulaConstraints(String newConstraints) {
        this.setFormulaConstraints(new FormulaConstraints(newConstraints));
    }

    @Deprecated
    public void setFormulaConstraints(FormulaConstraints constraints) {
        PeriodicTable tb = PeriodicTable.getInstance();
        Element[] chnop = new Element[]{tb.getByName("C"), tb.getByName("H"), tb.getByName("N"), tb.getByName("O"), tb.getByName("P")};
        FormulaConstraints fc = constraints.getExtendedConstraints(chnop);
        this.getMs1Analyzer().getDefaultProfile().setFormulaConstraints(fc);
        this.getMs2Analyzer().getDefaultProfile().setFormulaConstraints(fc);
    }

    public CloseableIterator<Ms2Experiment> parseExperiment(File file) throws IOException {
        return new MsExperimentParser().getParser(file).parseFromFileIterator(file);
    }

    @Deprecated
    public Progress getProgress() {
        return this.progress;
    }

    @Deprecated
    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public FragmentationPatternAnalysis getMs2Analyzer() {
        return this.profile.fragmentationPatternAnalysis;
    }

    public IsotopePatternAnalysis getMs1Analyzer() {
        return this.profile.isotopePatternAnalysis;
    }

    private void loadMeasurementProfile() {
        this.table = PeriodicTable.getInstance();
        this.profile.fragmentationPatternAnalysis.setDefaultProfile((MeasurementProfile)new MutableMeasurementProfile((MeasurementProfile)this.profile.fragmentationPatternAnalysis.getDefaultProfile()));
        this.profile.isotopePatternAnalysis.setDefaultProfile(new MutableMeasurementProfile((MeasurementProfile)this.profile.isotopePatternAnalysis.getDefaultProfile()));
        this.elementPrediction = null;
        this.autoIonMode = false;
    }

    public ElementPredictor getElementPrediction() {
        if (this.elementPrediction == null) {
            DNNRegressionPredictor defaultPredictor = new DNNRegressionPredictor();
            defaultPredictor.disableSilicon();
            this.elementPrediction = defaultPredictor;
        }
        return this.elementPrediction;
    }

    public void setElementPrediction(ElementPredictor elementPrediction) {
        this.elementPrediction = elementPrediction;
    }

    @Deprecated
    public boolean isAutoIonMode() {
        return this.autoIonMode;
    }

    @Deprecated
    public void setAutoIonMode(boolean autoIonMode) {
        this.autoIonMode = autoIonMode;
    }

    protected AbstractTreeComputationInstance getTreeComputationImplementation(FragmentationPatternAnalysis analyzer, Ms2Experiment input, int numberOfResultsToKeep) {
        if (USE_FAST_MODE) {
            return new FasterTreeComputationInstance(analyzer, input, numberOfResultsToKeep);
        }
        return new TreeComputationInstance(analyzer, input, numberOfResultsToKeep);
    }

    public PrecursorIonType[] guessIonization(Ms2Experiment experiment, PrecursorIonType[] candidateIonizations) {
        Spectrum spec = experiment.getMergedMs1Spectrum();
        MutableMs2Spectrum mutableMerged = null;
        if (spec != null) {
            mutableMerged = new MutableMs2Spectrum(spec);
            Spectrums.filterIsotpePeaks((MutableSpectrum)mutableMerged, (Deviation)new Deviation(100.0), (double)0.3, (double)0.75, (int)5, (ChemicalAlphabet)new ChemicalAlphabet());
        }
        if ((mutableMerged == null || mutableMerged.size() == 1) && experiment.getMs1Spectra().size() > 0 && (spec = Spectrums.selectSpectrumWithMostIntensePrecursor((List)experiment.getMs1Spectra(), (double)experiment.getIonMass(), (Deviation)this.getMs1Analyzer().getDefaultProfile().getAllowedMassDeviation())) == null) {
            spec = (Spectrum)experiment.getMs1Spectra().get(0);
        }
        if (spec == null) {
            return candidateIonizations;
        }
        SimpleMutableSpectrum mutableSpectrum = new SimpleMutableSpectrum(spec);
        Spectrums.normalizeToMax((MutableSpectrum)mutableSpectrum, (double)100.0);
        Spectrums.applyBaseline((MutableSpectrum)mutableSpectrum, (double)1.0);
        PrecursorIonType[] ionType = Spectrums.guessIonization((Spectrum)mutableSpectrum, (double)experiment.getIonMass(), (Deviation)this.profile.fragmentationPatternAnalysis.getDefaultProfile().getAllowedMassDeviation(), (PrecursorIonType[])candidateIonizations);
        return ionType;
    }

    @Deprecated
    public void detectPossibleAdductsFromMs1(ProcessedInput processedInput) {
        PrecursorIonType[] adductTypes = processedInput.getExperimentInformation().getPrecursorIonType().isIonizationUnknown() ? this.guessIonization((Ms2Experiment)processedInput.getExperimentInformation(), (PrecursorIonType[])Iterables.toArray((Iterable)PeriodicTable.getInstance().getKnownLikelyPrecursorIonizations(processedInput.getExperimentInformation().getPrecursorIonType().getCharge()), PrecursorIonType.class)) : this.guessIonization((Ms2Experiment)processedInput.getExperimentInformation(), PeriodicTable.getInstance().adductsByIonisation(processedInput.getExperimentInformation().getPrecursorIonType()).toArray(new PrecursorIonType[0]));
        this.setAllowedAdducts(processedInput, adductTypes);
        HashSet<Ionization> ionModes = new HashSet<Ionization>();
        for (PrecursorIonType ionType : adductTypes) {
            ionModes.add(ionType.getIonization());
        }
        this.setAllowedIonModes(processedInput, ionModes.toArray(new Ionization[ionModes.size()]));
    }

    public void detectPossibleIonModesFromMs1(ProcessedInput processedInput) {
        ArrayList<PrecursorIonType> ionTypes = new ArrayList<PrecursorIonType>();
        for (Ionization ionMode : PeriodicTable.getInstance().getKnownIonModes(processedInput.getExperimentInformation().getPrecursorIonType().getCharge())) {
            ionTypes.add(PrecursorIonType.getPrecursorIonType((Ionization)ionMode));
        }
        this.detectPossibleIonModesFromMs1(processedInput, ionTypes.toArray(new PrecursorIonType[ionTypes.size()]));
    }

    public void detectPossibleIonModesFromMs1(ProcessedInput processedInput, PrecursorIonType ... allowedIonModes) {
        PrecursorIonType[] ionModes = this.guessIonization((Ms2Experiment)processedInput.getExperimentInformation(), allowedIonModes);
        PossibleIonModes pim = (PossibleIonModes)processedInput.getAnnotation(PossibleIonModes.class, (Object)new PossibleIonModes());
        if (ionModes.length > 0) {
            pim.updateGuessedIons(ionModes);
        }
        processedInput.setAnnotation(PossibleIonModes.class, (Object)pim);
        PossibleAdducts pa = (PossibleAdducts)processedInput.getAnnotation(PossibleAdducts.class, (Object)new PossibleAdducts());
        pa.update(pim);
    }

    @Deprecated
    public IdentificationResult identify(Ms2Experiment uexperiment) {
        return this.identify(uexperiment, 1).get(0);
    }

    @Deprecated
    public List<IdentificationResult> identify(Ms2Experiment uexperiment, int numberOfCandidates) {
        AbstractTreeComputationInstance instance = this.getTreeComputationImplementation(this.getMs2Analyzer(), uexperiment, numberOfCandidates);
        ProcessedInput pinput = instance.validateInput();
        this.performMs1Analysis(instance);
        SiriusJobs.getGlobalJobManager().submitJob((JJob)instance);
        AbstractTreeComputationInstance.FinalResult fr = (AbstractTreeComputationInstance.FinalResult)instance.takeResult();
        List<IdentificationResult> irs = this.createIdentificationResults(fr, instance);
        return irs;
    }

    @Deprecated
    public List<IdentificationResult> identifyPrecursorAndIonization(Ms2Experiment uexperiment, int numberOfCandidates, IsotopePatternHandling iso) {
        MutableMs2Experiment exp = new MutableMs2Experiment(uexperiment);
        exp.setAnnotation(PossibleIonModes.class, (Object)PossibleIonModes.defaultFor((int)uexperiment.getPrecursorIonType().getCharge()));
        return this.identify((Ms2Experiment)exp, numberOfCandidates, true, iso);
    }

    @Deprecated
    public List<IdentificationResult> identify(Ms2Experiment uexperiment, int numberOfCandidates, boolean recalibrating, IsotopePatternHandling deisotope, Set<MolecularFormula> whiteList) {
        AbstractTreeComputationInstance instance = this.getTreeComputationImplementation(this.getMs2Analyzer(), uexperiment, numberOfCandidates);
        ProcessedInput pinput = instance.validateInput();
        pinput.setAnnotation(ForbidRecalibration.class, (Object)(recalibrating ? ForbidRecalibration.ALLOWED : ForbidRecalibration.FORBIDDEN));
        if (whiteList != null) {
            pinput.setAnnotation(Whiteset.class, (Object)new Whiteset(whiteList));
        }
        this.performMs1Analysis(instance, deisotope);
        SiriusJobs.getGlobalJobManager().submitJob((JJob)instance);
        AbstractTreeComputationInstance.FinalResult fr = (AbstractTreeComputationInstance.FinalResult)instance.takeResult();
        List<IdentificationResult> irs = this.createIdentificationResults(fr, instance);
        return irs;
    }

    protected List<IdentificationResult> createIdentificationResults(AbstractTreeComputationInstance.FinalResult fr, AbstractTreeComputationInstance computationInstance) {
        Sirius.addScoreThresholdOnUnconsideredCandidates(fr, computationInstance.precompute());
        ArrayList<IdentificationResult> irs = new ArrayList<IdentificationResult>();
        int k = 0;
        for (FTree tree : fr.getResults()) {
            IdentificationResult result = new IdentificationResult(tree, ++k);
            irs.add(result);
        }
        return irs;
    }

    private static void addScoreThresholdOnUnconsideredCandidates(AbstractTreeComputationInstance.FinalResult fr, ProcessedInput processedInput) {
        int numberOfResults = fr.getResults().size();
        if (numberOfResults == 0) {
            return;
        }
        int numberOfDecompositions = ((DecompositionList)processedInput.getAnnotationOrThrow(DecompositionList.class)).getDecompositions().size();
        int numberOfUnconsideredCandidates = numberOfDecompositions - numberOfResults;
        double lowestConsideredCandidatesScore = ((TreeScoring)((FTree)fr.getResults().get(numberOfResults - 1)).getAnnotationOrThrow(TreeScoring.class)).getOverallScore();
        UnconsideredCandidatesUpperBound unconsideredCandidatesUpperBound = new UnconsideredCandidatesUpperBound(numberOfUnconsideredCandidates, lowestConsideredCandidatesScore);
        for (FTree tree : fr.getResults()) {
            tree.addAnnotation(UnconsideredCandidatesUpperBound.class, (Object)unconsideredCandidatesUpperBound);
        }
    }

    public List<IdentificationResult> identify(Ms2Experiment uexperiment, int numberOfCandidates, boolean recalibrating, IsotopePatternHandling deisotope) {
        return this.identify(uexperiment, numberOfCandidates, recalibrating, deisotope, (FormulaConstraints)null);
    }

    public List<IdentificationResult> identify(Ms2Experiment uexperiment, int numberOfCandidates, boolean recalibrating, IsotopePatternHandling deisotope, FormulaConstraints formulaConstraints) {
        AbstractTreeComputationInstance instance = this.getTreeComputationImplementation(this.getMs2Analyzer(), uexperiment, numberOfCandidates);
        ProcessedInput pinput = instance.validateInput();
        pinput.setAnnotation(ForbidRecalibration.class, (Object)(recalibrating ? ForbidRecalibration.ALLOWED : ForbidRecalibration.FORBIDDEN));
        if (formulaConstraints != null) {
            pinput.getMeasurementProfile().setFormulaConstraints(formulaConstraints);
        }
        this.performMs1Analysis(instance, deisotope);
        SiriusJobs.getGlobalJobManager().submitJob((JJob)instance);
        AbstractTreeComputationInstance.FinalResult fr = (AbstractTreeComputationInstance.FinalResult)instance.takeResult();
        List<IdentificationResult> irs = this.createIdentificationResults(fr, instance);
        return irs;
    }

    public FormulaConstraints predictElementsFromMs1(Ms2Experiment experiment) {
        SimpleSpectrum pattern = this.getMs1Analyzer().extractPattern(experiment, experiment.getIonMass());
        if (pattern == null) {
            return null;
        }
        return this.getElementPrediction().predictConstraints(pattern);
    }

    public IdentificationResult compute(Ms2Experiment experiment, MolecularFormula formula) {
        return this.compute(experiment, formula, true);
    }

    public BasicJJob<IdentificationResult> makeComputeJob(Ms2Experiment experiment, MolecularFormula formula) {
        AbstractTreeComputationInstance instance = this.getTreeComputationImplementation(this.getMs2Analyzer(), experiment, 1);
        ProcessedInput pinput = instance.validateInput();
        pinput.setAnnotation(Whiteset.class, (Object)Whiteset.of((MolecularFormula[])new MolecularFormula[]{formula}));
        pinput.setAnnotation(ForbidRecalibration.class, (Object)ForbidRecalibration.ALLOWED);
        return instance.wrap(f -> new IdentificationResult((FTree)f.getResults().get(0), 1));
    }

    public IdentificationResult compute(Ms2Experiment experiment, MolecularFormula formula, boolean recalibrating) {
        AbstractTreeComputationInstance instance = this.getTreeComputationImplementation(this.getMs2Analyzer(), experiment, 1);
        ProcessedInput pinput = instance.validateInput();
        pinput.setAnnotation(Whiteset.class, (Object)Whiteset.of((MolecularFormula[])new MolecularFormula[]{formula}));
        pinput.setAnnotation(ForbidRecalibration.class, (Object)(recalibrating ? ForbidRecalibration.ALLOWED : ForbidRecalibration.FORBIDDEN));
        SiriusJobs.getGlobalJobManager().submitJob((JJob)instance);
        IdentificationResult ir = new IdentificationResult((FTree)((AbstractTreeComputationInstance.FinalResult)instance.takeResult()).getResults().get(0), 1);
        if (recalibrating) {
            ir.setBeautifulTree(ir.getRawTree());
        }
        return ir;
    }

    public boolean beautifyTree(IdentificationResult result, Ms2Experiment experiment) {
        return this.beautifyTree(null, result, experiment, true);
    }

    public boolean beautifyTree(IdentificationResult result, Ms2Experiment experiment, boolean recalibrating) {
        return this.beautifyTree(null, result, experiment, recalibrating);
    }

    public boolean beautifyTree(MasterJJob<?> master, IdentificationResult result, Ms2Experiment experiment, boolean recalibrating) {
        if (result.getBeautifulTree() != null) {
            return true;
        }
        FTree beautifulTree = this.beautifyTree(master, result.getStandardTree(), experiment, recalibrating);
        if (beautifulTree != null) {
            result.setBeautifulTree(beautifulTree);
            return true;
        }
        return false;
    }

    public FTree beautifyTree(FTree tree, Ms2Experiment experiment, boolean recalibrating) {
        return this.beautifyTree(null, tree, experiment, recalibrating);
    }

    public FTree beautifyTree(MasterJJob<?> master, FTree tree, Ms2Experiment experiment, boolean recalibrating) {
        if (((Beautified)tree.getAnnotation(Beautified.class, (Object)Beautified.IS_UGGLY)).isBeautiful()) {
            return tree;
        }
        PrecursorIonType ionType = (PrecursorIonType)tree.getAnnotationOrThrow(PrecursorIonType.class);
        MutableMs2Experiment mexp = new MutableMs2Experiment(experiment);
        mexp.setPrecursorIonType(ionType);
        switch ((IonTreeUtils.Type)tree.getAnnotation(IonTreeUtils.Type.class, (Object)IonTreeUtils.Type.RAW)) {
            case RESOLVED: {
                if (ionType.isIntrinsicalCharged()) {
                    MolecularFormula formula = ionType.measuredNeutralMoleculeToNeutralMolecule(tree.getRoot().getFormula());
                    break;
                }
                MolecularFormula formula = tree.getRoot().getFormula();
                break;
            }
            case IONIZED: {
                MolecularFormula formula = ionType.precursorIonToNeutralMolecule(tree.getRoot().getFormula());
                break;
            }
            default: {
                MolecularFormula formula = ionType.measuredNeutralMoleculeToNeutralMolecule(tree.getRoot().getFormula());
            }
        }
        FTree btree = master != null ? (FTree)((AbstractTreeComputationInstance.FinalResult)((FasterTreeComputationInstance)master.submitSubJob((JJob)FasterTreeComputationInstance.beautify((FragmentationPatternAnalysis)this.getMs2Analyzer(), (FTree)tree))).takeResult()).getResults().get(0) : (FTree)((AbstractTreeComputationInstance.FinalResult)((FasterTreeComputationInstance)SiriusJobs.getGlobalJobManager().submitJob((JJob)FasterTreeComputationInstance.beautify((FragmentationPatternAnalysis)this.getMs2Analyzer(), (FTree)tree))).takeResult()).getResults().get(0);
        if (!((Beautified)btree.getAnnotation(Beautified.class, (Object)Beautified.IS_UGGLY)).isBeautiful()) {
            LoggerFactory.getLogger(Sirius.class).warn("Tree beautification annotation is not properly set.");
            btree.setAnnotation(Beautified.class, (Object)Beautified.IS_BEAUTIFUL);
        }
        return btree;
    }

    public MutableMs2Experiment makeMutable(Ms2Experiment experiment) {
        if (experiment instanceof MutableMs2Experiment) {
            return (MutableMs2Experiment)experiment;
        }
        return new MutableMs2Experiment(experiment);
    }

    public void setAllowedIonModes(Ms2Experiment experiment, Ionization ... ionModes) {
        PossibleIonModes pa = new PossibleIonModes();
        for (Ionization ion : ionModes) {
            pa.add(ion, 1.0);
        }
        experiment.setAnnotation(PossibleIonModes.class, (Object)pa);
    }

    public void setAllowedIonModes(ProcessedInput experiment, Ionization ... ionModes) {
        PossibleIonModes pa = new PossibleIonModes();
        for (Ionization ion : ionModes) {
            pa.add(ion, 1.0);
        }
        experiment.setAnnotation(PossibleIonModes.class, (Object)pa);
    }

    public void setAllowedMassDeviation(MutableMs2Experiment experiment, Deviation fragmentMassDeviation) {
        MutableMeasurementProfile prof = this.makeProfile(experiment);
        prof.setAllowedMassDeviation(fragmentMassDeviation);
    }

    private MutableMeasurementProfile makeProfile(MutableMs2Experiment experiment) {
        MeasurementProfile prof = (MeasurementProfile)experiment.getAnnotation(MeasurementProfile.class, null);
        if (prof == null) {
            MutableMeasurementProfile prof2 = new MutableMeasurementProfile();
            experiment.setAnnotation(MeasurementProfile.class, (Object)prof2);
            return prof2;
        }
        if (prof instanceof MutableMeasurementProfile) {
            return (MutableMeasurementProfile)prof;
        }
        MutableMeasurementProfile prof2 = new MutableMeasurementProfile(prof);
        experiment.setAnnotation(MeasurementProfile.class, (Object)prof2);
        return prof2;
    }

    public void setIonModeWithProbability(Ms2Experiment experiment, Ionization ion, double probability) {
        PossibleIonModes pa = (PossibleIonModes)experiment.getAnnotation(PossibleIonModes.class, (Object)new PossibleIonModes());
        pa.add(ion, probability);
        experiment.setAnnotation(PossibleIonModes.class, (Object)pa);
    }

    public void setAllowedAdducts(Ms2Experiment experiment, PrecursorIonType ... adducts) {
        PossibleAdducts ad = new PossibleAdducts(adducts);
        experiment.setAnnotation(PossibleAdducts.class, (Object)ad);
    }

    public void setAllowedAdducts(ProcessedInput processedInput, PrecursorIonType ... adducts) {
        PossibleAdducts ad = new PossibleAdducts(adducts);
        processedInput.setAnnotation(PossibleAdducts.class, (Object)ad);
    }

    public void setFormulaSearchList(Ms2Experiment experiment, MolecularFormula ... formulas) {
        this.setFormulaSearchList(experiment, Arrays.asList(formulas));
    }

    public void setFormulaSearchList(Ms2Experiment experiment, Iterable<MolecularFormula> formulas) {
        HashSet<MolecularFormula> fs = new HashSet<MolecularFormula>();
        for (MolecularFormula f : formulas) {
            fs.add(f);
        }
        Whiteset whiteset = new Whiteset(fs);
        experiment.setAnnotation(Whiteset.class, (Object)whiteset);
    }

    public void enableRecalibration(MutableMs2Experiment experiment, boolean enabled) {
        experiment.setAnnotation(ForbidRecalibration.class, (Object)(enabled ? ForbidRecalibration.ALLOWED : ForbidRecalibration.FORBIDDEN));
    }

    public void setIsotopeMode(MutableMs2Experiment experiment, IsotopePatternHandling handling) {
        FormulaSettings current = (FormulaSettings)experiment.getAnnotation(FormulaSettings.class, (Object)FormulaSettings.defaultWithMs2Only());
        current = handling.isFiltering() ? current.withIsotopeFormulaFiltering() : current.withoutIsotopeFormulaFiltering();
        experiment.setAnnotation(FormulaSettings.class, (Object)current);
        if (handling.isScoring()) {
            experiment.setAnnotation(IsotopeScoring.class, (Object)IsotopeScoring.DEFAULT);
        } else {
            experiment.setAnnotation(IsotopeScoring.class, (Object)IsotopeScoring.DISABLED);
        }
    }

    public void setAutomaticElementDetectionFor(Ms2Experiment experiment, Element elements) {
        FormulaSettings current = (FormulaSettings)experiment.getAnnotation(FormulaSettings.class, (Object)FormulaSettings.defaultWithMs2Only());
        experiment.setAnnotation(FormulaSettings.class, (Object)current.withoutAutoDetect().autoDetect(new Element[]{elements}));
    }

    public void setFormulaConstraints(Ms2Experiment experiment, FormulaConstraints constraints) {
        FormulaSettings current = (FormulaSettings)experiment.getAnnotation(FormulaSettings.class, (Object)FormulaSettings.defaultWithMs2Only());
        experiment.setAnnotation(FormulaSettings.class, (Object)current.withConstraints(constraints));
    }

    public void enableAutomaticElementDetection(Ms2Experiment experiment, boolean enabled) {
        FormulaSettings current = (FormulaSettings)experiment.getAnnotation(FormulaSettings.class, (Object)FormulaSettings.defaultWithMs2Only());
        if (enabled) {
            experiment.setAnnotation(FormulaSettings.class, (Object)current.autoDetect(this.getElementPrediction().getChemicalAlphabet().getElements().toArray(new Element[0])));
        } else {
            experiment.setAnnotation(FormulaSettings.class, (Object)current.withoutAutoDetect());
        }
    }

    public void setTimeout(MutableMs2Experiment experiment, int timeoutPerInstanceInSeconds, int timeoutPerDecompositionInSeconds) {
        experiment.setAnnotation(Timeout.class, (Object)Timeout.newTimeout((int)timeoutPerInstanceInSeconds, (int)timeoutPerDecompositionInSeconds));
    }

    public void disableTimeout(MutableMs2Experiment experiment) {
        experiment.setAnnotation(Timeout.class, (Object)Timeout.NO_TIMEOUT);
    }

    public Spectrum<Peak> wrapSpectrum(double[] mz, double[] intensities) {
        return Spectrums.wrap((double[])mz, (double[])intensities);
    }

    public Element getElement(String symbol) {
        return this.table.getByName(symbol);
    }

    @Deprecated
    public Ionization getIonization(String name) {
        return this.getPrecursorIonType(name).getIonization();
    }

    public PrecursorIonType getPrecursorIonType(String name) {
        return this.table.ionByName(name);
    }

    public Charge getCharge(int charge) {
        if (charge != -1 && charge != 1) {
            throw new IllegalArgumentException("SIRIUS does not support multiple charged compounds");
        }
        return new Charge(charge);
    }

    public Deviation getMassDeviation(int ppm, double abs) {
        return new Deviation((double)ppm, abs);
    }

    public Deviation getMassDeviation(int ppm) {
        return new Deviation((double)ppm);
    }

    public MolecularFormula parseFormula(String f) {
        return MolecularFormula.parse((String)f);
    }

    public Ms2Experiment getMs2Experiment(MolecularFormula formula, Ionization ion, Spectrum<Peak> ms1, Spectrum ... ms2) {
        return this.getMs2Experiment(formula, PrecursorIonType.getPrecursorIonType((Ionization)ion), ms1, ms2);
    }

    public Ms2Experiment getMs2Experiment(MolecularFormula formula, PrecursorIonType ion, Spectrum<Peak> ms1, Spectrum ... ms2) {
        MutableMs2Experiment exp = (MutableMs2Experiment)this.getMs2Experiment(ion.neutralMassToPrecursorMass(formula.getMass()), ion, ms1, ms2);
        exp.setMolecularFormula(formula);
        return exp;
    }

    public Ms2Experiment getMs2Experiment(double parentMass, PrecursorIonType ion, Spectrum<Peak> ms1, Spectrum ... ms2) {
        MutableMs2Experiment mexp = new MutableMs2Experiment();
        mexp.setPrecursorIonType(ion);
        mexp.setIonMass(parentMass);
        for (Spectrum spec : ms2) {
            mexp.getMs2Spectra().add(new MutableMs2Spectrum(spec, mexp.getIonMass(), CollisionEnergy.none(), 2));
        }
        return mexp;
    }

    public Ms2Experiment getMs2Experiment(double parentMass, Ionization ion, Spectrum<Peak> ms1, Spectrum ... ms2) {
        return this.getMs2Experiment(parentMass, PrecursorIonType.getPrecursorIonType((Ionization)ion), ms1, ms2);
    }

    public FormulaConstraints getFormulaConstraints(String constraints) {
        return new FormulaConstraints(constraints);
    }

    public List<MolecularFormula> decompose(double mass, Ionization ion, FormulaConstraints constr) {
        return this.decompose(mass, ion, constr, this.getMs2Analyzer().getDefaultProfile().getAllowedMassDeviation());
    }

    public List<MolecularFormula> decompose(double mass, Ionization ion, FormulaConstraints constr, Deviation dev) {
        return this.getMs2Analyzer().getDecomposerFor(constr.getChemicalAlphabet()).decomposeToFormulas(ion.subtractFromMass(mass), dev, constr);
    }

    public List<MolecularFormula> bioTransform(MolecularFormula source, BioTransformation transformation) {
        return BioTransformer.transform((MolecularFormula)source, (BioTransformation)transformation);
    }

    public List<MolecularFormula> bioTransform(MolecularFormula source) {
        return BioTransformer.getAllTransformations((MolecularFormula)source);
    }

    public Spectrum<Peak> simulateIsotopePattern(MolecularFormula compound, Ionization ion) {
        return this.getMs1Analyzer().getPatternGenerator().simulatePattern(compound, ion);
    }

    public Spectrum<Peak> simulateIsotopePattern(MolecularFormula compound, Ionization ion, int numberOfPeaks) {
        IsotopePatternGenerator gen = this.getMs1Analyzer().getPatternGenerator();
        gen.setMaximalNumberOfPeaks(numberOfPeaks);
        return gen.simulatePattern(compound, ion);
    }

    private double filterCandidateList(List<IsotopePattern> candidates, HashMap<MolecularFormula, IsotopePattern> formulas, IsotopePatternHandling handling) {
        int n;
        if (handling == IsotopePatternHandling.omit) {
            return 0.0;
        }
        if (candidates.size() == 0) {
            return 0.0;
        }
        double opt = Double.NEGATIVE_INFINITY;
        SupportVectorMolecularFormulaScorer formulaScorer = new SupportVectorMolecularFormulaScorer();
        for (IsotopePattern p : candidates) {
            opt = Math.max(opt, p.getScore() + formulaScorer.score((MolecularFormula)p.getCandidate()));
        }
        if (opt < 0.0) {
            for (IsotopePattern p : candidates) {
                formulas.put((MolecularFormula)p.getCandidate(), new IsotopePattern((MolecularFormula)p.getCandidate(), 0.0, p.getPattern()));
            }
            return candidates.get(0).getScore();
        }
        double optscore = candidates.get(0).getScore();
        if (!handling.isFiltering()) {
            for (IsotopePattern p : candidates) {
                formulas.put((MolecularFormula)p.getCandidate(), p);
            }
            return candidates.get(0).getScore();
        }
        formulas.put((MolecularFormula)candidates.get(0).getCandidate(), candidates.get(0));
        for (n = 1; n < candidates.size(); ++n) {
            double score = candidates.get(n).getScore();
            double prev = candidates.get(n - 1).getScore();
            if (optscore - score > 5.0 && (score <= 0.0 || score / optscore < 0.5 || score / prev < 0.5)) break;
        }
        for (int i = 0; i < n; ++i) {
            formulas.put((MolecularFormula)candidates.get(i).getCandidate(), candidates.get(i));
        }
        return optscore;
    }

    private ExtractedIsotopePattern extractedIsotopePattern(ProcessedInput pinput) {
        ExtractedIsotopePattern pat = (ExtractedIsotopePattern)pinput.getAnnotation(ExtractedIsotopePattern.class, null);
        if (pat == null) {
            SimpleSpectrum spectrum = this.getMs1Analyzer().extractPattern((Spectrum)this.mergeMs1Spec(pinput), (MeasurementProfile)pinput.getMeasurementProfile(), pinput.getExperimentInformation().getIonMass());
            pat = new ExtractedIsotopePattern(spectrum);
            pinput.setAnnotation(ExtractedIsotopePattern.class, (Object)pat);
        }
        return pat;
    }

    private SimpleSpectrum mergeMs1Spec(ProcessedInput pinput) {
        MutableMs2Experiment experiment = pinput.getExperimentInformation();
        if (experiment.getMergedMs1Spectrum() != null) {
            return experiment.getMergedMs1Spectrum();
        }
        if (experiment.getMs1Spectra().size() > 0) {
            experiment.setMergedMs1Spectrum(Spectrums.mergeSpectra((List)experiment.getMs1Spectra()));
            return experiment.getMergedMs1Spectrum();
        }
        return new SimpleSpectrum(new double[0], new double[0]);
    }

    protected boolean performMs1Analysis(AbstractTreeComputationInstance instance) {
        FormulaSettings fs = (FormulaSettings)instance.validateInput().getAnnotation(FormulaSettings.class, null);
        IsotopeScoring iso = (IsotopeScoring)instance.validateInput().getAnnotation(IsotopeScoring.class, null);
        if (fs == null || fs.isAllowIsotopeElementFiltering()) {
            if (iso == null || iso.getIsotopeScoreWeighting() > 0.0) {
                return this.performMs1Analysis(instance, IsotopePatternHandling.both);
            }
            return this.performMs1Analysis(instance, IsotopePatternHandling.filter);
        }
        if (iso == null || iso.getIsotopeScoreWeighting() > 0.0) {
            return this.performMs1Analysis(instance, IsotopePatternHandling.score);
        }
        return this.performMs1Analysis(instance, IsotopePatternHandling.omit);
    }

    protected boolean performMs1Analysis(AbstractTreeComputationInstance instance, IsotopePatternHandling handling) {
        if (handling == IsotopePatternHandling.omit) {
            return false;
        }
        ProcessedInput input = instance.validateInput();
        ExtractedIsotopePattern pattern = this.extractedIsotopePattern(input);
        if (!pattern.hasPatternWithAtLeastTwoPeaks()) {
            return false;
        }
        this.performAutomaticElementDetection(input, pattern.getPattern());
        PossibleIonModes pim = (PossibleIonModes)input.getAnnotation(PossibleIonModes.class, null);
        if (pim == null) {
            this.detectPossibleIonModesFromMs1(input);
        } else if (pim.isGuessFromMs1Enabled()) {
            this.detectPossibleIonModesFromMs1(input, pim.getIonModesAsPrecursorIonType().toArray(new PrecursorIonType[0]));
        }
        if (((IsotopeScoring)input.getAnnotation(IsotopeScoring.class, (Object)IsotopeScoring.DEFAULT)).getIsotopeScoreWeighting() <= 0.0) {
            return false;
        }
        DecompositionList decompositions = (DecompositionList)instance.precompute().getAnnotationOrThrow(DecompositionList.class);
        IsotopePatternAnalysis an = this.getMs1Analyzer();
        for (Map.Entry entry : decompositions.getFormulasPerIonMode().entrySet()) {
            for (IsotopePattern pat : an.scoreFormulas(pattern.getPattern(), (List)entry.getValue(), (Ms2Experiment)input.getExperimentInformation(), (MeasurementProfile)input.getMeasurementProfile(), PrecursorIonType.getPrecursorIonType((Ionization)((Ionization)entry.getKey())))) {
                pattern.getExplanations().put(pat.getCandidate(), pat);
            }
        }
        int isoPeaks = 0;
        double maxScore = Double.NEGATIVE_INFINITY;
        for (IsotopePattern isotopePattern : pattern.getExplanations().values()) {
            maxScore = Math.max(isotopePattern.getScore(), maxScore);
            isoPeaks = Math.max(isotopePattern.getPattern().size(), isoPeaks);
        }
        if (maxScore >= 10.0 && handling.isFiltering()) {
            Iterator iter = decompositions.getDecompositions().iterator();
            while (iter.hasNext()) {
                Decomposition decomposition = (Decomposition)iter.next();
                IsotopePattern p = (IsotopePattern)pattern.getExplanations().get(decomposition.getCandidate());
                if (p != null && !(p.getScore() < (double)isoPeaks * 2.5)) continue;
                iter.remove();
            }
        }
        for (Map.Entry entry : pattern.getExplanations().entrySet()) {
            entry.setValue(((IsotopePattern)entry.getValue()).withScore(handling.isScoring() ? Math.max(((IsotopePattern)entry.getValue()).getScore(), 0.0) : 0.0));
        }
        return true;
    }

    private void performAutomaticElementDetection(ProcessedInput input, SimpleSpectrum extractedPattern) {
        FormulaSettings settings = (FormulaSettings)input.getAnnotation(FormulaSettings.class, (Object)FormulaSettings.defaultWithMs1());
        if (settings.isElementDetectionEnabled()) {
            ElementPredictor predictor = this.getElementPrediction();
            HashSet allowedElements = new HashSet(input.getMeasurementProfile().getFormulaConstraints().getChemicalAlphabet().getElements());
            HashSet auto = settings.getAutomaticDetectionEnabled();
            allowedElements.addAll(auto);
            Iterator e = allowedElements.iterator();
            FormulaConstraints constraints = predictor.predictConstraints(extractedPattern);
            while (e.hasNext()) {
                Element detectable = (Element)e.next();
                if (!auto.contains(detectable) || !this.getElementPrediction().isPredictable(detectable) || constraints.getUpperbound(detectable) > 0) continue;
                e.remove();
            }
            FormulaConstraints revised = settings.getConstraints().getExtendedConstraints(allowedElements.toArray(new Element[allowedElements.size()]));
            for (Element det : auto) {
                revised.setUpperbound(det, constraints.getUpperbound(det));
            }
            input.getMeasurementProfile().setFormulaConstraints(revised);
        }
    }

    public class SiriusIdentificationJob
    extends BasicMasterJJob<List<IdentificationResult>> {
        private final Ms2Experiment experiment;
        private final int numberOfResultsToKeep;
        private final boolean beautifyTrees;

        public SiriusIdentificationJob(Ms2Experiment experiment, int numberOfResultsToKeep, boolean beautifyTrees) {
            super(JJob.JobType.CPU);
            this.experiment = experiment;
            this.numberOfResultsToKeep = numberOfResultsToKeep;
            this.beautifyTrees = beautifyTrees;
        }

        protected List<IdentificationResult> compute() throws Exception {
            AbstractTreeComputationInstance instance = Sirius.this.getTreeComputationImplementation(Sirius.this.getMs2Analyzer(), this.experiment, this.numberOfResultsToKeep);
            instance.addPropertyChangeListener("jjob_progress", evt -> this.updateProgress(0, 105, (Integer)evt.getNewValue()));
            ProcessedInput pinput = instance.validateInput();
            Sirius.this.performMs1Analysis(instance);
            this.submitSubJob((JJob)instance);
            AbstractTreeComputationInstance.FinalResult fr = (AbstractTreeComputationInstance.FinalResult)instance.awaitResult();
            List<IdentificationResult> r = this.createIdentificationResults(fr, instance);
            return r;
        }

        private List<IdentificationResult> createIdentificationResults(AbstractTreeComputationInstance.FinalResult fr, AbstractTreeComputationInstance computationInstance) {
            Sirius.addScoreThresholdOnUnconsideredCandidates(fr, computationInstance.precompute());
            ArrayList<IdentificationResult> irs = new ArrayList<IdentificationResult>();
            int k = 0;
            for (FTree tree : fr.getResults()) {
                ProcessedInput processedInput;
                IdentificationResult result = new IdentificationResult(tree, ++k);
                irs.add(result);
                if (this.beautifyTrees) {
                    Sirius.this.beautifyTree((MasterJJob<?>)this, result, this.experiment, this.experiment.getAnnotation(ForbidRecalibration.class, (Object)ForbidRecalibration.ALLOWED) == ForbidRecalibration.ALLOWED);
                }
                if ((processedInput = (ProcessedInput)result.getStandardTree().getAnnotationOrNull(ProcessedInput.class)) != null) {
                    result.setAnnotation(Ms2Experiment.class, processedInput.getExperimentInformation());
                    continue;
                }
                result.setAnnotation(Ms2Experiment.class, this.experiment);
            }
            return irs;
        }

        public Ms2Experiment getExperiment() {
            return this.experiment;
        }

        public int getNumberOfResultsToKeep() {
            return this.numberOfResultsToKeep;
        }
    }
}

