/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius;

import com.google.common.base.Function;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.babelms.json.FTJsonWriter;
import de.unijena.bioinf.babelms.ms.JenaMsWriter;
import de.unijena.bioinf.sirius.IdentificationResult;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.LoggerFactory;

@Deprecated
public class SiriusResultWriter
implements Closeable {
    private ZipOutputStream zout;
    private int entries;

    public SiriusResultWriter(OutputStream outputStream) {
        this.zout = new ZipOutputStream(outputStream);
        this.entries = 0;
    }

    public synchronized void add(Ms2Experiment experiment, List<IdentificationResult> results) throws IOException {
        SiriusResultWriter.storeEntry(experiment, results, ++this.entries, this.zout);
    }

    private static void storeEntry(final Ms2Experiment exp, List<IdentificationResult> results, int i, ZipOutputStream stream) throws IOException {
        String prefix = i + "/";
        ZipEntry dir = new ZipEntry(prefix);
        stream.putNextEntry(dir);
        stream.closeEntry();
        ZipEntry msfile = new ZipEntry(prefix + "experiment.ms");
        stream.putNextEntry(msfile);
        stream.write(SiriusResultWriter.buffer(new Function<BufferedWriter, Void>(){

            public Void apply(BufferedWriter input) {
                JenaMsWriter writer = new JenaMsWriter();
                try {
                    writer.write(input, exp);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException();
                }
                return null;
            }
        }).getBytes(Charset.forName("UTF-8")));
        stream.closeEntry();
        if (results.size() > 0) {
            for (final IdentificationResult ir : results) {
                ZipEntry tree = new ZipEntry(prefix + (ir.getRank() + 1) + ".json");
                stream.putNextEntry(tree);
                stream.write(SiriusResultWriter.buffer(new Function<BufferedWriter, Void>(){

                    public Void apply(BufferedWriter input) {
                        try {
                            new FTJsonWriter().writeTree((Writer)input, ir.getRawTree());
                        }
                        catch (IOException e) {
                            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                }).getBytes(Charset.forName("UTF-8")));
                stream.closeEntry();
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.zout.close();
    }

    private static String buffer(Function<BufferedWriter, Void> f) {
        try {
            StringWriter sw = new StringWriter(1024);
            BufferedWriter bw = new BufferedWriter(sw);
            f.apply((Object)bw);
            bw.close();
            sw.close();
            return sw.toString();
        }
        catch (IOException e) {
            assert (false);
            LoggerFactory.getLogger(SiriusResultWriter.class).error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

