/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.elementpred;

import de.unijena.bioinf.ChemistryBase.chem.ChemicalAlphabet;
import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.FormulaConstraints;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePatternAnalysis;
import de.unijena.bioinf.sirius.elementpred.Judge;
import de.unijena.bioinf.sirius.elementpred.PredictFromMs1;
import de.unijena.bioinf.sirius.elementpred.PredictFromMs2;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Collections;

public class ElementPrediction {
    private Judge[] judges;

    public ElementPrediction(IsotopePatternAnalysis isoAnalyzer) {
        this.judges = new Judge[]{new PredictFromMs1(isoAnalyzer), new PredictFromMs2()};
    }

    public FormulaConstraints extendConstraints(FormulaConstraints input, Ms2Experiment experiment, MeasurementProfile profile) {
        TObjectIntHashMap voter = new TObjectIntHashMap(5, 0.75f, 0);
        for (Judge j : this.judges) {
            j.vote((TObjectIntHashMap<Element>)voter, experiment, profile);
        }
        ChemicalAlphabet alphabet = input.getChemicalAlphabet();
        final ArrayList elems = new ArrayList();
        ArrayList<Element> toExtend = new ArrayList<Element>();
        voter.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<Element>(){

            public boolean execute(Element a, int b) {
                if (b > 0) {
                    elems.add(new VotedElement(a, b));
                }
                return true;
            }
        });
        Collections.sort(elems);
        int threshold = 0;
        for (int k = 0; k < elems.size(); ++k) {
            if (((VotedElement)elems.get(k)).votes <= threshold) continue;
            if (alphabet.indexOf(((VotedElement)elems.get(k)).element) < 0) {
                toExtend.add(((VotedElement)elems.get(k)).element);
            }
            threshold += 4;
        }
        if (toExtend.size() > 0) {
            ArrayList<Element> newElements = new ArrayList<Element>(input.getChemicalAlphabet().getElements());
            for (Element e : toExtend) {
                newElements.add(e);
            }
            ChemicalAlphabet newAlphabet = new ChemicalAlphabet(newElements.toArray(new Element[newElements.size()]));
            FormulaConstraints newConstraints = new FormulaConstraints(newAlphabet, input.getFilters());
            for (Element e : alphabet) {
                newConstraints.setUpperbound(e, input.getUpperbound(e));
            }
            PeriodicTable table = PeriodicTable.getInstance();
            Element Chlorine = table.getByName("Cl");
            Element Bromine = table.getByName("Br");
            Element Iodine = table.getByName("I");
            Element Florine = table.getByName("F");
            if (newAlphabet.indexOf(Chlorine) >= 0 && alphabet.indexOf(Chlorine) < 0) {
                newConstraints.setUpperbound(Chlorine, 10);
            }
            if (newAlphabet.indexOf(Bromine) >= 0 && alphabet.indexOf(Bromine) < 0) {
                newConstraints.setUpperbound(Bromine, 4);
            }
            if (newAlphabet.indexOf(Iodine) >= 0 && alphabet.indexOf(Iodine) < 0) {
                newConstraints.setUpperbound(Iodine, 10);
            }
            if (newAlphabet.indexOf(Florine) >= 0 && alphabet.indexOf(Florine) < 0) {
                newConstraints.setUpperbound(Florine, 20);
            }
            return newConstraints;
        }
        return input;
    }

    private static class VotedElement
    implements Comparable<VotedElement> {
        private Element element;
        private int votes;

        public VotedElement(Element element, int votes) {
            this.element = element;
            this.votes = votes;
        }

        @Override
        public int compareTo(VotedElement o) {
            return o.votes - this.votes;
        }
    }
}

