/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.elementpred;

import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleSpectrum;
import de.unijena.bioinf.IsotopePatternAnalysis.IsotopePatternAnalysis;
import de.unijena.bioinf.sirius.elementpred.Judge;
import gnu.trove.map.hash.TObjectIntHashMap;

public class PredictFromMs1
implements Judge {
    private final IsotopePatternAnalysis extractor;

    public PredictFromMs1(IsotopePatternAnalysis extractor) {
        this.extractor = extractor;
    }

    @Override
    public void vote(TObjectIntHashMap<Element> votes, Ms2Experiment experiment, MeasurementProfile profile) {
        Element Cl = PeriodicTable.getInstance().getByName("Cl");
        Element Br = PeriodicTable.getInstance().getByName("Br");
        boolean evidenceForClBr = false;
        if (experiment.getMs1Spectra().size() > 0) {
            for (Spectrum spec : experiment.getMs1Spectra()) {
                SimpleSpectrum ms1spec = this.extractor.extractPattern(spec, profile, experiment.getIonMass());
                if (ms1spec == null) continue;
                double mono = ms1spec.getMzAt(0);
                int plus1 = (int)Math.round(mono + 1.0);
                int plus2 = (int)Math.round(mono + 2.0);
                double int1 = 0.0;
                double int2 = 0.0;
                for (int k = 0; k < ms1spec.size(); ++k) {
                    if (Math.round(ms1spec.getMzAt(k)) == (long)plus1) {
                        int1 = Math.max(int1, ms1spec.getIntensityAt(k));
                        continue;
                    }
                    if (Math.round(ms1spec.getMzAt(k)) != (long)plus2) continue;
                    int2 = Math.max(int2, ms1spec.getIntensityAt(k));
                }
                if (int1 == 0.0 && int2 == 0.0) continue;
                if (int1 > 0.0 && int2 == 0.0) {
                    if (evidenceForClBr) continue;
                    votes.adjustOrPutValue((Object)Cl, -10, -10);
                    votes.adjustOrPutValue((Object)Br, -10, -10);
                    continue;
                }
                if (int2 > int1) {
                    evidenceForClBr = true;
                    if (int2 / int1 <= 3.0) {
                        votes.adjustOrPutValue((Object)Cl, 10, 10);
                        votes.adjustOrPutValue((Object)Br, 3, 3);
                        continue;
                    }
                    if (!(int2 / int1 > 3.0)) continue;
                    votes.adjustOrPutValue((Object)Cl, 5, 5);
                    votes.adjustOrPutValue((Object)Br, 6, 6);
                    continue;
                }
                if (evidenceForClBr) continue;
                votes.adjustOrPutValue((Object)Cl, -10, -10);
                votes.adjustOrPutValue((Object)Br, -10, -10);
            }
        }
    }
}

