/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.elementpred;

import de.unijena.bioinf.ChemistryBase.chem.ChemicalAlphabet;
import de.unijena.bioinf.ChemistryBase.chem.Element;
import de.unijena.bioinf.ChemistryBase.chem.Ionization;
import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.chem.PeriodicTable;
import de.unijena.bioinf.ChemistryBase.ms.Deviation;
import de.unijena.bioinf.ChemistryBase.ms.MeasurementProfile;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.MutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.Spectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.SimpleMutableSpectrum;
import de.unijena.bioinf.ChemistryBase.ms.utils.Spectrums;
import de.unijena.bioinf.MassDecomposer.Chemistry.MassToFormulaDecomposer;
import de.unijena.bioinf.sirius.elementpred.Judge;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.HashSet;

public class PredictFromMs2
implements Judge {
    private static final String[] REPORTER_IONS = new String[]{"C7H5Cl", "C8H6ClN", "C8H4ClN", "C9H5Cl", "C6H3Cl", "C7H3Cl", "C9H8ClN", "C8H5Cl", "C7H5F", "C9H5F", "C5H3Cl", "C8H7Cl", "C9H7Cl", "C8H8ClN", "C13H8ClN", "C10H9FO", "C11H7FN2O", "C6H3F", "C7H3FO", "C8H5F", "C7H4Cl2", "C7H4ClN", "C7H3ClO", "C6H4ClN"};
    private static final String[] REPORTER_LOSSES = new String[]{"HCl", "Cl", "Br", "HBr", "CClO", "CH3Cl", "HF", "CHClO", "C6H5Cl", "C2H3F", "CF3", "CHFO", "HI", "I"};
    private final MassToFormulaDecomposer decomposer = new MassToFormulaDecomposer(new ChemicalAlphabet(MolecularFormula.parse((String)"CHNOPSClBrIF").elementArray()));
    private final MolecularFormula[] reporterIons = new MolecularFormula[REPORTER_IONS.length];
    private final MolecularFormula[] reporterLosses = new MolecularFormula[REPORTER_LOSSES.length];
    private final double[] reporterIonMasses = new double[REPORTER_IONS.length];
    private final double[] reporterLossMasses;
    private final double maxDiff;

    public PredictFromMs2() {
        int k;
        double maxMass = 0.0;
        for (k = 0; k < REPORTER_LOSSES.length; ++k) {
            this.reporterLosses[k] = MolecularFormula.parse((String)REPORTER_LOSSES[k]);
            maxMass = Math.max(this.reporterLosses[k].getMass(), maxMass);
        }
        for (k = 0; k < this.reporterIons.length; ++k) {
            this.reporterIons[k] = MolecularFormula.parse((String)REPORTER_IONS[k]);
        }
        this.maxDiff = maxMass + 0.5;
        Arrays.sort(this.reporterLosses);
        Arrays.sort(this.reporterIons);
        this.reporterLossMasses = new double[this.reporterIons.length];
        for (k = 0; k < this.reporterLosses.length; ++k) {
            this.reporterLossMasses[k] = this.reporterLosses[k].getMass();
        }
        for (k = 0; k < this.reporterIons.length; ++k) {
            this.reporterIonMasses[k] = this.reporterIons[k].getMass();
        }
    }

    @Override
    public void vote(TObjectIntHashMap<Element> votes, Ms2Experiment experiment, MeasurementProfile profile) {
        this.voteForReporterIons(votes, experiment, profile);
    }

    private void voteForReporterIons(TObjectIntHashMap<Element> votes, Ms2Experiment experiment, MeasurementProfile profile) {
        PeriodicTable table = PeriodicTable.getInstance();
        Element Cl = table.getByName("Cl");
        Element Br = table.getByName("Br");
        Element I = table.getByName("I");
        Element F = table.getByName("F");
        Element[] halogens = new Element[]{Cl, Br, I, F};
        Deviation allowedDev = profile.getAllowedMassDeviation().divide(2.0);
        HashSet<MolecularFormula> detectedFragments = new HashSet<MolecularFormula>();
        HashSet<MolecularFormula> detectedLosses = new HashSet<MolecularFormula>();
        TObjectIntHashMap detectedSubsets = new TObjectIntHashMap();
        for (Ms2Spectrum ms2spec : experiment.getMs2Spectra()) {
            SimpleMutableSpectrum sms = new SimpleMutableSpectrum((Spectrum)ms2spec);
            Spectrums.sortSpectrumByDescendingIntensity((MutableSpectrum)sms);
            SimpleMutableSpectrum spec = new SimpleMutableSpectrum(40);
            for (int k = 0; k < Math.min(40, sms.size()); ++k) {
                spec.addPeak(sms.getMzAt(k), sms.getIntensityAt(k));
            }
            Spectrums.sortSpectrumByMass((MutableSpectrum)spec);
            Ionization ion = ms2spec.getIonization() == null ? experiment.getPrecursorIonType().getIonization() : ms2spec.getIonization();
            for (int k = 0; k < spec.size(); ++k) {
                double mzdiff;
                double mz = spec.getMzAt(k);
                double neutralMass = ion.subtractFromMass(mz);
                int index = this.searchForMass(neutralMass, this.reporterIonMasses, allowedDev);
                if (index >= 0) {
                    detectedFragments.add(this.reporterIons[index]);
                }
                for (int l = k + 1; l < spec.size() && !((mzdiff = spec.getMzAt(l) - mz) > this.maxDiff); ++l) {
                    int index2 = this.searchForMass(mzdiff, this.reporterLossMasses, allowedDev);
                    if (index2 < 0) continue;
                    detectedLosses.add(this.reporterLosses[index2]);
                }
            }
            int[] votesNum = new int[]{0, 0, 0, 0};
            for (MolecularFormula f : detectedFragments) {
                for (int i = 0; i < halogens.length; ++i) {
                    if (f.numberOf(halogens[i]) <= 0) continue;
                    int n = i;
                    votesNum[n] = votesNum[n] + 1;
                }
            }
            for (int i = 0; i < halogens.length; ++i) {
                int value = Math.min(2, votesNum[i]);
                votes.adjustOrPutValue((Object)halogens[i], value, value);
            }
            Arrays.fill(votesNum, 0);
            for (MolecularFormula f : detectedLosses) {
                for (int i = 0; i < halogens.length; ++i) {
                    if (f.numberOf(halogens[i]) <= 0) continue;
                    int n = i;
                    votesNum[n] = votesNum[n] + 1;
                }
            }
            for (int i = 0; i < halogens.length; ++i) {
                int value = Math.max(0, Math.min(2, votesNum[i] - 3));
                votes.adjustOrPutValue((Object)halogens[i], value, value);
            }
            Arrays.fill(votesNum, 0);
        }
    }

    private int searchForMass(double mz, double[] masses, Deviation allowedDev) {
        int k = Arrays.binarySearch(masses, mz);
        if (k >= 0) {
            return k;
        }
        int i = -(k + 1);
        for (int j = Math.max(0, i - 1); j < Math.min(masses.length, i + 1); ++j) {
            if (!allowedDev.inErrorWindow(masses[j], mz)) continue;
            return j;
        }
        return -1;
    }
}

