/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.ProjectWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractProjectWriter
implements ProjectWriter {
    protected ExperimentResult experimentResult;
    protected HashSet<String> surpressedOutputs = new HashSet();

    public void surpress(String output) {
        this.surpressedOutputs.add(output);
    }

    public boolean isSurpressed(String name) {
        return this.surpressedOutputs.contains(name);
    }

    public boolean isAllowed(String name) {
        return !this.isSurpressed(name);
    }

    protected abstract void startWriting();

    @Override
    public void close() throws IOException {
        this.endWriting();
    }

    protected abstract void endWriting();

    @Override
    public void writeExperiment(ExperimentResult result) throws IOException {
        this.experimentResult = result;
        this.writeInput(result, result.experiment);
        if (result.results != null) {
            this.startWritingIdentificationResults(result, result.results);
            for (IdentificationResult r : result.results) {
                this.startWritingIdentificationResult(r);
                this.writeIdentificationResult(r);
                this.endWritingIdentificationResult(r);
            }
            this.endWritingIdentificationResults(result.results);
        }
        this.endWritingExperiment(result);
    }

    protected abstract void endWritingExperiment(ExperimentResult var1) throws IOException;

    protected abstract void endWritingIdentificationResults(List<IdentificationResult> var1) throws IOException;

    protected abstract void endWritingIdentificationResult(IdentificationResult var1) throws IOException;

    protected abstract void writeIdentificationResult(IdentificationResult var1) throws IOException;

    protected abstract void startWritingIdentificationResult(IdentificationResult var1) throws IOException;

    protected abstract void startWritingIdentificationResults(ExperimentResult var1, List<IdentificationResult> var2) throws IOException;

    protected abstract void writeInput(ExperimentResult var1, Ms2Experiment var2) throws IOException;
}

