/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.ChemistryBase.chem.MolecularFormula;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.ChemistryBase.ms.ft.FTree;
import de.unijena.bioinf.babelms.json.FTJsonReader;
import de.unijena.bioinf.babelms.ms.JenaMsParser;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.Index;
import de.unijena.bioinf.sirius.projectspace.ProjectReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectoryReader
implements ProjectReader {
    protected final ReadingEnvironment env;
    protected final List<Instance> experiments;
    protected int currentIndex = 0;
    private static Pattern EXPP = Pattern.compile("(\\d+)_(.+)_(.+)");
    private static final Pattern RESULT_PATTERN = Pattern.compile("(\\d+)_(.+)(_(.+))?\\.json");

    public DirectoryReader(ReadingEnvironment env) {
        this.env = env;
        List<String> names = env.list();
        this.experiments = new ArrayList<Instance>(names.size());
        for (String name : names) {
            Matcher m = EXPP.matcher(name);
            if (!m.matches()) continue;
            this.experiments.add(new Instance(Integer.parseInt(m.group(1)), m.group(2), m.group(3)));
        }
    }

    public void close() throws IOException {
    }

    public boolean hasNext() {
        return this.currentIndex < this.experiments.size();
    }

    public ExperimentResult next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            ExperimentResult experimentResult = this.parseExperiment(this.experiments.get(this.currentIndex));
            return experimentResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ++this.currentIndex;
        }
    }

    private ExperimentResult parseExperiment(final Instance instance) throws IOException {
        this.env.enterDirectory(instance.getDirectory());
        HashSet<String> names = new HashSet<String>(this.env.list());
        Ms2Experiment input = null;
        ArrayList<IdentificationResult> results = new ArrayList<IdentificationResult>();
        if (names.contains("spectrum.ms")) {
            input = this.parseSpectrum(instance);
        }
        input.setAnnotation(Index.class, (Object)new Index(instance.index));
        if (names.contains("trees")) {
            this.env.enterDirectory("trees");
            List<String> trs = this.env.list();
            this.keep(trs, RESULT_PATTERN);
            for (final String s : trs) {
                Matcher m = RESULT_PATTERN.matcher(s);
                m.matches();
                MolecularFormula formula = MolecularFormula.parse((String)m.group(2));
                int rank = Integer.parseInt(m.group(1));
                FTree tree = this.read(s, new Do<FTree>(){

                    @Override
                    public FTree run(Reader r) throws IOException {
                        return new FTJsonReader().parse(new BufferedReader(r), DirectoryReader.this.env.absolutePath(instance.getDirectory() + "/trees/" + s));
                    }
                });
                results.add(new IdentificationResult(tree, rank));
            }
            this.env.leaveDirectory();
        }
        Collections.sort(results, new Comparator<IdentificationResult>(){

            @Override
            public int compare(IdentificationResult o1, IdentificationResult o2) {
                return Integer.compare(o1.getRank(), o2.getRank());
            }
        });
        this.addMetaData(input, results);
        this.env.leaveDirectory();
        String[] name = instance.getDirectory().split("_");
        return new ExperimentResult(input, results, name[1], name[2]);
    }

    protected void addMetaData(Ms2Experiment input, List<IdentificationResult> results) throws IOException {
    }

    private void keep(List<String> trs, Pattern p) {
        Iterator<String> i = trs.iterator();
        while (i.hasNext()) {
            if (p.matcher(i.next()).matches()) continue;
            i.remove();
        }
    }

    private Ms2Experiment parseSpectrum(final Instance i) throws IOException {
        return this.read("spectrum.ms", new Do<Ms2Experiment>(){

            @Override
            public Ms2Experiment run(Reader r) throws IOException {
                return new JenaMsParser().parse(new BufferedReader(r), DirectoryReader.this.env.absolutePath(i.getDirectory() + "/" + i.fileName + ".ms"));
            }
        });
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected <T> T read(String name, Do<T> f) throws IOException {
        InputStream stream = this.env.openFile(name);
        try {
            T t;
            BufferedReader inReader = new BufferedReader(new InputStreamReader(stream));
            try {
                t = f.run(new DoNotCloseReader(inReader));
            }
            catch (IOException e) {
                DirectoryWriter.logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            return t;
        }
        finally {
            this.env.closeFile();
        }
    }

    private static class DoNotCloseReader
    extends Reader {
        protected final Reader r;

        private DoNotCloseReader(Reader r) {
            this.r = r;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.r.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.r.read(target);
        }

        @Override
        public int read() throws IOException {
            return this.r.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.r.read(cbuf);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.r.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.r.ready();
        }

        @Override
        public boolean markSupported() {
            return this.r.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.r.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.r.reset();
        }
    }

    protected static interface Do<T> {
        public T run(Reader var1) throws IOException;
    }

    protected static class Instance {
        protected String name;
        protected int index;
        protected String fileName;

        protected Instance(int index, String fileName, String name) {
            this.name = name;
            this.index = index;
            this.fileName = fileName;
        }

        protected String getDirectory() {
            return this.index + "_" + this.fileName + "_" + this.name;
        }
    }

    public static interface ReadingEnvironment {
        public List<String> list();

        public void enterDirectory(String var1) throws IOException;

        public InputStream openFile(String var1) throws IOException;

        public URL absolutePath(String var1) throws IOException;

        public void closeFile() throws IOException;

        public void leaveDirectory() throws IOException;

        public void close() throws IOException;
    }
}

