/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.ChemistryBase.chem.PrecursorIonType;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.babelms.dot.FTDotWriter;
import de.unijena.bioinf.babelms.json.FTJsonWriter;
import de.unijena.bioinf.babelms.ms.AnnotatedSpectrumWriter;
import de.unijena.bioinf.babelms.ms.JenaMsWriter;
import de.unijena.bioinf.sirius.CSVOutputWriter;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.projectspace.AbstractProjectWriter;
import de.unijena.bioinf.sirius.projectspace.ExperimentResult;
import de.unijena.bioinf.sirius.projectspace.Index;
import de.unijena.bioinf.sirius.projectspace.OutputOptions;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWriter
extends AbstractProjectWriter {
    protected static Logger logger = LoggerFactory.getLogger(DirectoryWriter.class);
    protected int counter = 0;
    protected String currentExperimentName;
    protected WritingEnvironment W;
    private String versionString;

    public DirectoryWriter(WritingEnvironment w, String versionString) {
        this.W = w;
        this.versionString = versionString;
        this.startWriting();
    }

    @Override
    protected void startWriting() {
    }

    @Override
    public void close() throws IOException {
        this.endWriting();
        this.W.close();
    }

    @Override
    protected void endWriting() {
        try {
            this.writeVersionsInfo();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeVersionsInfo() throws IOException {
        this.write("version.txt", new Do(){

            @Override
            public void run(Writer w) throws IOException {
                DirectoryWriter.this.addVersionStrings(w);
            }
        });
    }

    protected void addVersionStrings(Writer w) {
        try {
            w.write(this.versionString);
            w.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addCitationStrings(Writer w) {
        try {
            w.write(this.versionString);
            w.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String name, Do f) throws IOException {
        OutputStream stream = this.W.openFile(name);
        try {
            BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(stream));
            try {
                f.run(new DoNotCloseWriter(outWriter));
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                try {
                    outWriter.flush();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.W.closeFile();
        }
    }

    @Override
    protected void writeInput(ExperimentResult result, Ms2Experiment experiment) throws IOException {
        ++this.counter;
        this.currentExperimentName = this.makeFileName(result);
        this.W.enterDirectory(this.currentExperimentName);
        if (this.isAllowed(OutputOptions.INPUT)) {
            this.writeMsFile(result);
        }
    }

    @Override
    protected void startWritingIdentificationResults(ExperimentResult er, List<IdentificationResult> results) throws IOException {
        if (this.isAllowed(OutputOptions.TREES_DOT) || this.isAllowed(OutputOptions.TREES_JSON)) {
            this.W.enterDirectory("trees");
            this.writeTrees(results);
            this.W.leaveDirectory();
        }
        if (this.isAllowed(OutputOptions.ANNOTATED_SPECTRA)) {
            this.W.enterDirectory("spectra");
            this.writeRecalibratedSpectra(results);
            this.W.leaveDirectory();
        }
        this.writeFormulaSummary(results);
    }

    private void writeMsFile(ExperimentResult er, List<IdentificationResult> results) throws IOException {
        final Ms2Experiment experiment = results.size() > 0 && results.get(0).getAnnotationOrNull(Ms2Experiment.class) != null ? results.get(0).getAnnotationOrNull(Ms2Experiment.class) : er.getExperiment();
        if (experiment != null) {
            this.write("spectrum.ms", new Do(){

                @Override
                public void run(Writer w) throws IOException {
                    BufferedWriter bw = new BufferedWriter(w);
                    new JenaMsWriter().write(bw, experiment);
                    bw.flush();
                }
            });
        }
    }

    private void writeFormulaSummary(final List<IdentificationResult> results) throws IOException {
        this.write("summary_sirius.csv", new Do(){

            @Override
            public void run(Writer w) throws IOException {
                CSVOutputWriter.writeHits(w, results);
            }
        });
    }

    protected void writeRecalibratedSpectra(List<IdentificationResult> results) throws IOException {
        for (IdentificationResult result : results) {
            this.writeRecalibratedSpectrum(result);
        }
    }

    protected void writeRecalibratedSpectrum(final IdentificationResult result) throws IOException {
        this.write(DirectoryWriter.makeFileName(result) + ".ms", new Do(){

            @Override
            public void run(Writer w) throws IOException {
                new AnnotatedSpectrumWriter().write(w, result.getRawTree());
            }
        });
    }

    private void writeMsFile(ExperimentResult er) throws IOException {
        final Ms2Experiment experiment = er.getExperiment();
        if (experiment != null) {
            this.write("spectrum.ms", new Do(){

                @Override
                public void run(Writer w) throws IOException {
                    BufferedWriter bw = new BufferedWriter(w);
                    new JenaMsWriter().write(bw, experiment);
                    bw.flush();
                }
            });
        }
    }

    protected void writeTrees(List<IdentificationResult> results) throws IOException {
        for (IdentificationResult result : results) {
            this.writeJSONTree(result);
            this.writeDOTTree(result);
        }
    }

    private void writeDOTTree(final IdentificationResult result) throws IOException {
        this.write(DirectoryWriter.makeFileName(result) + ".dot", new Do(){

            @Override
            public void run(Writer w) throws IOException {
                new FTDotWriter(true, true).writeTree(w, result.getRawTree());
            }
        });
    }

    private void writeJSONTree(final IdentificationResult result) throws IOException {
        this.write(DirectoryWriter.makeFileName(result) + ".json", new Do(){

            @Override
            public void run(Writer w) throws IOException {
                new FTJsonWriter().writeTree(w, result.getResolvedTree());
            }
        });
    }

    @Override
    protected void startWritingIdentificationResult(IdentificationResult result) throws IOException {
    }

    @Override
    protected void writeIdentificationResult(IdentificationResult result) throws IOException {
    }

    @Override
    protected void endWritingIdentificationResult(IdentificationResult result) throws IOException {
    }

    @Override
    protected void endWritingIdentificationResults(List<IdentificationResult> results) throws IOException {
    }

    @Override
    protected void endWritingExperiment(ExperimentResult experiment) throws IOException {
        this.W.leaveDirectory();
        this.W.updateProgress(this.currentExperimentName + "\t" + this.errorCode(experiment) + "\n");
    }

    private String errorCode(ExperimentResult experiment) {
        if (experiment.errorString == null) {
            return "DONE";
        }
        return experiment.errorString;
    }

    public static String makeFileName(IdentificationResult result) {
        String filename = result.getRank() + "_" + result.getMolecularFormula() + "_" + DirectoryWriter.simplify(result.getPrecursorIonType());
        return filename;
    }

    private static String simplify(PrecursorIonType precursorIonType) {
        return precursorIonType.toString().replaceAll("[\\[\\] _]", "");
    }

    protected String makeFileName(ExperimentResult exp) {
        int index = ((Index)exp.getExperiment().getAnnotation(Index.class, (Object)Index.NO_INDEX)).index;
        return (index >= 0 ? index : this.counter) + "_" + exp.experimentSource + "_" + exp.experimentName;
    }

    protected static interface Do {
        public void run(Writer var1) throws IOException;
    }

    public static interface WritingEnvironment {
        public void enterDirectory(String var1) throws IOException;

        public OutputStream openFile(String var1) throws IOException;

        public void closeFile() throws IOException;

        public void leaveDirectory() throws IOException;

        public void close() throws IOException;

        public void updateProgress(String var1) throws IOException;
    }

    protected static class DoNotCloseWriter
    extends Writer {
        protected final Writer w;

        public DoNotCloseWriter(Writer w) {
            this.w = w;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.w.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.w.flush();
        }

        @Override
        public void write(int c) throws IOException {
            this.w.write(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.w.write(cbuf);
        }

        @Override
        public void write(String str) throws IOException {
            this.w.write(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.w.write(str, off, len);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            return this.w.append(csq);
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            return this.w.append(csq, start, end);
        }

        @Override
        public Writer append(char c) throws IOException {
            return this.w.append(c);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

