/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.sirius.projectspace.DirectoryReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SiriusFileReader
implements DirectoryReader.ReadingEnvironment {
    protected File root;
    protected File current;
    protected InputStream currentStream;

    public SiriusFileReader(File root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this.root = root;
        this.current = root;
    }

    @Override
    public List<String> list() {
        String[] alist = this.current.list();
        if (alist == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(alist));
    }

    @Override
    public void enterDirectory(String name) throws IOException {
        this.current = new File(this.current, name);
        if (!this.current.exists()) {
            throw new IOException("Unknown directory '" + this.current + "'");
        }
    }

    @Override
    public InputStream openFile(String name) throws IOException {
        this.currentStream = new FileInputStream(new File(this.current, name));
        return this.currentStream;
    }

    @Override
    public URL absolutePath(String name) throws IOException {
        return new File(this.root, name).toURI().toURL();
    }

    @Override
    public void closeFile() throws IOException {
        this.currentStream.close();
        this.currentStream = null;
    }

    @Override
    public void leaveDirectory() throws IOException {
        this.current = this.current.getParentFile();
    }

    @Override
    public void close() throws IOException {
    }
}

