/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;

public class SiriusFileWriter
implements DirectoryWriter.WritingEnvironment {
    protected File root;
    protected BufferedWriter progressOutput = null;
    protected OutputStream currentStream = null;

    public SiriusFileWriter(File root) throws IOException {
        this.root = root;
        this.progressOutput = new BufferedWriter(new FileWriter(new File(root, ".progress")));
    }

    @Override
    public void enterDirectory(String name) {
        this.root = new File(this.root, name);
        this.root.mkdirs();
    }

    @Override
    public OutputStream openFile(String name) {
        try {
            this.currentStream = new BufferedOutputStream(new FileOutputStream(new File(this.root, name)), 32768);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.currentStream;
    }

    @Override
    public void closeFile() {
        try {
            this.currentStream.close();
            this.currentStream = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void leaveDirectory() {
        this.root = this.root.getParentFile();
    }

    @Override
    public void close() throws IOException {
        if (this.currentStream != null) {
            throw new IOException("Last file was not properly closed");
        }
        this.progressOutput.close();
    }

    @Override
    public void updateProgress(String s) throws IOException {
        this.progressOutput.write(s);
        this.progressOutput.flush();
    }
}

