/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.sirius.projectspace.DirectoryReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SiriusWorkspaceReader
implements DirectoryReader.ReadingEnvironment {
    protected ZipFile zipFile;
    protected DirectoryTree directory;
    protected ArrayList<DirectoryTree> stack;
    protected InputStream currentStream = null;
    protected File root;

    public SiriusWorkspaceReader(File file) throws IOException {
        this.zipFile = new ZipFile(file, Charset.forName("UTF-8"));
        this.root = file;
        this.directory = new DirectoryTree("");
        this.stack = new ArrayList();
        this.stack.add(this.directory);
        this.makeIndex();
    }

    protected void makeIndex() {
        Enumeration<? extends ZipEntry> zit = this.zipFile.entries();
        while (zit.hasMoreElements()) {
            ZipEntry z = zit.nextElement();
            String[] parts = z.getName().split("/");
            DirectoryTree node = this.directory;
            for (int k = 0; k < parts.length; ++k) {
                if (parts[k].isEmpty()) continue;
                node = node.getOrAdd(parts[k]);
            }
        }
    }

    @Override
    public List<String> list() {
        return new ArrayList<String>(this.stack.get((int)(this.stack.size() - 1)).children.keySet());
    }

    @Override
    public void enterDirectory(String name) throws IOException {
        DirectoryTree tree = this.stack.get((int)(this.stack.size() - 1)).children.get(name);
        if (tree == null) {
            throw new IOException("Unknown directory '" + this.join(this.stack, name) + "'");
        }
        this.stack.add(tree);
    }

    private String join(List<DirectoryTree> stack, String name) {
        StringBuilder buf = new StringBuilder();
        for (DirectoryTree t : stack) {
            buf.append(t.name).append('/');
        }
        buf.append(name);
        return buf.toString();
    }

    @Override
    public InputStream openFile(String name) throws IOException {
        this.currentStream = this.zipFile.getInputStream(this.zipFile.getEntry(this.join(this.stack.subList(1, this.stack.size()), name)));
        return this.currentStream;
    }

    @Override
    public URL absolutePath(String name) throws IOException {
        return new URL("jar:file:/" + this.root.getAbsolutePath() + "!/" + name);
    }

    @Override
    public void closeFile() throws IOException {
        this.currentStream.close();
    }

    @Override
    public void leaveDirectory() throws IOException {
        this.stack.remove(this.stack.size() - 1);
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    protected static class DirectoryTree {
        protected HashMap<String, DirectoryTree> children = EMPTY;
        protected static HashMap<String, DirectoryTree> EMPTY = new HashMap();
        protected String name;

        protected DirectoryTree(String name) {
            this.name = name;
        }

        protected int degree() {
            return this.children.size();
        }

        protected DirectoryTree addChild(String name) {
            if (this.children == EMPTY) {
                this.children = new HashMap();
            }
            DirectoryTree child = new DirectoryTree(name);
            this.children.put(name, child);
            return child;
        }

        protected DirectoryTree getOrAdd(String name) {
            DirectoryTree c = this.children.get(name);
            if (c == null) {
                c = this.addChild(name);
            }
            return c;
        }
    }
}

