/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.sirius.projectspace;

import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SiriusWorkspaceWriter
implements DirectoryWriter.WritingEnvironment {
    protected ZipOutputStream zip;
    protected List<String> pathElements;

    public SiriusWorkspaceWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public SiriusWorkspaceWriter(OutputStream stream) {
        this.zip = new ZipOutputStream(stream, Charset.forName("UTF-8"));
        this.pathElements = new ArrayList<String>();
    }

    @Override
    public void enterDirectory(String name) {
        this.pathElements.add(name);
        try {
            this.zip.putNextEntry(new ZipEntry(this.join(this.pathElements)));
            this.zip.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String join(List<String> pathElements) {
        StringBuilder buf = new StringBuilder(pathElements.size() * 8);
        for (String p : pathElements) {
            buf.append(p).append('/');
        }
        return buf.toString();
    }

    @Override
    public OutputStream openFile(String name) {
        try {
            this.zip.putNextEntry(new ZipEntry(this.join(this.pathElements) + name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.zip;
    }

    @Override
    public void closeFile() {
        try {
            this.zip.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public void leaveDirectory() {
        this.pathElements.remove(this.pathElements.size() - 1);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    @Override
    public void updateProgress(String s) throws IOException {
    }
}

