/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.PredictionPerformance;
import de.unijena.bioinf.ChemistryBase.properties.PropertyManager;
import de.unijena.bioinf.fingerid.blast.Fingerblast;
import de.unijena.bioinf.fingerid.blast.FingerblastScoringMethod;
import de.unijena.bioinf.fingerid.blast.ScoringMethodFactory;
import de.unijena.bioinf.fingerid.db.CustomDatabase;
import de.unijena.bioinf.fingerid.db.SearchableDatabase;
import de.unijena.bioinf.fingerid.db.SearchableDbOnDisc;
import de.unijena.bioinf.fingerid.net.CachedRESTDB;
import de.unijena.bioinf.fingerid.net.VersionsInfo;
import de.unijena.bioinf.fingerid.net.WebAPI;
import de.unijena.bioinf.fingeriddb.job.PredictorType;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class CSIPredictor {
    protected final PredictorType predictorType;
    protected CachedRESTDB database;
    protected MaskedFingerprintVersion fpVersion;
    protected Fingerblast blaster;
    protected PredictionPerformance[] performances;
    protected boolean initialized;
    protected SearchableDatabase bio;
    protected SearchableDatabase pubchem;

    public CSIPredictor(PredictorType predictorType) {
        this.predictorType = predictorType;
    }

    public PredictorType getPredictorType() {
        return this.predictorType;
    }

    public CachedRESTDB getDatabase() {
        return this.database;
    }

    public MaskedFingerprintVersion getFingerprintVersion() {
        return this.fpVersion;
    }

    public Fingerblast getBlaster() {
        return this.blaster;
    }

    public PredictionPerformance[] getPerformances() {
        return this.performances;
    }

    public SearchableDatabase getBio() {
        return this.bio;
    }

    public SearchableDatabase getPubchem() {
        return this.pubchem;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IOException {
        try (WebAPI webAPI = WebAPI.newInstance();){
            int[] fingerprintIndizes;
            TIntArrayList list = new TIntArrayList(4096);
            PredictionPerformance[] perf = webAPI.getStatistics(this.predictorType, list);
            CdkFingerprintVersion version = (CdkFingerprintVersion)WebAPI.getFingerprintVersion();
            MaskedFingerprintVersion.Builder v = MaskedFingerprintVersion.buildMaskFor((FingerprintVersion)version);
            v.disableAll();
            for (int index : fingerprintIndizes = list.toArray()) {
                v.enable(index);
            }
            MaskedFingerprintVersion fingerprintVersion = v.toMask();
            ScoringMethodFactory.CSIFingerIdScoringMethod method = this.predictorType == PredictorType.CSI_FINGERID_NEGATIVE ? new ScoringMethodFactory.CSIFingerIdScoringMethod(perf) : webAPI.getCovarianceScoring((FingerprintVersion)fingerprintVersion, 1.0 / perf[0].withPseudoCount(0.25).numberOfSamples());
            List<CustomDatabase> cds = CustomDatabase.customDatabases(true);
            CSIPredictor cSIPredictor = this;
            synchronized (cSIPredictor) {
                this.performances = perf;
                this.fpVersion = fingerprintVersion;
                this.blaster = new Fingerblast((FingerblastScoringMethod)method, null);
                this.initialized = true;
                this.refreshCacheDir();
            }
        }
    }

    public void refreshCacheDir() throws IOException {
        try (WebAPI webAPI = WebAPI.newInstance();){
            File directory = this.getDefaultDirectory();
            VersionsInfo versionsInfo = webAPI.getVersionInfo();
            this.database = new CachedRESTDB(versionsInfo, this.fpVersion, directory);
            this.bio = new SearchableDbOnDisc("biological database", new File(directory, "bio"), false, true, false);
            this.pubchem = new SearchableDbOnDisc("PubChem", new File(directory, "not-bio"), true, true, false);
            this.database.checkCache();
        }
    }

    public List<SearchableDatabase> getAvailableDatabases() {
        ArrayList<SearchableDatabase> db = new ArrayList<SearchableDatabase>();
        db.add(this.pubchem);
        db.add(this.bio);
        db.addAll(CustomDatabase.customDatabases(true));
        return db;
    }

    public File getDefaultDirectory() {
        String val = PropertyManager.PROPERTIES.getProperty("de.unijena.bioinf.sirius.fingerID.cache");
        return Paths.get(val, new String[0]).toFile();
    }
}

