/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.chemdb.DBLink;
import de.unijena.bioinf.chemdb.DatasourceService;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.fingerid.Compound;
import de.unijena.bioinf.fingerid.FingerIdResult;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CSVExporter {
    public void exportFingerIdResults(Writer writer, List<FingerIdResult> results) throws IOException {
        writer.write("inchikey2D\tinchi\tmolecularFormula\trank\tscore\tname\tsmiles\txlogp\tpubchemids\tlinks\n");
        ArrayList<Scored<FingerprintCandidate>> candidates = new ArrayList<Scored<FingerprintCandidate>>();
        for (FingerIdResult r : results) {
            candidates.addAll(r.getCandidates());
        }
        Collections.sort(candidates, Scored.desc());
        HashMultimap dbMap = HashMultimap.create();
        ArrayList<String> pubchemIds = new ArrayList<String>();
        int rank = 0;
        for (Scored scored : candidates) {
            writer.write(((FingerprintCandidate)scored.getCandidate()).getInchiKey2D());
            writer.write(9);
            writer.write(((FingerprintCandidate)scored.getCandidate()).getInchi().in2D);
            writer.write(9);
            writer.write(((FingerprintCandidate)scored.getCandidate()).getInchi().extractFormula().toString());
            writer.write(9);
            writer.write(String.valueOf(++rank));
            writer.write(9);
            writer.write(String.valueOf(scored.getScore()));
            writer.write(9);
            writer.write(CSVExporter.escape(((FingerprintCandidate)scored.getCandidate()).getName()));
            writer.write(9);
            writer.write(CSVExporter.escape(((FingerprintCandidate)scored.getCandidate()).getSmiles()));
            writer.write(9);
            writer.write("");
            writer.write(9);
            pubchemIds.clear();
            dbMap.clear();
            for (DBLink l : ((FingerprintCandidate)scored.getCandidate()).getLinks()) {
                if (l.name.equals(DatasourceService.Sources.PUBCHEM.name)) {
                    pubchemIds.add(l.id);
                    continue;
                }
                dbMap.put((Object)l.name, (Object)l.id);
            }
            writer.write(Joiner.on((char)';').join(pubchemIds));
            writer.write(9);
            CSVExporter.links(writer, (Multimap<String, String>)dbMap);
            writer.write(10);
        }
    }

    public static void list(Writer writer, int[] pubchemIds) throws IOException {
        if (pubchemIds == null || pubchemIds.length == 0) {
            writer.write("\"\"");
        } else {
            writer.write(String.valueOf(pubchemIds[0]));
            for (int i = 1; i < pubchemIds.length; ++i) {
                writer.write(59);
                writer.write(String.valueOf(pubchemIds[i]));
            }
        }
    }

    public static void links(Writer w, Compound c) throws IOException {
        if (c.databases == null) {
            w.write("\"\"");
            return;
        }
        CSVExporter.links(w, c.databases);
    }

    public static void links(Writer w, Multimap<String, String> databases) throws IOException {
        Iterator iter = databases.asMap().entrySet().iterator();
        if (!iter.hasNext()) {
            w.write("\"\"");
            return;
        }
        Map.Entry x = iter.next();
        w.write((String)x.getKey());
        Collection<String> col = CSVExporter.withoutNulls((Collection)x.getValue());
        if (col.size() > 0) {
            w.write(":(");
            w.write(CSVExporter.escape(Joiner.on((char)' ').join(col)));
            w.write(")");
        }
        while (iter.hasNext()) {
            w.write(59);
            x = iter.next();
            w.write((String)x.getKey());
            col = CSVExporter.withoutNulls((Collection)x.getValue());
            if (col.size() <= 0) continue;
            w.write(":(");
            w.write(CSVExporter.escape(Joiner.on((char)' ').join(col)));
            w.write(")");
        }
    }

    public static String escape(String name) {
        if (name == null) {
            return "\"\"";
        }
        return name.replace('\t', ' ').replace('\"', '\'');
    }

    public static Collection<String> withoutNulls(Collection<String> in) {
        return Collections2.filter(in, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input != null;
            }
        });
    }
}

