/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.unijena.bioinf.ChemistryBase.chem.CompoundWithAbstractFP;
import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.chem.Smiles;
import de.unijena.bioinf.ChemistryBase.fp.AbstractFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.ArrayFingerprint;
import de.unijena.bioinf.ChemistryBase.fp.CdkFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.Fingerprint;
import de.unijena.bioinf.ChemistryBase.fp.FingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.MaskedFingerprintVersion;
import de.unijena.bioinf.ChemistryBase.fp.ProbabilityFingerprint;
import de.unijena.bioinf.chemdb.CompoundCandidateChargeLayer;
import de.unijena.bioinf.chemdb.CompoundCandidateChargeState;
import de.unijena.bioinf.chemdb.DBLink;
import de.unijena.bioinf.chemdb.DatasourceService;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.fingerid.db.CustomDataSourceService;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TShortArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.descriptors.molecular.XLogPDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compound {
    private static Compound PrototypeCompound;
    private static Logger logger;
    protected InChI inchi;
    protected Smiles smiles;
    protected String name;
    private volatile IAtomContainer molecule;
    protected double xlogP = Double.NaN;
    protected long bitset;
    protected Fingerprint fingerprint;
    protected Multimap<String, String> databases;
    protected int[] pubchemIds;
    protected int pLayer;
    protected int qLayer;

    protected static Compound getPrototypeCompound() {
        if (PrototypeCompound != null) {
            return PrototypeCompound;
        }
        PrototypeCompound = new Compound();
        Compound.PrototypeCompound.inchi = new InChI("WQZGKKKJIJFFOK-GASJEMHNSA-N", "InChI=1S/C6H12O6/c7-1-2-3(8)4(9)5(10)6(11)12-2/h2-11H,1H2/t2-,3-,4+,5-,6?/m1/s1");
        Compound.PrototypeCompound.smiles = new Smiles("OC[C@H]1OC(O)[C@H](O)[C@@H](O)[C@@H]1O");
        Compound.PrototypeCompound.name = "Glucose";
        Compound.PrototypeCompound.pubchemIds = new int[]{5793};
        Compound.PrototypeCompound.fingerprint = new ArrayFingerprint((FingerprintVersion)CdkFingerprintVersion.getDefault(), new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 34, 35, 38, 80, 120});
        return PrototypeCompound;
    }

    protected Compound(FingerprintCandidate candidate) {
        this.inchi = candidate.getInchi();
        this.smiles = new Smiles(candidate.getSmiles());
        this.name = candidate.getName();
        this.bitset = candidate.getBitset();
        this.fingerprint = candidate.getFingerprint();
        Set names = DatasourceService.getDataSourcesFromBitFlags((long)candidate.getBitset());
        this.databases = ArrayListMultimap.create((int)names.size(), (int)1);
        if (candidate.getLinks() != null) {
            for (DBLink link : candidate.getLinks()) {
                this.databases.put((Object)link.name, (Object)link.id);
            }
        }
        for (String aname : names) {
            if (this.databases.containsKey((Object)aname)) continue;
            this.databases.put((Object)aname, null);
        }
        this.pLayer = candidate.getpLayer();
        this.qLayer = candidate.getqLayer();
        this.xlogP = candidate.getXlogp();
    }

    public long getBitset() {
        return this.bitset;
    }

    protected Compound() {
    }

    public CompoundWithAbstractFP<ProbabilityFingerprint> asQuery(ProbabilityFingerprint probFp) {
        return new CompoundWithAbstractFP(this.inchi, (AbstractFingerprint)probFp);
    }

    public CompoundWithAbstractFP<Fingerprint> asCandidate() {
        return new CompoundWithAbstractFP(this.inchi, (AbstractFingerprint)this.fingerprint);
    }

    public FingerprintCandidate asFingerprintCandidate() {
        FingerprintCandidate fc = new FingerprintCandidate(this.inchi, this.fingerprint);
        fc.setBitset(this.bitset);
        ArrayList<DBLink> links = new ArrayList<DBLink>();
        if (this.pubchemIds != null) {
            for (int i : this.pubchemIds) {
                links.add(new DBLink(DatasourceService.Sources.PUBCHEM.name(), String.valueOf(i)));
            }
        }
        if (this.databases != null) {
            Object object = this.databases.entries().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                links.add(new DBLink((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        fc.setLinks(links.toArray(new DBLink[links.size()]));
        if (this.name != null) {
            fc.setName(this.name);
        }
        if (this.smiles != null) {
            fc.setSmiles(this.smiles.smiles);
        }
        fc.setpLayer(this.pLayer);
        fc.setqLayer(this.qLayer);
        fc.setXlogp(this.xlogP);
        return fc;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Compound> parseCompounds(MaskedFingerprintVersion version, List<Compound> compounds, JsonParser parser) {
        if (parser.next() != JsonParser.Event.START_OBJECT) {
            throw new JsonException("Expect json object");
        }
        if (!Compound.findTopLevelKey(parser, "compounds")) {
            throw new JsonException("Do not find any compounds for given molecular formula");
        }
        if (parser.next() != JsonParser.Event.START_ARRAY) {
            throw new JsonException("Expect array of compounds");
        }
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    compounds.add(Compound.parseFromJSON(parser, version));
                    break;
                }
                case END_ARRAY: {
                    return compounds;
                }
            }
        }
        return compounds;
    }

    private static boolean findTopLevelKey(JsonParser parser, String keyname) {
        int intendation = 0;
        block5: while (true) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++intendation;
                    break;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    if (--intendation >= 0) break;
                    return false;
                }
                case KEY_NAME: {
                    if (intendation != 0 || !parser.getString().equals(keyname)) continue block5;
                    return true;
                }
            }
        }
    }

    public static Compound parseFromJSON(JsonParser parser, MaskedFingerprintVersion version) {
        Compound compound = new Compound();
        String inchi = null;
        String inchikey = null;
        long flags = 0L;
        int pLayer = 0;
        int qLayer = 0;
        double xlogp = Double.NaN;
        while (true) {
            JsonParser.Event event = parser.next();
            block0 : switch (event) {
                case KEY_NAME: {
                    String name;
                    switch (name = parser.getString()) {
                        case "inchi": {
                            inchi = Compound.expectString(parser);
                            break block0;
                        }
                        case "inchikey": {
                            inchikey = Compound.expectString(parser);
                            break block0;
                        }
                        case "name": {
                            compound.name = Compound.expectString(parser);
                            break block0;
                        }
                        case "smiles": {
                            compound.smiles = new Smiles(Compound.expectString(parser));
                            break block0;
                        }
                        case "fingerprint": {
                            Compound.expectArray(parser);
                            TShortArrayList values = new TShortArrayList(100);
                            while (Compound.consumeShorts(parser, values)) {
                            }
                            compound.fingerprint = version == null ? new ArrayFingerprint((FingerprintVersion)CdkFingerprintVersion.getDefault(), values.toArray()) : version.mask(values.toArray());
                            break block0;
                        }
                        case "bitset": {
                            flags = Compound.expectLong(parser);
                            break block0;
                        }
                        case "links": {
                            Compound.parseLinks(compound, parser);
                            break block0;
                        }
                        case "pLayer": {
                            pLayer = Compound.expectInt(parser);
                            break block0;
                        }
                        case "qLayer": {
                            qLayer = Compound.expectInt(parser);
                            break block0;
                        }
                        case "xlogp": {
                            xlogp = Compound.expectDouble(parser);
                        }
                    }
                    break;
                }
                case END_OBJECT: {
                    compound.inchi = new InChI(inchikey, inchi);
                    compound.bitset = flags;
                    Set names = DatasourceService.getDataSourcesFromBitFlags((long)flags);
                    if (compound.databases != null) {
                        for (String aname : names) {
                            if (compound.databases.containsKey((Object)aname)) continue;
                            compound.addDatabase(aname, null);
                        }
                    } else {
                        compound.databases = ArrayListMultimap.create((int)names.size(), (int)1);
                        for (String aname : names) {
                            compound.addDatabase(aname, null);
                        }
                    }
                    compound.pLayer = pLayer;
                    compound.qLayer = qLayer;
                    compound.xlogP = xlogp;
                    return compound;
                }
            }
        }
    }

    private static void expectArray(JsonParser parser) {
        JsonParser.Event event = parser.next();
        if (event != JsonParser.Event.START_ARRAY) {
            throw new JsonException("expected array value but '" + event.name() + "' is given.");
        }
    }

    private static boolean consumeShorts(JsonParser parser, TShortArrayList values) {
        JsonParser.Event event = parser.next();
        if (event == JsonParser.Event.END_ARRAY) {
            return false;
        }
        if (event != JsonParser.Event.VALUE_NUMBER) {
            throw new JsonException("expected number value but '" + event.name() + "' is given.");
        }
        values.add((short)parser.getInt());
        return true;
    }

    private static int expectInt(JsonParser parser) {
        JsonParser.Event event = parser.next();
        if (event != JsonParser.Event.VALUE_NUMBER) {
            throw new JsonException("expected number value but '" + event.name() + "' is given.");
        }
        return parser.getInt();
    }

    private static long expectLong(JsonParser parser) {
        JsonParser.Event event = parser.next();
        if (event != JsonParser.Event.VALUE_NUMBER) {
            throw new JsonException("expected number value but '" + event.name() + "' is given.");
        }
        return parser.getLong();
    }

    private static double expectDouble(JsonParser parser) {
        JsonParser.Event event = parser.next();
        if (event != JsonParser.Event.VALUE_NUMBER) {
            throw new JsonException("expected number value but '" + event.name() + "' is given.");
        }
        return parser.getBigDecimal().doubleValue();
    }

    private static void parseLinks(Compound compound, JsonParser parser) {
        if (parser.next() != JsonParser.Event.START_OBJECT) {
            throw new JsonException("expected start of dictionary");
        }
        TIntArrayList pubchemIds = new TIntArrayList(10);
        block4: while (true) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case KEY_NAME: {
                    JsonParser.Event anevent;
                    String dbname = parser.getString();
                    boolean pubchem = dbname.equals(DatasourceService.Sources.PUBCHEM.name);
                    if (compound.databases == null) {
                        compound.databases = ArrayListMultimap.create((int)5, (int)1);
                    }
                    if (parser.next() != JsonParser.Event.START_ARRAY) {
                        throw new JsonException("expected start of array");
                    }
                    while ((anevent = parser.next()) != JsonParser.Event.END_ARRAY) {
                        if (anevent != JsonParser.Event.VALUE_STRING) continue;
                        String id = parser.getString();
                        if (pubchem) {
                            pubchemIds.add(Integer.parseInt(id));
                        }
                        compound.databases.put((Object)dbname, (Object)id);
                    }
                    continue block4;
                }
                case END_OBJECT: {
                    compound.pubchemIds = pubchemIds.toArray();
                    return;
                }
            }
        }
    }

    private static String expectString(JsonParser parser) {
        JsonParser.Event event = parser.next();
        if (event != JsonParser.Event.VALUE_STRING) {
            throw new JsonException("expected string value but '" + event.name() + "' is given.");
        }
        return parser.getString();
    }

    public IAtomContainer getMolecule() {
        if (this.molecule == null) {
            this.molecule = this.parseMoleculeFromInChi();
        }
        return this.molecule;
    }

    public boolean hasAtomContainer() {
        return this.molecule != null;
    }

    private IAtomContainer parseMoleculeFromInChi() {
        try {
            InChIGeneratorFactory f = InChIGeneratorFactory.getInstance();
            InChIToStructure s = f.getInChIToStructure(this.inchi.in2D, SilentChemObjectBuilder.getInstance());
            if (s.getReturnStatus() == INCHI_RET.OKAY && (s.getReturnStatus() == INCHI_RET.OKAY || s.getReturnStatus() == INCHI_RET.WARNING)) {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)s.getAtomContainer());
                return s.getAtomContainer();
            }
            logger.warn("Cannot parse InChI: " + String.valueOf(this.inchi.in2D) + " due to the following error: " + String.valueOf(s.getMessage() + " Return code: " + s.getReturnStatus() + ", Return status: " + s.getReturnStatus().toString()));
            return this.parseMoleculeFromSmiles();
        }
        catch (CDKException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            return this.parseMoleculeFromSmiles();
        }
    }

    public void calculateXlogP() {
        if (Double.isNaN(this.xlogP)) {
            try {
                XLogPDescriptor logPDescriptor = new XLogPDescriptor();
                logPDescriptor.setParameters(new Object[]{true, true});
                this.xlogP = ((DoubleResult)logPDescriptor.calculate(this.getMolecule()).getValue()).doubleValue();
            }
            catch (CDKException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void generateInchiIfNull() {
        try {
            if (this.inchi == null) {
                InChIGenerator gen = InChIGeneratorFactory.getInstance().getInChIGenerator(this.getMolecule());
                this.inchi = new InChI(gen.getInchiKey(), gen.getInchi());
            }
        }
        catch (CDKException e) {
            LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }

    private IAtomContainer parseMoleculeFromSmiles() {
        try {
            IAtomContainer c = new SmilesParser(SilentChemObjectBuilder.getInstance()).parseSmiles(this.smiles.smiles);
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)c);
            return c;
        }
        catch (CDKException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean[] stringToBoolean(String fingerprint, int[] fingerprintIndizes) {
        boolean[] values = new boolean[fingerprintIndizes.length];
        for (int k = 0; k < fingerprintIndizes.length; ++k) {
            if (fingerprint.charAt(fingerprintIndizes[k]) != '1') continue;
            values[k] = true;
        }
        return values;
    }

    public static void merge(List<FingerprintCandidate> candidates, File file) throws IOException {
        MaskedFingerprintVersion mv = null;
        if (candidates.size() > 0) {
            FingerprintVersion v = candidates.get(0).getFingerprint().getFingerprintVersion();
            mv = v instanceof MaskedFingerprintVersion ? (MaskedFingerprintVersion)v : MaskedFingerprintVersion.buildMaskFor((FingerprintVersion)v).enableAll().toMask();
        }
        Compound.merge(mv, candidates, file);
    }

    public static int merge(FingerprintVersion version, List<FingerprintCandidate> candidates, File file) throws IOException {
        int sizeDiff = 0;
        MaskedFingerprintVersion mv = version instanceof MaskedFingerprintVersion ? (MaskedFingerprintVersion)version : MaskedFingerprintVersion.buildMaskFor((FingerprintVersion)version).enableAll().toMask();
        HashMap<String, FingerprintCandidate> compoundPerInchiKey = new HashMap<String, FingerprintCandidate>();
        for (FingerprintCandidate fc : candidates) {
            compoundPerInchiKey.put(fc.getInchiKey2D(), fc);
        }
        sizeDiff = compoundPerInchiKey.size();
        if (file.exists()) {
            ArrayList<Compound> compounds = new ArrayList<Compound>();
            JsonParser parser = Json.createParser((InputStream)new GZIPInputStream(new FileInputStream(file)));
            Object object = null;
            try {
                Compound.parseCompounds(mv, compounds, parser);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (parser != null) {
                    if (object != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        parser.close();
                    }
                }
            }
            for (Compound c : compounds) {
                if (compoundPerInchiKey.containsKey(c.inchi.key2D())) {
                    --sizeDiff;
                    continue;
                }
                compoundPerInchiKey.put(c.inchi.key2D(), c.asFingerprintCandidate());
            }
        }
        JsonGenerator writer = Json.createGenerator((OutputStream)new GZIPOutputStream(new FileOutputStream(file)));
        Object object = null;
        try {
            writer.writeStartObject();
            writer.writeStartArray("compounds");
            for (FingerprintCandidate fc : compoundPerInchiKey.values()) {
                fc.writeToJSON(writer, true);
            }
            writer.writeEnd();
            writer.writeEnd();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (object != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
        return sizeDiff;
    }

    public InChI getInchi() {
        return this.inchi;
    }

    public Smiles getSmiles() {
        return this.smiles;
    }

    public String getName() {
        return this.name;
    }

    public double getXlogP() {
        return this.xlogP;
    }

    public Fingerprint getFingerprint() {
        return this.fingerprint;
    }

    public void addDatabase(String name, String id) {
        CustomDataSourceService.Source c = CustomDataSourceService.getSourceFromName(name);
        if (c == null) {
            System.out.println("SCHOULD NOT BE ADDED");
        }
        long bit = c.flag();
        this.databases.put((Object)name, (Object)id);
        this.bitset |= bit;
    }

    public boolean canBeNeutralCharged() {
        return this.hasChargeState(CompoundCandidateChargeState.NEUTRAL_CHARGE);
    }

    public boolean canBePositivelyCharged() {
        return this.hasChargeState(CompoundCandidateChargeState.POSITIVE_CHARGE);
    }

    public boolean canBeNegativelyCharged() {
        return this.hasChargeState(CompoundCandidateChargeState.NEGATIVE_CHARGE);
    }

    public boolean hasChargeState(CompoundCandidateChargeState chargeState) {
        return this.hasChargeState(this.pLayer, chargeState.getValue()) || this.hasChargeState(this.qLayer, chargeState.getValue());
    }

    public boolean hasChargeState(CompoundCandidateChargeLayer chargeLayer, CompoundCandidateChargeState chargeState) {
        return chargeLayer == CompoundCandidateChargeLayer.P_LAYER ? this.hasChargeState(this.pLayer, chargeState.getValue()) : this.hasChargeState(this.qLayer, chargeState.getValue());
    }

    private boolean hasChargeState(int chargeLayer, int chargeState) {
        return (chargeLayer & chargeState) == chargeState;
    }

    static {
        logger = LoggerFactory.getLogger(Compound.class);
    }
}

