/*
 * Decompiled with CFR 0.152.
 */
package de.unijena.bioinf.fingerid;

import de.unijena.bioinf.ChemistryBase.algorithm.Scored;
import de.unijena.bioinf.ChemistryBase.chem.InChI;
import de.unijena.bioinf.ChemistryBase.ms.Ms2Experiment;
import de.unijena.bioinf.chemdb.DBLink;
import de.unijena.bioinf.chemdb.DatasourceService;
import de.unijena.bioinf.chemdb.FingerprintCandidate;
import de.unijena.bioinf.fingerid.FingerIdResult;
import de.unijena.bioinf.sirius.IdentificationResult;
import de.unijena.bioinf.sirius.projectspace.DirectoryReader;
import de.unijena.bioinf.sirius.projectspace.DirectoryWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FingerIdResultReader
extends DirectoryReader {
    private static Pattern DBPAT = Pattern.compile("([^(])+\\(([^)]+)\\)");

    public FingerIdResultReader(DirectoryReader.ReadingEnvironment env) {
        super(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetaData(Ms2Experiment input, List<IdentificationResult> results) throws IOException {
        super.addMetaData(input, results);
        if (!new HashSet(this.env.list()).contains("csi_fingerid")) {
            return;
        }
        try {
            this.env.enterDirectory("csi_fingerid");
            HashSet files = new HashSet(this.env.list());
            for (IdentificationResult r : results) {
                String s = DirectoryWriter.makeFileName((IdentificationResult)r) + ".csv";
                if (!files.contains(s)) continue;
                r.setAnnotation(FingerIdResult.class, this.read(s, (DirectoryReader.Do)new DirectoryReader.Do<FingerIdResult>(){

                    public FingerIdResult run(Reader r) throws IOException {
                        BufferedReader br = new BufferedReader(r);
                        String line = br.readLine();
                        ArrayList<Scored<FingerprintCandidate>> fpcs = new ArrayList<Scored<FingerprintCandidate>>();
                        while ((line = br.readLine()) != null) {
                            String[] tabs = line.split("\t");
                            FingerprintCandidate fpc = new FingerprintCandidate(new InChI(tabs[0], tabs[1]), null);
                            fpc.setName(tabs[5]);
                            fpc.setSmiles(tabs[6]);
                            ArrayList<DBLink> links = new ArrayList<DBLink>();
                            for (String pubchemId : tabs[8].split(";")) {
                                links.add(new DBLink(DatasourceService.Sources.PUBCHEM.name, pubchemId));
                            }
                            for (String dbPair : tabs[9].split(";")) {
                                Matcher m = DBPAT.matcher(dbPair);
                                if (!m.find()) continue;
                                String dbName = m.group(1);
                                for (String id : m.group(2).split(" ")) {
                                    links.add(new DBLink(dbName, id));
                                }
                            }
                            fpc.setLinks(links.toArray(new DBLink[links.size()]));
                            fpcs.add((Scored<FingerprintCandidate>)new Scored((Object)fpc, Double.parseDouble(tabs[4])));
                        }
                        return new FingerIdResult(fpcs, 0.0, null, null);
                    }
                }));
            }
        }
        finally {
            this.env.leaveDirectory();
        }
    }
}

